"use strict";
this.name           = "assassins_rebooted_miner_depot.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also adds adds ships and mission ships depending on the stage";
//  Code borrowed from "Anarchies" via "Fuel Station" for convenience.

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
delete this.shipSpawned; 
pos = this.ship.position;
// Add an asteroid field around the Depot.
system.addShips("assassins_rebooted_miner_rock",40,pos,18000);
// Add 3 Bug Miners with an AI to mine stuff.
system.addShips("assassins_rebooted_bug_miner",1,pos,10000); 
system.addShips("assassins_rebooted_bug_miner",1,pos,12000); 
system.addShips("assassins_rebooted_bug_miner",1,pos,14000); 
// Add a group of 3 Bug Fighters (Leader and 2 Wingmen) to patrol the asteroid field.
system.legacy_addShipsAtPrecisely("assassins_rebooted_bug_patrol", 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))

// Add the dueling beacon and O-Ren Ishi for the 6th Hit.


// Closing Bracket for this ship spawned.
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
