"use strict";
this.name           = "assassins_rebooted_mafia_target_dummy_type1.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Used to spawn attacking triad ships near its location.";

this.shipSpawned = function()
{
// In case the ship has been called as a standard role and has thus had a bounty added by the populater, set the bounty back to zero for lawful ships.
this.ship.bounty = 0;
// Add attacking Triad Ships.
pos = this.ship.position;
system.addShips("assassins_rebooted_triad_gecko1",1,pos,1000);
system.addShips("assassins_rebooted_triad_krait1",1,pos,2000);
system.addShips("assassins_rebooted_triad_mamba1",1,pos,3000);
system.addShips("assassins_rebooted_triad_moray1",1,pos,4000);
// Add Target Dummy 2 (this ships script also spawns Triad Ships near its position to attack it.
system.addShips("assassins_rebooted_mafia_target_dummy_type2",1,pos.add([5000,0,0]), 2000)[0];
// Add 2 normal mafia Annaconda with an AI to join the battle once the player arrives.
system.addShips("assassins_rebooted_mafia_protector",1,pos.add([8000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_mafia_protector",1,pos.add([6000,0,0]), 1000)[0];
// Add Target Dummy 3 (attacked by Victim 7 and its escorts until the player arrives).
system.addShips("assassins_rebooted_mafia_target_dummy_type3",1,pos.add([10000,0,0]), 1000)[0];
}

// Ships and Stations added by the OXZ have the roles lawful or chaotic in addition to their normal roles.
// Lawful ships will never target each other, so will only hit each other by accident when shooting at another target
// All the lawful ships have zero bountys so also won't be targeted by police ships either.
// If hit by a police ship or a member of it's own faction then the scipt messages the AI not to attack the other ship and instead wait for 2 seconds before returing to what
// it was doing before it was hit. If the player is the attacker then attacking a lawful ship will make the player a fugertive. The ship which hit the ship will also get a friendly fire
// warning and its AI will stop firing to for a few seconds. 
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1 || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// Target lock is still broken in case the attacker deliberitly targeted a ship on its own side due to it being awarded a bounty.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 51;
}
// End of this.shipDied
}
