"use strict";
this.name           = "assassins_rebooted_griff_research_orbital_base.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also Spawns its associated ships nearby.";
//  Code borrowed from "Anarchies" via "Fuel Station" for convenience.


this.shipSpawned = function()
{
// Turn the Station's dock to face the main system station.
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
// Add the prototype battlebots and control node if the development level variable is at 0 (ie they havent built the working type yet in the OXZ's story).
if (missionVariables.assassins_rebooted_battlebot_development_level === 0) {
system.legacy_addShipsAtPrecisely("assassins_rebooted_prototype_battlebot_node", 1, "abs", this.ship.position.add(this.ship.heading.multiply(9000))) 
system.addShips("assassins_rebooted_prototype_battlebot", 15, this.ship.position, 10000);
}
// When the variable is at 1, Unarmed Naval BattleBots are being tested 
if (missionVariables.assassins_rebooted_battlebot_development_level === 1) {
system.legacy_addShipsAtPrecisely("assassins_rebooted_prototype_battlebot_node", 1, "abs", this.ship.position.add(this.ship.heading.multiply(9000))) 
system.addShips("assassins_rebooted_prototype_battlebot_type2", 15, this.ship.position, 10000);
}
// When the variable is at 2, a Military Control Drone with Military BattleBot escorts patrols the base and will attack thargoids and criminals. 
// An alternative version of the Positronic Brain also appears when the development level is at 2. It will now be testing Unarmed BattleBot Interceptors, who along with the working
// drone and BattleBots are immune to being shut down by ECM.
if (missionVariables.assassins_rebooted_battlebot_development_level === 2) {
system.legacy_addShipsAtPrecisely("assassins_rebooted_navy_control_drone_local_patrol", 1, "abs", this.ship.position.add(this.ship.heading.multiply(15000))) 
system.legacy_addShipsAtPrecisely("assassins_rebooted_prototype_battlebot_node_alt", 1, "abs", this.ship.position.add(this.ship.heading.multiply(9000))) 
system.addShips("assassins_rebooted_prototype_battlebot_type3", 10, this.ship.position, 10000);
}
// When the variable is at 3, or the development is complete, the Control Drone with BattleBot escorts appears as before. The Brain no longer appears and instead
// a squad of BattleBot Intercepters patrol the base along with the Control Drone and BattleBot escorts..
if (missionVariables.assassins_rebooted_battlebot_development_level === 3 || missionVariables.assassins_rebooted_battlebot_development_level ==="Complete") {
system.legacy_addShipsAtPrecisely("assassins_rebooted_navy_control_drone_local_patrol_alt", 1, "abs", this.ship.position.add(this.ship.heading.multiply(15000))) 
system.legacy_addShipsAtPrecisely("assassins_rebooted_interceptor_battlebot_local_patrol_leader", 1, "abs", this.ship.position.add(this.ship.heading.multiply(20000))) 
// Add a group of 3 BattleBots 750kms out from the Base with an AI to return to the Base.
 system.legacy_addShipsAtPrecisely("assassins_rebooted_police-battlebot_homebound_patrol_leader", 1, "abs", this.ship.position.add(this.ship.heading.multiply(750000))) 
// Add a group of 3 BattleBots 1,500kms out from the Base with an AI to go to the Witchpoint
 system.legacy_addShipsAtPrecisely("assassins_rebooted_police-battlebot_witchpoint_patrol_leader", 1, "abs", this.ship.position.add(this.ship.heading.multiply(1500000))) 
// Add a group of 3 BattleBots 2,000kms out from the Base with an AI to go to the Main Planet.
 system.legacy_addShipsAtPrecisely("assassins_rebooted_police-battlebot_planet_patrol_leader", 1, "abs", this.ship.position.add(this.ship.heading.multiply(2000000))) 
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
