this.name           = "assassins_rebooted_victim_lawful_escort.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for Escorts of Lawful Victims.";

this.shipSpawned = function()
{
this.ship.bounty = 0;
// Closing Bracket for This Ship Spawned.
}
// Only react to attacks from the player.


this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 51;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
// Same Tests as for being attacked above.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 5;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
// Same Tests as for being attacked above, but whilst the Victim will ignore a laser attack (as it won't be hit again), if an NPC has fired a missile at it, it will send
// a script message to the AI to flee the incoming missile and use ECM, but not to attack the other ship.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
player.bounty |= 5;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 51;
// End of Killed by the Player.
}
// End of this.shipDied
}
