this.name           = "assassins_rebooted_victim6_escort.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for Escorts of Victims 6 - Reprogrammed Mining Drones escorting O-Ren Ishi's Cobra IX";

this.shipSpawned = function()
{
// Give the Escort a Callsign.
var bot_name = expandDescription("[assassins-battlebot_type9_name]");
this.ship.displayName = this.ship.name + ": " +bot_name;
this.ship.bounty = 0;
// Closing Bracket for This Ship Spawned.
}
// Only react to attacks from the player.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// Does not respond either to NPC attacks or accidental friendly fire from it's own side.
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// As Victim 5 is a fugitive, police ships and bounty hunters will attack it. The attacking ship will be forced to break off however and the Victim won't respond to the attack.
// This makes Victim 5 effectively unkillable by NPCs as any NPC which hits the ships is forced to flee 26kms from it.
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
// Same Tests as for being attacked above.
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
// Same Tests as for being attacked above, but whilst the Victim will ignore a laser attack (as it won't be hit again), if an NPC has fired a missile at it, it will send
// a script message to the AI to flee the incoming missile and use ECM, but not to attack the other ship.
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
return;	
}
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1) 
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
// End of this.shipAttackedWithMissile
}
