this.name           = "assassins_rebooted_victim4_escort.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to prevent friendly fire and stop the Victim's escort ships getting involved in fights with Thargoids.";

this.shipSpawned = function()
{
// In case the ship has been called as a standard role and has thus had a bounty added by the populater, set the bounty back to zero for lawful ships.
this.ship.bounty = 0;
}

// Ships and Stations added by the OXZ have the roles lawful or chaotic in addition to their normal roles.
// Lawful ships will never target each other, so will only hit each other by accident when shooting at another target
// All the lawful ships have zero bountys so also won't be targeted by police ships either.
// If hit by a police ship or a member of it's own faction then the scipt messages the AI not to attack the other ship and instead wait for 2 seconds before returing to what
// it was doing before it was hit. If the player is the attacker then attacking a lawful ship will make the player a fugertive. The ship which hit the ship will also get a friendly fire
// warning and its AI will stop firing to for a few seconds.  The special Thargoids appearing during the Victim 4 mission have special AIs and scripts which means they will
// not attack victim 4 or his escorts. The escorts will also not respond to accidental hits by the Thargoids. 
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1 || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// Target lock is still broken in case the attacker deliberitly targeted a ship on its own side due to it being awarded a bounty.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker was a Thargoid, stop it fireing back.
if (whom.roles.indexOf("assassins_rebooted_non_target") > -1 )  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.bounty = 0; 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
// If the attacker was a Thargoid, stop it fireing back.
if (whom.roles.indexOf("assassins_rebooted_non_target") > -1 )  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.bounty = 0; 
return;		
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
// If the attacker is another lawful station with turrets and it is accidently pelting one of it's own defenders with plasma, the defender will perform a short flee to get out of the way.
if (whom.roles.indexOf("assassins_rebooted_lawful_gunner") > -1 )  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("AVOID_LAWFUL_GUNNER"); 
return;		
}

// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 51;
}
// End of this.shipDied
}
