this.name           = "assassins_rebooted_soin_clan_inno_soin.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to prevent friendly fire incidents and advance mission states when the ship dies.";

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
// If the attacker is another soin clan ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// Both the attacker and the attacked ships lose their current targets (of each other) and each gets an AI message to break off.
// The attacked ship also gets a custom AI message for fiendly fire, so it will idel for 1.5 seconds before going back to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_soin_clan") > -1 )  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
if (whom.roles.indexOf("assassins_rebooted_soin_clan") > -1 )  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
if (whom.roles.indexOf("assassins_rebooted_soin_clan") > -1 )  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;	
}
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom){
missionVariables.assassins_rebooted_stage = 12;
missionVariables.assassins_rebooted_interlude = "No";
mission.setInstructionsKey("assassins_rebooted_mission_description_10", "AssassinsRebooted");
this.ship.commsMessage(expandDescription("[assassins-inno-soin-death]"), player.ship);
// Add 5 invisible q-mines with a 0.5 second countdown between 5 and 25kms from the player's position.
pos = player.ship.position;
system.addShips("assassins_rebooted_inno_soin_bomb",1,pos,5000); 
system.addShips("assassins_rebooted_inno_soin_bomb",1,pos,10000); 
system.addShips("assassins_rebooted_inno_soin_bomb",1,pos,15000); 
system.addShips("assassins_rebooted_inno_soin_bomb",1,pos,20000); 
system.addShips("assassins_rebooted_inno_soin_bomb",1,pos,25000); 
// End of this.shipDied
}
