this.name           = "assassins_rebooted_navy_station.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also spawns assosciated ships and mission ships.";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
// Normally, the Base is open to civilians and will not be hostile to the player as long as they are clean.
// At the time of the 8th Hit the base is in lock-down, so during lockdown a different version of the station and ships are used which have AIs hostile to non-military ships.
if (missionVariables.assassins_rebooted_navy_base_lockdown === "No" || !missionVariables.assassins_rebooted_navy_base_lockdown) {
// Add 4 groups of 3 Navy Sidewinders with AIs to patrol around the base.
system.addShips("assassins_rebooted_navy_local_patrol_leader", 2, this.ship.position, 10000);
system.addShips("assassins_rebooted_navy_local_patrol_leader", 2, this.ship.position, 12000);
// Add the Carrier Antiphates with an AI to patrol around the base.
// It can be docked with by Clean ships and will stop to allow the player (if Clean) or NPC shuttles to dock with it.
system.addShips("assassins_rebooted_antiphates", 1, this.ship.position, 15000);
// Add the Carrier Damasen. This ship is added near the base but with an AI to go to the witchpoint. It will attack thargoids and non-clean ships.
system.legacy_addShipsAtPrecisely("assassins_rebooted_damasen", 1, "abs", this.ship.position.add(this.ship.heading.multiply(30000)))
// Add the Carrier Elatrreus. This ship is also added near the base, but with an AI to go to the main planet. It will attack thargoids and non-clean ships. 
system.legacy_addShipsAtPrecisely("assassins_rebooted_elatreus", 1, "abs", this.ship.position.add(this.ship.heading.multiply(50000)))
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
