"use strict";
this.name = "assassins_rebooted_minesweeper";
this.author = "LittleBear, Eric Walch & Thargoid";
this.copyright = "November 2008 - But do what you like with it in your OXPs!";
this.description = "Stops the use of Quirium Weapons within scanning range of a Minesweeper.";
this.version = "2.2";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
delete this.shipSpawned; 
}

this.quirium = ["EQ_QC_MINE", "EQ_CASCADE_MISSILE", "EQ_LAW_MISSILE", "EQ_OVERRIDE_MISSILE", "energy-bomb", "RANDOM_HITS_MINE",  "EQ_MEGA_DEATH_MISSILE"];

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}
this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}

this.doScan = function () 
{ 
// create an array with all weapons in range.
function allShips(entity) {return entity.isShip && entity.isWeapon}; 
var missiles = system.filteredEntities(this, allShips, this.ship, this.ship.scannerRange);
for (var i = 0; i < missiles.length; i++)
{
if (this.quirium.indexOf(missiles[i].primaryRole) > -1) 
{
missiles[i].explode();
this.ship.fireECM();
break; // found one
}
}
}
this.thargoidScan = function () 
{ 
// create an array with all thargoids in range.
function allShips(entity) {return entity.isShip && entity.isThargoid}; 
var thargoids = system.filteredEntities(this, allShips, this.ship, this.ship.scannerRange);
for (var i = 0; i < thargoids.length; i++)
{
if (thargoids[i].hasRole("secondWave_mineTharglet")) 
{
thargoids[i].explode();
this.ship.fireECM();
break; // found one
}
}
}
