this.name           = "assassins_rebooted_mafia_waystation_station.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also adds ships depending on the mission stage";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
pos = this.ship.position;
// Add 2 Annacondas each with 2 Sidewinder escorts near the Mafia Waystation for a scripted event.
// Both these varients of the ship will orbit within 10 to 15kms of the Waystation unless or until the player comes within 25km.
// When they detect the player, the first ship will check that there isn't already another Mafia Anaconda docking with the Waystation. If there isn't then it will dock.
// If there is, then it will start flying towards either the Main Station and dock with it or fly to the Witchpoint and dock with the nearest OXZ station to the witchpoint. 
// If there are no OXZ stations in the system then it will go to the Main Station once it reaches the Witchpoint or Jump Out.
system.addShips("assassins_rebooted_mafia_base_drugship",1,pos,10000);
// The second ship will also orbit until the player arrives. It will then either fly out of blocking range of the station and jump out or start flying to the main station and dock
// with it or fly to the witchpoint beacon and dock with the nearest OXZ station to the witchpoint.
system.addShips("assassins_rebooted_mafia_base_drugship_alt",1,pos,15000);
// Add another Anaconda with two Sidewinder Escorts 30kms from the Waystation. This ship will go to the Waystation and dock with it.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mafia_homebound_drugship", 1, "abs", this.ship.position.add(this.ship.heading.multiply(30000)))
// Add another Anaconda with two Sidewinder Escorts 50kms from the Waystation. This ship will go to the Witchpoint and dock with the nearest station there.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mafia_outbound_drugship", 1, "abs", this.ship.position.add(this.ship.heading.multiply(50000)))
// Add an Anaconda with two Sidewinder Escorts near the Main Station just out of Scanner range. This ship will go to the Main Station and dock.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mafia_planet_drugship", 1, "abs", this.ship.position.add(this.ship.heading.multiply(235000)))
// Ships Spawned when the mission is running.
if (missionVariables.assassins_rebooted_stage === 35) {
// Spawn the target dummy. The dummy's own script spawns 4 Triads Ships to attack it and also spawns target dummies 2 and 3.
// Dummy in turn spawns 2 Triad Ships around its position. Dummy 3 is targeted by the Mission Ship - Victim 7.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mafia_target_dummy_type1", 1, "abs", this.ship.position.add(this.ship.heading.multiply(145000)))
// Add an invisible minsweeper in the center of the group of ships. This is static and so if your fight with the boss takes you more than 25kms from his starting position,
// then you will be able to try to q-mine him (he will almost certainly escape on injectors however and so you may well lose track of him), but you won't be able to deploy
// a q-mine in the middle of the triads v mafia anaconda battle. This is handwaved as the slow annacondas deploying a dampening field to stop a single triad Mamba with
// a mine wiping them all out (otherwise there woudn't be much of a mission to play)!
system.legacy_addShipsAtPrecisely("assassins_rebooted_minesweeper_hidden", 1, "abs", this.ship.position.add(this.ship.heading.multiply(150000)))
// Add Victim 7  - Boss Yankisona flying an armoured Boa by Griff (Escorted by 2 Sonorans by Robin).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim7", 1, "abs", this.ship.position.add(this.ship.heading.multiply(155000)))
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
