this.name           = "assassins_rebooted_echo_of_hoth.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also spawns associated ships and mission ships.";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
pos = this.ship.position;
// Add an asteroid field around the Former Prison.
system.addShips("assassins_rebooted_miner_rock",45,pos,25000);
// Add a group of 5 Imperial Mongoose Fighters with AIs to go to the Base and attack both the Base and non-imperial ships.
system.addShips("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker",1,pos,5000); 
// Add a flight of 2 flights of Reble Sonorans (6 ships in total) with AIs to patrol around the Base.
system.addShips("assassins_rebooted_local_patrol_rebel_sonoran_leader",1,pos,10000); 
system.addShips("assassins_rebooted_local_patrol_rebel_sonoran_leader",1,pos,15000); 
// Add a group of 3 Imperial Scorpions with AIs to go to the Base and attack both the Base and non-imperial ships.
system.addShips("assassins_rebooted_imperial_scorpion_outlaw_prison_attacker",1,pos,18000); 
// Add another group of 5 Imperial Mongoose Fighters with AIs to go to the Base and attack both the Base and non-imperial ships.
system.addShips("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker",1,pos,20000); 
// Add a group of 3 Imperial Shuttles with AIs to go to the Base and attack both the Base and non-imperial ships.
system.addShips("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker",1,pos,22000); 
// Add another group of 5 Imperial Mongoose Fighters with AIs to go to the Base and attack both the Base and non-imperial ships.
system.addShips("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker",1,pos,24000); 
// Add a second wave of imperial mongoose fighters approaching the base, starting 50kms from the base.
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(50000)))
// Set up some battles in the lane between the base and the main station Surviving imperial ships will go to the base. Surviving rebles will pick a random destination and go to it.
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(79000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_scorpion_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(80000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(81000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(110000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(150000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(155000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(190000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(200000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_scorpion_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(230000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(235000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(240000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(270000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(300000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(330000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(335000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(340000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(370000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(375000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(400000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(410000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_witchpoint_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(450000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_witchpoint_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(475000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(480000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(490000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(500000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(525000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(530000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_scorpion_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(560000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(565000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(570000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(575000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(610000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(630000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_scorpion_outlaw_station_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(650000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(655000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(660000)))
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(665000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_imperial_shuttle_outlaw_prison_attacker", 1, "abs", this.ship.position.add(this.ship.heading.multiply(695000)))
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
