this.name           = "assassins_rebooted_black_mesa.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and spawn an asteroid field.";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
// Spawn an asteroid field of glowing asteroids.
pos = this.ship.position;
system.addShips("assassins_rebooted_miner_rock",45,pos,25000);
// Add a distress beacon 10 kms ahead of the station to broadcast periodic distress messeges once the player comes within range.
system.legacy_addShipsAtPrecisely("assassins_rebooted_rebel_distress_beacon", 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))
// Add two groups of 3 Mongoose fighters with an AI to go to the witchpoint. If the player is flying in from the witchpoint they may encounter one or both groups on their
// way to the Reble Facility. The imperial ships will attack the player if encountered.
system.addShips("assassins_rebooted_mongoose_imperial_outlaw_mission_witchpoint",1,pos,25000);
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_witchpoint", 1, "abs", this.ship.position.add(this.ship.heading.multiply(50000)))
// Three Groups of 5 Mongoose fighters are added in a line between the Facility and the Main Station at 250, 500 and 750kms from the Facility. These ships will fly to the
// main station and attack the player if they encounter them. If the player is flying to the Facility from the main station, it is likley that they will encounter some of these ships.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_main_station", 1, "abs", this.ship.position.add(this.ship.heading.multiply(250000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_main_station", 1, "abs", this.ship.position.add(this.ship.heading.multiply(500000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_main_station", 1, "abs", this.ship.position.add(this.ship.heading.multiply(750000)))
delete this.shipSpawned; 
}

// The Station is normally invunerable to attack, but at the end of the text adventure the damaged station's reactor goes critical and the station is attacked by imperial ships
// with unique roles. As soon as the station's AI detects the special ships spawned as the player launches at the end of the text adventure, it will switch states to pause for
// ten seconds before executing becomeExplosion. It will also be sent to this 10 second countdown as soon as any of the imperial ships land a hit on it. Either way, the station
// blows up 10 seconds after the player launched. Once the station blows up, the imperials will attack the player or if the player has left scanner range they will fly to the
// main planet looking for the player.

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
if (whom.roles.indexOf("assassins_rebooted_demon_text_adventure") > -1 || whom.roles.indexOf("assassins_rebooted_shuttle_text_adventure_station_attacker") > -1 
|| whom.roles.indexOf("assassins_rebooted_mongoose_text_adventure_station_attacker") > -1)  
{
this.ship.reactToAIMessage("SPECIAL_IMPERIAL_ATTACK"); 
return;		
}
// End of this.shipBeingAttacked		
}
