"use strict";

this.name = "Little Friends";
this.author = "Reval";
this.description = "For a modest fee, the Merchanters' League is pleased to provide its aspiring and existing traders with a regular escort of robot-piloted enhanced Mamba IIe fighters.";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.0.0";

/* 

For you, the old-school trader raised to ply the arrow-straight course from Witchpoint to Main Station, being perhaps hesitant - or loath - to drive your run offlane for safety, we of the Galactic Merchanters' League (M.L.) have the perfect solution: For a modest fee and running contract, M.L. can provide your ship with a regular escort of fully refitted robot-piloted milspec Mamba IIe fighters. 

Your programmed escorts will join you on Station-undock as well as on arrival at the post-Hyperjump Witchpoint destination.

The Mamba IIe robot escort will appear as deep blue blips on your scanner.

They are programmed to interdict potential attackers as soon as they scan them. Thus, they do not always 'stick close' to your mothership. They will resume escort duty after a successful pre-emptive defence, provided they are in a condition to do so.

*/



this.shipLaunchedFromStation = function(stationLaunchedFrom) {
	// ESCORTS
	this.$lfHasEscort = (player.ship.equipmentStatus ("EQ_LF_MAMBA_ESCORT") === "EQUIPMENT_OK");
	if (this.$lfHasEscort) {
		player.commsMessage("Escorts are arriving...",6);
		var ships = system.addShips("lf_escort", this.$lfNumEscort, player.ship.position,0.2);
	} else player.commsMessage("Escorts are unavailable. Good Luck, Commander!");
}



this.shipExitedWitchspace = function() {
	var pc = player.commsMessage;
	// report miscreants in system
	var mis = system.countShipsWithPrimaryRole("pirate");
	// muster escorts
	if (this.$lfHasEscort) {
		pc("Escorts are arriving...",6);
		var ships = system.addShips("lf_escort", this.$lfNumEscort, player.ship.position,0.2);
		pc("Mamba Escort reports Miscreants in system: "+mis,9);
		pc(" ");
	} else pc("Escorts available from Aegis. Good Luck, "+this.$mlBro+"!");
}



this.shipWillDockWithStation = function(station) {
	// remove fast-docking equipment
	player.ship.removeEquipment("EQ_ET_AUTODOCK");
}


this.shipWillLaunchFromStation = function(station) {
	// enable fast docking
	this._installAutoDock();
}



this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// declare & initialize globals
	// Leaguers may be provided with Constrictor escort ships
	this.$lfHasEscort = false;
	// Leaguers may choose the number of ships to escort them
	this.$lfNumEscort = 4;
}



this._installAutoDock = function() {
	var p = player.ship;
	// give the escort-contracted trader free fast-docking facilities at any station
	if (p.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") {
			p.awardEquipment("EQ_ET_AUTODOCK");
	}
}

