"use strict";
this.name = "Cargo Space Refit";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_CARGO_REFIT") {
		if (this.$csrFitted=="no") {
			// increase space by ship's nominal capacity
			player.ship.cargoSpaceCapacity += this.$csrNominal;
			var pcc=player.ship.cargoSpaceCapacity;
			pc("Refitting ship to "+pcc+" TC capacity...",9);
			this.$csrSpace = pcc;
			// charge refit fee according to ship size
			for (var i=1; i<= this.$csrNominal; i++)
				this.$csrCharges += 500;
			// debit customer's account
			// note: player.credits won't go into the red!
			player.credits -= this.$csrCharges;
			// reimburse deposit
			var pd = paid/10; // decicredits, so convert
			this.$csrDeposit = pd;
			player.credits += pd;
			pc("Total cost: "+this.$csrCharges+" cr",9);
			pc("F4 to check your invoice.",9);
			this.$csrFitted = "yes";
			// prepare Invoice Interface
			var sta = player.ship.dockedStation;			
			this._csrPrepInv(sta);
		} else pc("Ship already refitted.",7);
	}	
}


this.equipmentRemoved = function(equipmentKey) {
    pc=player.consoleMessage;
	if (equipmentKey == "EQ_CARGO_REFIT") {
		pc("We cannot un-refit your ship!",7);
	}
}


this.playerBoughtNewShip = function(ship, price) {
	var pc = player.consoleMessage;
	// reset csr globals and note new capacity
	this.$csrNominal = ship.cargoSpaceCapacity;
	this.$csrSpace = 0;
	this.$csrFitted = "no";
	this.$csrCharges = 0;
	this.$csrDeposit = 0;	
}


this.shipDockedWithStation = function(station) {
	// conditionally, prepare Invoice Interface
	if (this.$csrFitted=="yes")	this._csrPrepInv(station);
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.csrSpace != null) 
		player.ship.cargoSpaceCapacity += missionVariables.csrSpace;
	if (missionVariables.csrFitted != null) 
		this.$csrFitted = missionVariables.csrFitted;
	if (missionVariables.csrCharges != null) 
		this.$csrCharges = missionVariables.csrCharges;
	if (missionVariables.csrDeposit != null) 
		this.$csrDeposit = missionVariables.csrDeposit;
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	this.$csrSpace = 0;
	this.$csrFitted = "no";
	// record nominal capacity in case Containers are present
	this.$csrNominal = player.ship.cargoSpaceCapacity;
	// initialize charges
	this.$csrCharges = 0;
	// initialize deposit
	this.$csrDeposit = 0;	
}


this.playerWillSaveGame = function(message) {
	missionVariables.csrSpace = this.$csrSpace;
	missionVariables.csrFitted = this.$csrFitted;
	missionVariables.csrCharges = this.$csrCharges;
	missionVariables.csrDeposit = this.$csrDeposit;
}


// create F.E.S. Cargo Space Invoice sheet  
this._csrPrepInv = function(station) {
	station.setInterface("csrInv",{
	title: "Your FE Shipyards Invoice for CSR work",
	category: "Your FE Shipyards",
	summary: "FE Shipyards invites you to check your Invoice for the recent Cargo Space Refit undertaken on your behalf." ,
	callback: this._csrShowInv.bind(this)
	});	
}


// show F.E.S. Invoice for Cargo Space Refit
this._csrShowInv = function() {
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards Invoice for Cargo Space Refit";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "This constitutes your invoice for our successful cargo space refit recently undertaken on your "+player.ship.name+" with nominal capacity "+this.$csrNominal+"  TC.\n\n";
	
	parameters.message += "Total Charges: "+this.$csrCharges+" cr \n\n";
	
	parameters.message += "The amount debited from your account includes your initial deposit of "+ this.$csrDeposit + " cr. \n\n";
	
	parameters.message += "We count, as always, on your satisfaction with our service.\n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "csrAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")
			player.commsMessage("FE Shipyards thanks you for your custom.");
	}	
}

