"use strict";

this.name           = "mo-traders_rating3";
this.author         = "spara";
this.description    = "Gives the player a Trader's Rating based on profit made.";

//Public function for reporting profit
this.$reportProfit = function(profit) {
	this.$profit += profit;
	this.$setInstruction();
}

this.startUp = function() {
	if (!missionVariables.marketObserverProfit) this.$profit = 0;
	else this.$profit = missionVariables.marketObserverProfit;
	this.$setInstruction();
}

this.playerWillSaveGame = function () {
	missionVariables.marketObserverProfit = this.$profit;
}

this.$traderRank = function() { //return trader rank string
	var traderRatings =[0, 1500, 5000, 20000, 50000, 100000, 250000, 500000, 1000000];
	var i;
	var traderRating = -1;
	for (i = 0; i < 9; i++) {
		if (this.$profit/10 >= traderRatings[i])
			var traderRating = i;
	}
	if (traderRating != -1)
		return expandDescription("[mo_trade_rating_" + traderRating+"]");
	else
		return expandDescription("[mo_trade_rating_minus]");
}

//Trader rank for market hud
this.$setInstruction = function() { //set trader rank text to manifest
	var traderRank = "Trader's Rating: " + this.$traderRank() + " (" + formatCredits(this.$profit/10, true, true ) + ")";
	player.ship.setCustomHUDDial("marketObserverProfit", traderRank);
	mission.setInstructions(traderRank+".", this.name);
}
