this.name		= "Wormhole Drone behaviour";
this.author		= "Mauiby de Fug";
this.description	= "Ship script handling the drone's behaviour";
this.version	= "1.1.1";

this.shipSpawned = function() {
	var jumpType;
	if (this.ship.roles[0] == "EQ_MAUIBY_WORMHOLE_JUMPOPT_MINE") {
		jumpType = "OPTIMIZED_BY_JUMPS";
		missionVariables.mauiby_jumpType = "jump";
	} else {
		jumpType = "OPTIMIZED_BY_TIME";
		missionVariables.mauiby_jumpType = "time";
	}
	log("Type of jump: "+jumpType);
	if ((missionVariables.mauiby_multipleJumps == "false") || (missionVariables.mauiby_multipleJumps == "waiting")) { //first launch or a relaunch, relaunch takes precedence
		log("A new drone.");
		missionVariables.mauiby_finalSystem = player.ship.targetSystem; //select destination
		if (player.ship.targetSystem != system.ID) { //check we're not there already
			var jumpChain = system.info.routeToSystem(System.infoForSystem(galaxyNumber, player.ship.targetSystem), jumpType); //plot course
			log("Target system is " + player.ship.targetSystem);
			log("Route: " +jumpChain.route);
			log("Distance: "+jumpChain.distance);
			log("Time: "+jumpChain.time);
			log("Chain length: "+jumpChain.route.length);
			this.ship.velocity = player.ship.velocity;
			this.ship.orientation = player.ship.orientation;
			this.ship.position = player.ship.position.add(player.ship.orientation.vectorForward().multiply(1000)); //positions wormhole in front of player for testing
			missionVariables.mauiby_nextSystem = jumpChain.route[1]; //saves the next system
			if (this.ship.exitSystem(jumpChain.route[1])) { //try to jump
				log("Can jump."); //jump success
				missionVariables.mauiby_multipleJumps = "waiting";
				player.consoleMessage("Wormhole chain device activated...", 5);
			} else {
				log("Jump failed."); //jump failed
				missionVariables.mauiby_finalSystem = null;
				missionVariables.mauiby_nextSystem = null;
			}
		} else { //there already
			log("Already in target system.");
			missionVariables.mauiby_finalSystem = null;
			missionVariables.mauiby_nextSystem = null;
		}
	} else { //a respawn
		log("A respawned drone.");
		if (missionVariables.mauiby_finalSystem != system.ID) { //see if we reached the final destination yet
			var jumpChain = system.info.routeToSystem(System.infoForSystem(galaxyNumber, missionVariables.mauiby_finalSystem), jumpType); //plot course
			log("Target system is " + player.ship.targetSystem);
		if(jumpChain) {
			log("Route: " +jumpChain.route);
			log("Distance: "+jumpChain.distance);
			log("Time: "+jumpChain.time);
			log("Chain length: "+jumpChain.route.length);
			missionVariables.mauiby_nextSystem = jumpChain.route[1]; //saves the next system
			if (this.ship.exitSystem(jumpChain.route[1])) { //try to jump
				log("Can jump."); //jump success
				missionVariables.mauiby_multipleJumps = "waiting";
			} else {
				log("Jump failed."); //jump failed
				missionVariables.mauiby_multipleJump = "false";
				missionVariables.mauiby_finalSystem = null;
				missionVariables.mauiby_nextSystem = null;
			}
		} else {
				this.ship.exitSystem(player.ship.targetSystem);
				log("Can jump."); //jump success
				missionVariables.mauiby_multipleJumps = "waiting";
		}

		} else { //we arrived
			log("Chain completed!");
			missionVariables.mauiby_multipleJumps = "false";
			missionVariables.mauiby_finalSystem = null;
			missionVariables.mauiby_nextSystem = null;
		}
	}
}