this.name		= "TrafficControl";
this.author		= "Thargoid";
this.copyright	= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description= "Advice from station for docking";
this.version		= "1.1";

"use strict";

this.shipEnteredPlanetaryVicinity = function(planet) 
{ 
	if(planet.isMainPlanet) { 
		if(player.ship.equipmentStatus("EQ_ADVANCED_COMPASS") == "EQUIPMENT_OK") player.commsMessage("This is " + system.name + " Traffic Control - For station approach, please select and follow the beacon N on your compass.", 5);
		else player.commsMessage("This is " + system.name + " Traffic Control - For station approach, please follow the rectangle on your compass.", 5); 
	} 
}

this.shipEnteredStationAegis = function(station)
{
	if(station.isMainStation && system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000).length > 0 && player.ship.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") { // check the buoy exists and player doesn't have functional docking computers
		player.commsMessage("This is " + system.name + " Traffic Control - Please fly to station buoy to begin docking maneuvers.", 5);
		if(this.dcTimer) this.dcTimer.start();
		else this.dcTimer = new Timer(this, this.buoyDistance, 3, 3);
	} else if(station.isMainStation && system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000).length == 0) player.commsMessage("This is " + system.name + " Traffic Control - Assistance is not available at this time.", 5);  // no buoy there.
}

this.shipLaunchedFromStation = function()
{
	if(player.ship.position.distanceTo(system.mainStation.position) < 12000) { //check station launched from is the main one.
		player.commsMessage("This is " + system.name + " Traffic Control - Bon voyage Commander " + player.name + ".", 5);
		player.commsMessage("Please clear the station approach lane as soon as possible.", 5); 
		if(system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000).length > 0) {
			this.navBuoy = system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000);
			this.stationBuoy = this.navBuoy[0];
			if(this.launchTimer) this.launchTimer.start();
			else this.launchTimer = new Timer(this, this.launchClear, 10, 10);
		}
	}
}

this.launchClear = function()
{
	this.getVectors();
	if(this.shipUD < 0.2 && this.shipLR < 0.2 && player.ship.position.distanceTo(system.mainStation.position) < 12000) { // in the docking lane.
		player.commsMessage("WARNING - clear the station approach lane immediately!", 5); 
	} else this.launchTimer.stop();
}

this.shipExitedStationAegis = this.shipWillDockWithStation = this.shipWillEnterWitchspace = this.shipDied = function()
{
	if(this.dcTimer) this.dcTimer.stop();
	if(this.dcTimer2) this.dcTimer2.stop();
	if(this.dcTimer3) this.dcTimer3.stop();
	if(this.launchTimer) this.launchTimer.stop();
}

this.buoyDistance = function()
{
	if(system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000).length == 0) { // if the nav buoy has been destroyed since initial check
		player.commsMessage("This is " + system.name + " Traffic Control - Assistance is not available at this time.", 5);
		this.dcTimer.stop();
		return;
	}
	this.navBuoy = system.entitiesWithScanClass("CLASS_BUOY", system.mainStation, 12000);
	this.stationBuoy = this.navBuoy[0];
	this.buoyDistance = player.ship.position.distanceTo(this.stationBuoy.position); // how far the player ship is from the buoy
	if(this.buoyDistance < 500) { // if we're within 500m.
		this.dcTimer.stop();
		player.commsMessage("Come to a stop, then re-orient ship towards the station docking bay.", 5);
		if(this.dcTimer2) this.dcTimer2.start();
		else this.dcTimer2 = new Timer(this, this.aimAtStation, 3, 3);
	}
}	

this.aimAtStation = function()
{
	this.getVectors();
	if(this.shipAngle < 0.02) {
		this.dcTimer2.stop();
		player.commsMessage("Begin approach towards the docking bay.", 5);
		if(this.dcTimer3) this.dcTimer3.start()
		else this.dcTimer3 = new Timer(this, this.approachStation, 6, 3);
	} else player.commsMessage("Please align heading with the centre of the docking bay.", 5);
}

this.approachStation = function()
{
	this.getVectors();
	if(this.shipUD < 0.05 && this.shipLR < 0.05) { // in the correct docking lane.
		if(player.ship.speed < 5) player.commsMessage("Increase speed, matching roll to docking bay rotation.", 5)
		else if(player.ship.speed > 75) player.commsMessage("Please slow down and match roll to docking bay rotation.", 5)
			else player.commsMessage("Approach speed good. Match roll to docking bay.", 5);
	} else player.commsMessage("Please centre flight path more accurately to the docking bay.", 5);
}

this.getVectors = function()
{
	let idealVector = system.mainStation.position.subtract(this.stationBuoy.position).direction(); // direction unit vector between station and buoy
	let targetVector = system.mainStation.position.subtract(player.ship.position).direction(); // direction unit vector between station and player
	let shipOrientation = player.ship.orientation;
	if(0 < oolite.compareVersion("1.72")) shipOrientation.w = -shipOrientation.w; // Correction for internal trunk error

	let shipHeading = shipOrientation.vectorForward().direction();  // the way the ship is pointing (Z-axis)
	let shipPitch = shipOrientation.vectorUp(); // ship's up and down (Y-axis)
	let shipYaw = shipOrientation.vectorRight(); // ship's left and right (X-axis)
	this.shipAngle = shipHeading.angleTo(targetVector); // how accurately ship is pointing at the station centre
	this.shipUD = Math.abs(shipPitch.dot(idealVector)); // how far off-axis we are in the Y direction
	this.shipLR = Math.abs(shipYaw.dot(idealVector)); // how far off-axis we are in the X direction
}