this.name		= "targetAutolock";
this.author		= "Thargoid";
this.copyright	= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description= "Automatic target locking to attacking ships.";
this.version		= "1.11";

"use strict";

this.startUp = function()
{
	this.oldTarget = null;
	this.scanColor1 = "cyanColor";
	this.scanColor2 = "grayColor";
}

this.shipTargetAcquired = function(newTarget)
{
	if(missionVariables.targetAutolock != "TRUE") return;
	if(!this.targetTimer) this.targetTimer = new Timer(this, this.lockOn, 0, 0.25);
	else this.targetTimer.start();
}

this.shipTargetLost = this.shipTargetDestroyed = function(lostTarget)
{
	if(this.targetTimer && this.targetTimer.isRunning) this.targetTimer.stop();

	if((missionVariables.targetAutolock == "TRUE" && lostTarget) || (lostTarget && !player.ship.target)) {
		lostTarget.scannerDisplayColor1 = null;
		lostTarget.scannerDisplayColor2 = null;
	}

	this.oldTarget = null;	
}	

this.lockOn = function()
{
	if(this.oldTarget && !this.oldTarget.isValid) this.oldTarget = null;
	if(!player.ship.target) this.targetTimer.stop();

	if(player.ship.target == player.ship) { // let's not lock onto ourselves shall we?
		player.ship.target = null;
		this.targetTimer.stop();
	}
	
	if(player.ship.target && this.oldTarget && player.ship.target == this.oldTarget && player.ship.target.scannerDisplayColor1 == this.scanColor1 && player.ship.target.scannerDisplayColor2 == this.scanColor2) return;

	if(this.oldTarget) {
		this.oldTarget.scannerDisplayColor1 = null;
		this.oldTarget.scannerDisplayColor2 = null;
	}

	if(player.ship.target) {
		this.oldTarget = player.ship.target;
		player.ship.target.scannerDisplayColor1 = this.scanColor1;
		player.ship.target.scannerDisplayColor2 = this.scanColor2;
	}
}

this.shipDockedWithStation = function(station)
{
	timeAccelerationFactor = 1.0;
	if(station && missionVariables.targetAutolock == "TRUE") { // or else if we dock with a targetted station it stays gray/cyan
		station.scannerDisplayColor1 = null;
		station.scannerDisplayColor2 = null;
	}
	if(this.targetTimer && this.targetTimer.isRunning) this.targetTimer.stop();
}

this.shipDied = this.shipWillEnterWitchspace = function()
{
	if(this.targetTimer && this.targetTimer.isRunning) this.targetTimer.stop();
	this.oldTarget = null;	
}

this.shipBeingAttacked = function(attacker)
{
	if(missionVariables.targetAutolock == "TRUE" && player.ship.equipmentStatus("EQ_SCANNER_SHOW_MISSILE_TARGET") == "EQUIPMENT_OK" && player.ship.target == null && attacker && !attacker.isCloaked && !attacker.hasRole("OXP_stealthShip") && !attacker.hasRole("OXP_noAutolock") && !attacker.hasRole("TAP_noAutolock")) {
		player.ship.target = attacker;
		player.consoleMessage("Auto-locked onto attacker - " + attacker.displayName + ".",5);
	}
}

this.playerBoughtEquipment = function(equipment)
{
	switch(equipment)
	{
		case "EQ_TARGET_AUTOLOCK":
		{
			missionVariables.targetAutolock = "TRUE";
			player.ship.removeEquipment("EQ_TARGET_AUTOLOCK");
			break;
		}

		case "EQ_SCANNER_SHOW_MISSILE_TARGET":
		{
			missionVariables.targetAutolock = null;
			break;
		}
	}
}

this.equipmentDamaged = this.equipmentDestroyed  = function(equipment)
{
	if(equipment == "EQ_SCANNER_SHOW_MISSILE_TARGET") missionVariables.targetAutolock = null;
}