this.name		= "Welcome Information Script";
this.author		= "Thargoid";
this.copyright	= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description= "Expanded information when you witchspace jump into a system.";
this.version		= "1.1";

"use strict";

/* this.logging, this.audio, this.extraA and this.extraB are for compatability with OXPConfig.oxp.

	this.logging - Sends arrival location to stderr.txt and JSConsole (off by default).
	this.audio - Switch between console and comms messaging (on (comms) by default).
	this.extraA - General system information (on by default).
	this.extraB - System safety information (on by default).

	Set the default values up below:
*/

this.logging = false;
this.audio = true;
this.extraA = true;
this.extraB = true;

//this.name		= "misjump_analyser"; 
//this.author		= "eric walch"; 
//this.copyright	= "� 2008 the Oolite team."; 
//this.description	= "This script analyses the misjump chance."; 
//this.version	= "1.1";

this.startUp = function ()
{
	this.mySound = new SoundSource;
	this.mySound.sound = "misjumpAnalyser.ogg";
	this.mySound.loop = false;
// end of Misjump Analyzer script snippet.

// More of Welcome Information Script
	if(missionVariables.welcomeLogging == true) this.logging = true;
	if(missionVariables.welcomeAudio == false) this.audio = false;
	if(missionVariables.welcomeExtraA == false) this.extraA = false;
	if(missionVariables.welcomeExtraB == false) this.extraB = false;
// From Rock Hermit Buoy locator
	this.buoysAdded = false;
}


//------------------------
// Bounty Scanner scripts!

//this.name      = "Bounty Scanner 2.0"; 
//this.author    = "Dennis Thony Pedersen (frame)";
//this.copyright = " 2008 the Oolite team.";
//this.description = "Bounty Scanner 2.0";
//this.version   = "2.00";

// version shift to 2.0 to mark an end to backward compatibility
//startup backward compatibility removed for priming of timers not to hit timer restrictions as per latest trunk updates
//bounty hunter would likely never hit these restrictions on a normal system, but slower systems could be affected...
this.shipLaunchedFromStation = function()
{
	if(player.ship.equipmentStatus("EQ_FRAME_BOUNTY_SCANNER") == "EQUIPMENT_OK") if(this.BountyCheckTimer) {this.BountyCheckTimer.start()} else {this.BountyCheckTimer = new Timer(this, this.BountyCheck,0,3);}

// snippet from welcome mat that needs to occur when launched from station
	missionVariables.welcomeLogging = this.logging;
	missionVariables.welcomeAudio = this.audio;
	missionVariables.welcomeExtraA = this.extraA;
	missionVariables.welcomeExtraB = this.extraB;
	if(this.welcomeTimer) this.welcomeTimer.start()
	else this.welcomeTimer = new Timer(this, this.checkForBuoy, 30, 30);
// end of snippet from welcome mat

// From Rock Hermit Buoy locator
	if (!this.buoysAdded) this.addBuoys();
	if (this.buoysAdded && this.buoy == "rockbeacof" && player.ship.equipmentStatus("EQ_ROCKHERMIT_SCANNER") === "EQUIPMENT_OK") this.swichOnBuoys();
}

this.shipExitedWitchspace = function()
{
	if(player.ship.equipmentStatus("EQ_FRAME_BOUNTY_SCANNER") == "EQUIPMENT_OK") {
		if(this.BountyCheckTimer) {this.BountyCheckTimer.start()} else {this.BountyCheckTimer = new Timer(this, this.BountyCheck,0,3);}
	}

// snippet from Welcome Mat that needs to occur when exiting Witchspace
	if(player.ship.equipmentStatus("EQ_WELCOME_MAT") != "EQUIPMENT_OK") {
		player.consoleMessage("Please lock onto the beacon to initiate data connection.", 6);
		if(this.welcomeTimer) this.welcomeTimer.start()
		else this.welcomeTimer = new Timer(this, this.checkForBuoy, 30, 30);
	} else this.displayMessage();
// end of snippet from Welcome Mat


// snippet from Misjump Analyzer that needs to occur when exiting Witchspace
	if(this.misjumpTimer) {
		this.misjumpTimer.stop();
		delete this.misjumpTimer;
	}
// end of Misjump Analyzer script snippet.

// From Rock Hermit Buoy locator
	this.buoysAdded = false;
// use a delay to allow all other oxp's to add their stuff before we start counting hermits.
	this.buoyTimer = new Timer(this, this.addBuoys, 1);
}

this.BountyCheck = function()
{
	if(player.ship.docked) this.BountyCheckTimer.stop();
//we could stop the timer, but it might get fixed, somehow magicaly...
	if(player.ship.equipmentStatus("EQ_FRAME_BOUNTY_SCANNER") != "EQUIPMENT_OK" || !player.ship.target) return; // Equipment might be damaged
	this.lasttarget = player.ship.target;
	if(this.lasttarget.bounty <= 1) {
//v1.02 checks if Wrap around 100 
//and if some OXPs mess with the bounty
		if(this.backwardversion) { // compatibility prior to 1.72
			if(this.lasttarget.hasOwnProperty("Frame_oldbounty") && this.lasttarget.hasOwnProperty("Frame_bountyScannerName")) {
				this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName;
				this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
			}
		} else if(this.lasttarget.hasOwnProperty("Frame_oldbounty") && this.lasttarget.hasOwnProperty("Frame_bountyScannerName")) {
				this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName;
				this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
			}
		return;
	}
	if(!this.lasttarget.hasOwnProperty("Frame_bountyScannerName")) {
		if(this.backwardversion) { // compatibility prior to 1.72
			//implementing Erichs Fix, Thanks...
			this.lasttarget.Frame_bountyScannerName = this.lasttarget.displayName;
			this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName+": Bounty:"+this.adjustedBounty(this.lasttarget)+"cr";
			this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
			return; //skip further checking
		} else {
			this.lasttarget.Frame_bountyScannerName = this.lasttarget.displayName;
			this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName+": Bounty:"+this.adjustedBounty(this.lasttarget)+"cr";
			this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
			return; //skip further checking
		}
	}

//added this to Erichs fix
//update the bounty if it has changed, and be damn sure that it has the property before setting...

// v1.02 changes..
/*removed the return else, removed a typo, the following is needed for a correct updating of the displayed bounty

Concerns: erich PMed me that IDs wrap around 100, the following code will also take care of that theoretical
problem as it will update to the new bounty, once it detects that, the Bounty text would remain though so added
code up in the bounty check <= 1 to remove the bounty text field all together...
*/

	if(this.lasttarget.hasOwnProperty("Frame_oldbounty") && this.lasttarget.hasOwnProperty("Frame_bountyScannerName")) if(this.lasttarget.Frame_oldbounty != this.lasttarget.bounty) if(this.backwardversion) { // compatibility prior to 1.72
		this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName+": Bounty:"+this.adjustedBounty(this.lasttarget)+"cr";
		this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
	} else {
		this.lasttarget.displayName = this.lasttarget.Frame_bountyScannerName+": Bounty:"+this.adjustedBounty(this.lasttarget)+"cr";
		this.lasttarget.Frame_oldbounty = this.lasttarget.bounty;
	}
}

this.shipDied = function()
{
	if(this.BountyCheckTimer) this.BountyCheckTimer.stop();
}

// 1.07 updated to deal with special bounty settings for certain types 
this.adjustedBounty = function(ship)
{
	var baseBounty = ship.bounty;
	var scanClass = ship.scanClass;
	if(ship.isCargo || scanClass == "CLASS_BUOY" || scanClass == "CLASS_ROCK") return baseBounty / 10
	else return baseBounty;
}

//----------------------------
// Escape Pod Locator scripts!

this.shipSpawned = function (ship) // MAY NOT WORK BECAUSE LOOKING FOR SHIP inside BountyScanner.js!
{
	if(player.ship.equipmentStatus("EQ_ESCAPE_CAPSULE_LOCATOR") === "EQUIPMENT_OK" && ship.primaryRole == "escape-capsule") {
//		log("shipSpawned", "Setting scanner colors for " + ship);
		ship.scannerDisplayColor1 = "blackColor";
		ship.scannerDisplayColor2 = "orangeColor";
	}
}

//--------------------------
// Missile Analyzer scripts!
/*
this.name        = "missile_analyser"; 
this.author      = "eric walch"; 
this.copyright   = "? 2008 the Oolite team."; 
this.description = "This script analyses the missile type."; 
this.version     = "1.2";
*/
this.shipAttackedWithMissile = function(missile, whom)
{
	if(player.ship.equipmentStatus("EQ_MISSILE_ANALYSER") === "EQUIPMENT_OK") {
		// log(this.name, "Detected launch of a "+missile.displayName+" fired by " + whom.displayName);
		// only warn for the special missiles.
		if(missile.name !== "Missile") {
			player.consoleMessage("Detected launch of a " + missile.displayName, 8);
			if(player.ship.equipmentStatus("EQ_TARGET_MEMORY") === "EQUIPMENT_OK") player.ship.target = missile;
		}
	}
}

this.playerBoughtEquipment = function(equipment)
{
	if(equipment === "EQ_MISSILE_ANALYSER_REMOVER") {
		var refund = EquipmentInfo.infoForKey("EQ_MISSILE_ANALYSER").price/10 * 0.75;
		if(player.ship.equipmentStatus("EQ_MISSILE_ANALYSER") === "EQUIPMENT_DAMAGED") refund /= 10;
		player.ship.removeEquipment("EQ_MISSILE_ANALYSER");
		player.ship.removeEquipment("EQ_MISSILE_ANALYSER_REMOVER");
		player.credits += refund;
	}
}

//-----------------------------
// Rest of Welcome Mat scripts!

this.shipWillDockWithStation = function(station)
{	
	missionVariables.welcomeLogging = this.logging;
	missionVariables.welcomeAudio = this.audio;
	missionVariables.welcomeExtraA = this.extraA;
	missionVariables.welcomeExtraB = this.extraB;
	this.welcomeTimer.stop();
// From Hermit Tweaks script.js
	if (station.primaryRole.indexOf("rockhermit") !== -1) {
		this.$station = station;
		this.guiScreenWillChange = this._guiScreenWillChange;
	}
// End of Hermit Tweaks script.js
}

this.checkForBuoy = function()
{
// check player has equipment and a buoy is on the scanner
	if(player.ship.target && system.entitiesWithScanClass("CLASS_BUOY", player.ship, 25600).length) if(player.ship.target.scanClass == "CLASS_BUOY" && player.ship.target.isBeacon) this.displayMessage();
}

this.displayMessage = function()
{
if(!system.isInterstellarSpace) {
	this.pirateCount = system.shipsWithPrimaryRole("pirate").length; // how many pirate role ships in system
	this.policeCount = system.entitiesWithScanClass("CLASS_POLICE").length + system.entitiesWithScanClass("CLASS_MILITARY").length; // how many ships with scanClass police or military
	this.thargoidCount = system.entitiesWithScanClass("CLASS_THARGOID").length; // # Thargoid scanclass ships in system
	this.systemSafety = ((this.pirateCount + this.thargoidCount) - this.policeCount); // ratio of pirate/Thargoid and police/military ships.
	if(this.logging) {
		log("Player in galaxy " + (galaxyNumber+1) + " at " + system.name + " (" + system.ID + ").");
		log("Pirate count - " + this.pirateCount); 
		log("Police count - " + this.policeCount); 
		log("Thargoid count - " + this.thargoidCount); 
		log("System safety figure - " + this.systemSafety);
	}
	if(this.audio) { // messages via commsMessage
		if(this.extraA) { // display the information to the comms system, after the in-built system name message.
			player.commsMessage("Government - " + system.governmentDescription + ".", 6);
			player.commsMessage("Tech level - " + (system.techLevel + 1) + ".", 6); 
			player.commsMessage("Economy - " + system.economyDescription + ".", 6); 
		}
		if(this.extraB) {
			if(this.systemSafety > 5) player.commsMessage("Beware, significant pirate activity has been reported in this system!", 6) // if there are significantly more pirates/Thargoids than police/military
			else if(this.systemSafety < -5) player.commsMessage("This system has a strong police presence.", 6) // if there are significantly less pirates/Thargoids than police/military
				else player.commsMessage("No reports of major pirate activity.", 6); // if system is balanced between police/military and pirates/Thargoids
			if(this.thargoidCount > 0) if(this.thargoidCount == 1) player.commsMessage("Thargoid reported in system.", 6)
				else if(this.thargoidCount < 8) player.commsMessage("Thargoids reported in system.", 6)
					else player.commsMessage("Thargoid invasion reported in system!", 6);
			if(system.sun.isGoingNova) player.commsMessage("The sun is going nova! Get out now!", 6);
		}
	} else { // messages via consoleMessage
		if(this.extraA) { // display the information to the console system, after the in-built system name message.
			player.consoleMessage("Government - " + system.governmentDescription + ".", 6);
			player.consoleMessage("Tech level - " + (system.techLevel + 1) + ".", 6); 
			player.consoleMessage("Economy - " + system.economyDescription + ".", 6); 
		} 
		if(this.extraB) {
			if(this.systemSafety > 5) player.consoleMessage("Beware, significant pirate activity has been reported in this system!", 6) // if there are significantly more pirates/Thargoids than police/military
			else if(this.systemSafety < -5) player.consoleMessage("This system has a strong police presence.", 6) // if there are significantly less pirates/Thargoids than police/military
				else player.consoleMessage("No reports of major pirate activity.", 6); // if system is balanced between police/military and pirates/Thargoids
			if(this.thargoidCount > 0) if(this.thargoidCount == 1) player.consoleMessage ("Thargoid reported in system.", 6)
				else if(this.thargoidCount < 8) player.consoleMessage ("Thargoids reported in system.", 6)
					else player.consoleMessage ("Thargoid invasion reported in system!", 6);
			if(system.sun.isGoingNova) player.consoleMessage ("The sun is going nova! Get out now!", 6);
		}
	}
} else if(this.logging) log("Player in interstellar space");
}

/*
this.name		= "rockHermit_Locator";
this.author		= "eric walch";
this.copyright	= "? 2008 the Oolite team.";
this.description	= "This script places buoys at rockHermites and Pirate Coves. translation of Frame's legacy code";
this.version	= "1.3.3 MOD";

"use strict";

//this.startUp = this.reset = function ()
this.startUp = function ()
{
	this.buoysAdded = false;
}

this.shipExitedWitchspace = function ()
{
	this.buoysAdded = false;
// use a delay to allow all other oxp's to add their stuff before we start counting hermits.
	this.buoyTimer = new Timer(this, this.addBuoys, 1);
}
*/
this.equipmentDamaged = this.equipmentDestroyed  = function (equipment)
{
	if (equipment === "EQ_ROCKHERMIT_SCANNER") this.swichOffBuoys();
}

this.addBuoys = function ()
{
	if (this.buoysAdded) return;
	log(this.name,"Adding Buoys!");
	if (this.buoyTimer) {this.buoyTimer.stop(); delete this.buoyTimer};
	this.buoy = (player.ship.equipmentStatus("EQ_ROCKHERMIT_SCANNER") === "EQUIPMENT_OK") ? "rockbeacon" : "rockbeacof";
	var stationz = system.shipsWithRole("station");
	for (var i = 0; i < stationz.length; i += 1)
	{
		if (stationz[i].name == "Rock Hermit" || stationz[i].name == "Salvage Gang") {
			log(this.name,"Adding Buoy for: "+stationz[i].name+" #: "+i);
//			system.legacy_addShipsAtPrecisely(buoy, 1, "abs", stationz[i].position.add(stationz[i].heading.multiply(10E3)));
			if (0 < oolite.compareVersion("1.75")) system.addShips(this.buoy, 1, stationz[i].position.add(stationz[i].orientation.vectorForward().multiply(10E3)), 1);
			else system.addShips(this.buoy, 1, stationz[i].position.add(stationz[i].vectorForward.multiply(10E3)), 1);
		}
	}
/*
	function addIfRockHermit(ships, buoy) {
		for (var i = 0; i < ships.length; i += 1) {
			if (ships[i].name == "Rock Hermit" || ships[i].name == "Salvage Gang" ) {
				system.legacy_addShipsAtPrecisely(buoy, 1, "abs", ships[i].position.add(ships[i].heading.multiply(10E3)));
				if (0 < oolite.compareVersion("1.75")) system.addShips(buoy, 1, ships[i].position.add(ships[i].orientation.vectorForward().multiply(10E3)), 1);
				else system.addShips(buoy, 1, ships[i].position.add(ships[i].vectorForward.multiply(10E3)), 1);
			}
		}
	}
	addIfRockHermit(system.shipsWithPrimaryRole("rockhermit"), this.buoy);
	addIfRockHermit(system.shipsWithPrimaryRole("pirate-cove"), this.buoy); // I guess Pirate Coves get 2 buoys because they have both roles?
	addIfRockHermit(system.shipsWithPrimaryRole("anarchies_salvage_gang"), this.buoy); // added!
*/
	this.buoysAdded = true;
};

this.swichOnBuoys = function ()
{
	var buoys = system.shipsWithPrimaryRole("rockbeacon");
	var newBuoy;
	this.buoy = "rockbeacon";
	if (buoys.length>0) for (var i=0; i<buoys.length;i++) {
		newBuoy = buoys[i].spawnOne(this.buoy);
		newBuoy.position = buoys[i].position;
		newBuoy.orientation = buoys[i].orientation;
		buoys[i].remove();
	}
}

this.swichOffBuoys = function ()
{
	var buoys = system.shipsWithPrimaryRole("rockbeacof");
	var newBuoy;
	this.buoy = "rockbeacof";
	if (buoys.length>0) for (var i=0; i<buoys.length;i++) {
		newBuoy = buoys[i].spawnOne(this.buoy);
		newBuoy.position = buoys[i].position;
		newBuoy.orientation = buoys[i].orientation;
		buoys[i].remove();
	}
}
// End of Rock Hermit Buoy locator

/*
"use strict";
this.name               = "hermit_tweaks";
this.author               = "spara";
this.description         = "tweak hermits to show their colors when docked";
this.licence     = "CC BY-NC-SA 4.0";
*/
this._guiScreenWillChange = function(to, from) {
	if (to === "GUI_SCREEN_STATUS") {
		switch (this.$station.primaryRole) {
			case "rockhermit":
				this._rename(this.$station, "mining base");
				break;
			case "rockhermit-chaotic":
				this._rename(this.$station, "neutral harbor");
				break;
			case "rockhermit-pirate":
				this._rename(this.$station, "pirate hideout");
				break;
		}
	} else if (from === "GUI_SCREEN_STATUS" && this.$saveName) {
		this.$station.displayName = this.$saveName;
		delete this.$saveName;
	}
}

this.shipWillLaunchFromStation = function(station) {
	if (this.$saveName) station.displayName = this.$saveName;
	delete this.guiScreenWillChange;
	delete this.$saveName;
	delete this.$station;
}

this._rename = function(station, addendum) {
	if (!this.$saveName) {
		this.$saveName = station.displayName;
		station.displayName += " (" + addendum + ")";
	}
}

//----------------------------------
// Rest of Misjump Analyzer scripts!

this.playerStartedJumpCountdown = function (jump)
{

// quick-and-dirty check to see if in Galaxy Charts 0-7 (1-8), if not complain about being off-the-charts.
	if(galaxyNumber >7 || galaxyNumber <0) {
// DIRE warnings about being off-the-charts.
		player.commsMessage("Outside known space! No matching Star Charts found! Misjump Analyzer only partially functional!",6);
		log(this.name,"Outside known space! No matching Star Charts found! Misjump Analyzer may be only partially functional!");
		var CurX = Math.floor(player.ship.galaxyCoordinates.x);
		var CurY = Math.floor(player.ship.galaxyCoordinates.y);
		var DestX = Math.floor(player.ship.cursorCoordinates.x);
		var DestY = Math.floor(player.ship.cursorCoordinates.y);
//		if(system.ID == player.ship.targetSystem && jump == "galactic" && player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_FIXED_COORDINATES") {
		if(system.ID == player.ship.targetSystem && jump == "galactic") {
			var DestX = Math.floor(player.ship.galacticHyperspaceFixedCoords[0]);
			var DestY = Math.floor(player.ship.galacticHyperspaceFixedCoords[1]);
			player.commsMessage("Galactic Jump X, Y test: "+DestX+" , "+DestY,6);
			log(this.name,"Galactic Jump X, Y test: ",DestX," , ",DestY);
		}
		var xDif = Math.floor(Math.abs(CurX - DestX));
		var yDif = Math.floor(Math.abs(CurY - DestY)*0.5);
		this.dist = 0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif));
//		this.dist = 9;
	} else {
		this.dist = System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,player.ship.targetSystem));
// in 'known' 1-8 Star Charts ...but!
//	if(galaxyNumber < 8 && galaxyNumber > -1) {	// previous if check assures inside this range
// Checks to see if in alternate Oolite universe!
		var testCoords=[[4.8,40.6,0],[9.6,30.4,0],[31.2,42.4,0],[62.4,34.2,0],[51.2,28.8,0],[86.4,27.6,0],[70.8,4.6,0],[90.8,39.8,0]];
		if(System.infoForSystem(galaxyNumber, 255).coordinates.distanceTo(testCoords[galaxyNumber]) > 0.1) {
			player.commsMessage("Outside known space! No matching Star Charts found! Misjump Analyzer only partially functional!",6);
			log(this.name,"Outside known space! No matching Star Charts found! Misjump Analyzer may be only partially functional!");
			this.dist += 1999;
		}
	}
//		} else this.dist = System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,player.ship.targetSystem));
//	if(jump == "galactic" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_STANDARD") this.dist += 999;	// Non-standard Galactic Hyperjump really cause a freak-out of Misjump Analyser!
	if(jump == "galactic") this.dist += 999;
//	if(jump == "galactic") this.dist = 200+Math.floor(Math.random()*56);
	this.dist = Number(this.dist.toFixed(1));

//	if(player.ship.fuel < this.dist) return; // make sure the player has enough fuel left.
//	if(player.ship.equipmentStatus("EQ_MISJUMP_ANALYSER") === "EQUIPMENT_OK" && (player.ship.scriptedMisjump == 1 || system.isInterstellarSpace || this.dist > 6.8)) {
// This if does the checks for "weird conditions" that suggest a bad jump coming up:
//	if(player.ship.equipmentStatus("EQ_MISJUMP_ANALYSER") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_SCANNER_SHOW_MISSILE_TARGET") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_WORMHOLE_SCANNER") == "EQUIPMENT_OK" && ((player.ship.scriptedMisjumpRange > 0 && player.ship.scriptedMisjumpRange != 0.5 && player.ship.scriptedMisjumpRange < 1) || player.ship.scriptedMisjump == 1 || system.isInterstellarSpace || (jump != "galactic" && this.dist < 0.1) || this.dist > 6.8)) {
	if(player.ship.equipmentStatus("EQ_MISJUMP_ANALYSER") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_SCANNER_SHOW_MISSILE_TARGET") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_WORMHOLE_SCANNER") == "EQUIPMENT_OK" && ((player.ship.scriptedMisjumpRange > 0 && player.ship.scriptedMisjumpRange != 0.5 && player.ship.scriptedMisjumpRange < 1) || player.ship.scriptedMisjump == 1 || (jump == "galactic" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_STANDARD") || (jump != "galactic" && (this.dist < 0.1 || this.dist > 6.8)))) {
		if (this.misjumpTimer) {
			this.misjumpTimer.stop();
			delete this.misjumpTimer;
		}
//		this.misjumpTimer = new Timer(this, this.giveWarning, 0.5+Math.random()*8);
		this.misjumpTimer = new Timer(this, this.giveWarning, 1+Math.random()*9);
	}
}

this.playerCancelledJumpCountdown = function ()
{
//	this.misjumpTimer.stop();
//	delete this.misjumpTimer;
	if(this.misjumpTimer) {
		this.misjumpTimer.stop();
		delete this.misjumpTimer;
	}
}
/*
this.playerWillEnterWitchspace = this.shipExitedWitchspace = function ()
{
	if(player.ship.scriptedMisjump == 1) this.giveWarning;
}
*/
this.giveWarning = function ()
{
		player.commsMessage("Warning: witchspace disturbance detected "+this.dist+" LY ahead!",6);
		log(this.name,"Warning: witchspace disturbance detected "+this.dist+" LY ahead!");
		player.commsMessage("Misjump?: "+player.ship.scriptedMisjump+" , Misjump %: "+player.ship.scriptedMisjumpRange+" , Interstellar Space?: "+system.isInterstellarSpace,6);
//		player.commsMessage("Guaranteed misjump?: "+player.ship.scriptedMisjump+" , Misjump percentage: "+player.ship.scriptedMisjumpRange+" , in Interstellar Space?: "+system.isInterstellarSpace,6);
//		player.commsMessage("Guaranteed misjump?: "+player.ship.scriptedMisjump+" , Misjump percentage: "+player.ship.scriptedMisjumpRange+" , in Interstellar Space?: "+system.isInterstellarSpace+" , Jump Distance?: "+this.dist+" LY ahead!",6);
//		player.commsMessage("Cause of warning: Guaranteed misjump?: "+player.ship.scriptedMisjump+" , Fractional misjump distance: "+player.ship.scriptedMisjumpRange+" , in Interstellar Space?: "+system.isInterstellarSpace+" , Jump Distance?: "+this.dist+" LY ahead!",6);
		this.mySound.play();
}
/*
this.name			= "fuelTankMine";
this.author			= "Eric Walch (js script)";
this.copyright		= "Share alike";
this.description	= "fueltank mine";
this.version		= "2.3";

"use strict";
*/
this.$awardFuel = function ()
{
	this.ship.owner.fuel += 3;
}
