this.name           = "vector_richman";
this.author         = "Svengali";
this.copyright      = "CC-by-nc-sa-3.0";
this.description    = "Richmans World";
this.version        = "1.1";

this.cargoAmount = Math.ceil(Math.random()*8);
this.hitsCounter = 0;
this.entryNumber = (Math.random()*this.ship.entityPersonality)&3;
this.podToEject = ["vector_cpodA", "vector_cpodB", "vector_cpodC", "vector_cpodD"];

this.shipSpawned = function()
{
	if (system.countShipsWithRole('vector') > 1) this.ship.switchAI('vector_leaveAI.plist');
	else {
		if (this.ship.primaryRole == "vector_richman") this.ship.primaryRole = "trader";
		if (this.ship.hasRole("vector_frood")) this.vector_plea = '[vector_pleaFrood]';
		else if (this.ship.hasRole("vector_geek")) this.vector_plea = '[vector_pleaGeek]';
		else if (this.ship.hasRole("vector_millionaire")) this.vector_plea = '[vector_pleaMillionaire]';
		this.ship.name = "Vector"+this.ship.scriptInfo.epod_name; this.ship.displayName = "Vector"+this.ship.scriptInfo.epod_name;
		if (system.goingNova || system.goneNova) { this.ship.switchAI('vector_leaveAI.plist'); return; }
		if (system.mainStation.position.distanceTo(this.ship) < 25000 || this.entryNumber == 1) this.ship.switchAI('vector_sunskimAI.plist');
		else { this.ship.switchAI('vector_traderAI.plist'); this.ship.fuel = 2;
			if (!worldScripts.buoyRepair) { this.dockStation = null; return; }
			if(worldScripts.buoyRepair.grsStation && Math.random < 0.4) this.dockStation = worldScripts.buoyRepair.grsStation; }
	if (worldScripts.vector.logging) { log('Vector','Entering system.'); this.ship.reportAIMessages = true; } }
}

this.shipBeingAttacked = function(whom)
{
	if (this.cargoAmount > 0) this.vectorDropCargo(whom);
	this.vectorDisplayName();
}
this.shipAttackedWithMissile = function(missile,whom)
{
	this.ship.target = missile;
	if (this.cargoAmount > 0) this.vectorDropCargo(whom);
	this.vectorDisplayName();
}
this.shipDestroyedTarget = function()
{
	this.ship.displayName = "Vector (Pleased "+this.ship.scriptInfo.name+")";
}

this.vectorDisplayName = function()
{
	if (this.ship.energy == this.ship.maxEnergy) this.ship.displayName = "Vector ("+this.ship.scriptInfo.name+")";
	if (this.ship.energy > 430 && this.ship.energy < this.ship.maxEnergy) this.ship.displayName = "Vector (Angry "+this.ship.scriptInfo.name+")";
	if (this.ship.energy < 431 && this.ship.energy > 179) this.ship.displayName = "Vector (Shaked "+this.ship.scriptInfo.name+")";
	if (this.ship.energy < 180) this.ship.displayName = "Vector (Scared "+this.ship.scriptInfo.name+")";
	this.entryNumber = (Math.random()*this.ship.entityPersonality)&3;
}

this.vectorDropCargo = function(whom)
{
	if (this.hitsCounter < 5) this.hitsCounter++;
	else { this.ship.ejectSpecificItem(this.podToEject[this.entryNumber]); this.cargoAmount -= 1; this.hitsCounter = 0;
		if (whom.isPlayer) { player.commsMessage(expandDescription([this.vector_plea])); } }
	this.vectorDisplayName();
}

this.shipHitByECM = function(ecmPulsesRemaining)
{
	if (!this.ship.target && ecmPulsesRemaining == 0 && (this.ship.AIState == "HEAD_FOR" || this.ship.AIState == "GO_TO_WAYPOINT") && this.ship.escorts) this.ship.AIState = 'SCAN_AREA';
}

this.checkTarget = function()
{
	var attackbreak = false;
	if (this.ship.escorts) {
		for (var i = 0; i != this.ship.escorts.length-1; i++) {
			if (this.ship.escorts[i] == this.ship.target) { attackbreak = true; this.ship.target = null; this.ship.AIState = 'HEAD_FOR'; } }
		if (!attackbreak) { this.ship.AIState = 'ATTACK_SHIP'; } }
	else {
		if (this.ship.energy < 250) this.ship.AIState = 'FLEE';
		else this.ship.AIState = 'ATTACK_SHIP';
	}
}

this.checkDistanceToSun = function()
{
	if (this.ship.AI == "vector_sunskimAI.plist" && system.sun.position.distanceTo(this.ship) < system.sun.radius*2.5) { this.ship.fuel += 3.0; this.ship.reactToAIMessage("SPEED_UP"); }
}
this.addFuel = function()
{
	this.ship.fuel += 3.0;
}
this.getStation = function()
{
	if (!this.dockStation || Math.random() < 0.4) { this.ship.target = system.mainStation; this.ship.AIState = 'GO_TO_STATIONA'; }
	else { this.ship.target = this.dockStation; this.ship.AIState = 'GO_TO_STATIONB'; }
	return;
}
