this.name        = "vector";
this.author      = "Svengali";
this.copyright   = "CC-by-nc-sa-3.0";
this.description = "Vector - Richmans World - Compatible to OXPConfig";
this.version     = "1.1";

this.startUp = function()
{
	this.logging = false; this.audio = true;
	this.mySound = new SoundSource; this.mySound.loop = true; this.addChance = 1; this.isReloaded = true;
	this.friends = ["low","acceptable","average","medium","high","dangerous","extreme"];
}

this.reset = function()
{
	if (!missionVariables.vector_expFactor) { missionVariables.vector_expFactor = 0.01; missionVariables.vector_cpods = 0; missionVariables.vector_cpod = "";
		missionVariables.vector_epods = 0; missionVariables.vector_epod = ""; missionVariables.vector_passengerState = 0; }
	this.reactScreen = 0; this.isReloaded = false; this.mySound.stop(); this.hasShown = false; this.expFactor = missionVariables.vector_expFactor;
}

this.guiScreenChanged = function()
{
	if (!player.ship.docked) return;
	if (this.isReloaded) this.reset();
	if (guiScreen == "GUI_SCREEN_MISSION" || missionVariables.offering || mission.choice) return;
	if (this.advice && this.advice != "") player.commsMessage(this.advice,8);
}

this.shipDockedWithStation = function()
{
	this.amountPodsA = missionVariables.vector_epods; this.amountPodsB = missionVariables.vector_cpods; this.expFactor = missionVariables.vector_expFactor;
	this.sumPods = 0; this.sumCargo = 0; this.sumToOffer = 0; this.sumTotal = 0; this.factorRisk = 0; this.reactScreen = 0; this.revenge = 0;
	this.lastPodName = ""; this.lastCargoName = ""; this.advice = ""; this.penalty = 0; this.mySound.stop();
	this.missionOffers();
}

this.missionOffers = function()
{
	if (guiScreen == "GUI_SCREEN_MISSION" || (missionVariables.offering && missionVariables.offering != "VECTOR") || (mission.choice && mission.choice != "")) return;
	if (this.hasShown) return;
	if (!this.amountPodsA && !this.amountPodsB && this.expFactor && this.expFactor > 0.20 && Math.random() < 0.02 && !this.sumPods && !this.sumCargo) {
		missionVariables.offering = "VECTOR"; this.advice = expandDescription("[vector_revenge]"); this.revenge = Math.ceil(Math.log(this.expFactor*500)*0.25);
		this.showScreen("VECTOR_MESSAGE", 'vector_message'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_messagemusic.ogg',1);
		this.reactScreen = 64; this.finishedAndExit(); return; }
	this.expLog = Math.log(this.expFactor*500); this.rangePlus = this.expLog*0.025;
	var hint = Math.floor(Math.log((1+system.government)*this.expLog)*1.7);
	if (this.amountPodsA && this.amountPodsA > 0) {
		if (this.amountPodsA == 1) {
			if (this.expFactor < 0.4) { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERA", null, 'vector_opener.ogg',null); }
			else { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERC", null, 'vector_opener.ogg',null); } }
		if (this.amountPodsA > 1) {
			if (this.expFactor < 0.4) { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERB", null, 'vector_opener.ogg',null); }
			else { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERD", null, 'vector_opener.ogg',null); } }
		missionVariables.offering = "VECTOR"; this.vectorNames = missionVariables.vector_epod.split("|");
		for (var i = 0; i != this.amountPodsA; i++) { this.calculateSum(i,this.amountPodsA); mission.addMessageText("Esc-Pod:\r\r"+this.nickName+" "+this.familyName+" "+this.typeName+'.'); }
		mission.addMessageTextKey("VECTOR_LINE"); this.sumPods = Math.ceil(this.sumToOffer); if (this.sumPods < 400) this.sumPods = 400;
		if (this.expFactor >= 0.4) { mission.addMessageText("\r\r\r\r\r\r\r\rPossible ransom: "+this.sumPods+" Credits."); }
		else { mission.addMessageText("\n"); }
		if (this.expFactor > 0.2) mission.addMessageText("\nFriends gave you a hint that the risk for such transactions is currently "+this.friends[hint]+".");
		else mission.addMessageText("\n");
		mission.addMessageTextKey("VECTOR_QUESTION"); this.sumToOffer = 0; }
	else {
		if (this.amountPodsB && this.amountPodsB > 0) {
			if (this.expFactor < 0.3) { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERE", null, 'vector_opener.ogg',null); }
			else { this.showScreen("VECTOR_WELCOME", 'vector_cargobay'+Math.floor(Math.random()*2)+'.png', "VECTOR_OFFERF", null, 'vector_opener.ogg',null); }
			missionVariables.offering = "VECTOR"; this.vectorNames = missionVariables.vector_cpod.split("|");
			for (var i = 0; i != this.amountPodsB; i++) { this.calculateSum(i,this.amountPodsB); mission.addMessageText("Cargo:\r\r"+this.nickName+" "+this.familyName+" "+this.typeName+"."); }
			mission.addMessageTextKey("VECTOR_LINE"); this.sumCargo = Math.ceil(this.sumToOffer); if (this.sumCargo < 300) this.sumCargo = 300;
			if (this.expFactor >= 0.3) { mission.addMessageText("\r\r\r\r\r\r\r\rPossible deal: "+this.sumCargo+" Credits."); }
			else { mission.addMessageText("\n"); }
			if (this.expFactor > 0.1) mission.addMessageText("\nFriends gave you a hint that the risk for such transactions is currently "+this.friends[hint]+".");
			else mission.addMessageText("\n");
			mission.addMessageTextKey("VECTOR_QUESTION"); this.sumToOffer = 0; } }
}

this.choiceEvaluation = function()
{
	if (missionVariables.offering == "VECTOR") {
		switch (mission.choice) {
			case "VECTOR_FREE":
				if (this.expFactor > 0.01) { this.expFactor -= 0.01; missionVariables.vector_expFactor -= 0.01; }
				this.amountPodsA = 0; this.reactScreen += 1; missionVariables.vector_passengerState = 0;
				this.podSound = 0; this.sumPods = this.sumPods/6; break;
			case"VECTOR_SLAVE":
				if (this.expFactor < 1) { this.expFactor += 0.01; missionVariables.vector_expFactor += 0.01; }
				this.amountPodsA = 0; this.reactScreen += 2; missionVariables.vector_passengerState = 0;
				this.podSound = 0; this.sumPods = this.sumPods/4; break;
			case "VECTOR_ZRANSOM":
				if (this.expFactor < 0.97) { this.expFactor += 0.03; missionVariables.vector_expFactor += 0.03; }
				this.amountPodsA = 0; this.reactScreen += 4; missionVariables.vector_passengerState = 0;
				this.podSound = 0; break;
			case "VECTOR_LEAVE":
				if (this.expFactor > 0.01) { this.expFactor -= 0.01; missionVariables.vector_expFactor -= 0.01; }
				this.amountPodsB = 0; this.sumCargo = this.sumCargo/6; this.reactScreen += 8; break;
			case "VECTOR_SELL":
				if (this.expFactor < 1) { this.expFactor += 0.01; missionVariables.vector_expFactor += 0.01; }
				this.amountPodsB = 0; this.sumCargo = this.sumCargo/4; this.reactScreen += 16; break;
			case "VECTOR_ZDEAL":
				if (this.expFactor < 0.97) { this.expFactor += 0.02; missionVariables.vector_expFactor += 0.02; }
				this.amountPodsB = 0; this.reactScreen += 32; break;
			default:
				this.amountPodsA = 0; this.amountPodsB = 0;
		}
		if (!this.amountPodsA && !this.amountPodsB) this.createReaction();
		else mission.choice = null;
	}
}

this.missionScreenEnded = function()
{
	if (!player.ship.docked || this.hasShown) return;
	if (mission.choice) { this.choiceEvaluation(); this.missionOffers(); }
}

this.missionChoiceWasReset = function()
{
	if (!this.amountPodsA && !this.amountPodsA && this.hasShown && this.advice) { player.commsMessage(this.advice,8); this.advice = ""; }
	if (!player.ship.docked || this.hasShown) return;
	this.missionOffers();
}

this.shipWillLaunchFromStation = function()
{
	if (missionVariables.offering) {
		if (missionVariables.offering == "VECTOR" && !this.hasShown) log('Vector','Vector: missionVariables.offering not cleared - Launched while missionscreen');
		if (missionVariables.offering && missionVariables.offering != "VECTOR") log('Vector','Vector: Warning: An other oxp has not cleared missionVariables.offering - '+missionVariables.offering); }
	if (typeof(mission.choice) != "object") log('Vector','Vector: mission.choice not cleared - '+mission.choice);
	this.addChance++; if (this.addChance > 7) this.addChance = 1;
}
this.shipLaunchedFromStation = function()
{
	if (missionVariables.vector_epods > 0) {
		if (missionVariables.vector_passengerState == 1) { this.setSound(1); player.commsMessage("Your passenger is still totally drunken."); }
		if (missionVariables.vector_passengerState == 2) { this.setSound(2); player.commsMessage("Your passenger is still a little bit renitent."); } }
	this.hasShown = false;
	if (!this.revenge) return;
	system.legacy_addSystemShips('vector_revenge1', this.revenge, 0.99); this.revenge = 0;
}

this.createReaction = function()
{
	this.sumPods = Math.ceil(this.sumPods); this.sumCargo = Math.ceil(this.sumCargo);
	this.sumTotal = this.sumPods+this.sumCargo; this.advice = "";
	this.calculateRisk(); var chance = Math.random();
	if ((this.reactScreen&1)) this.freeHim(chance);
	if ((this.reactScreen&2)) this.sellAsSlave(chance);
	if ((this.reactScreen&4)) { this.factorRisk += 1.5; this.ransomNow(chance); }
	if ((this.reactScreen&8)) this.giveBack(chance);
	if ((this.reactScreen&16)) this.blackMarket(chance);
	if ((this.reactScreen&32)) { this.factorRisk += 1.3; this.makeDeal(chance); }
	this.finishedAndExit();
}
this.freeHim = function(chance)
{
	if (chance > (0.25-this.rangePlus*0.5)) { this.reactScreen &= 56; this.sumPods = 0; return; }
	this.advice = expandDescription("[vector_free]")+"\nWith this words "+this.lastPodName+" presents you\n"+this.sumPods+".0 credits for his safe return.";
	this.showScreen("VECTOR_MESSAGE", 'vector_thanks'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_giftmusic.ogg',1);
	return;
}
this.sellAsSlave = function(chance)
{
	if (this.factorRisk > 25 && chance > (0.90-this.rangePlus)) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*2.5))+".0 credits\nfor slavery and added an entry to your ID.";
		this.calculatePenalty(this.sumTotal*2.5); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64; player.ship.bounty += 3;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	if (chance < 0.15) { this.reactScreen &= 56; this.sumPods = 0; this.advice = "The slaver tricked you and you lost your money."; return; }
	if (chance > 0.25 && chance < 0.40 && this.factorRisk > 1) { this.reactScreen &= 56; this.advice = "GalCop Police has confiscated your Pods."; this.sumPods = 0; return; }
	if (chance > 0.45 && chance < (0.50+this.rangePlus*0.5) && this.factorRisk > 4) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*2))+".0 credits\nfor intentional slavery.";
		this.calculatePenalty(this.sumTotal*2); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	this.advice = "The slaver paid "+this.sumPods+".0 credits for your special cargo.";
	return;
}
this.ransomNow = function(chance)
{
	if (this.factorRisk > 20 && chance > (0.90-this.rangePlus)) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*4))+".0 credits\nfor intentional hijacking of "+this.lastPodName+"\nand added an entry to your ID.";
		this.calculatePenalty(this.sumTotal*4); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64; player.ship.bounty += 3;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	if (chance > 0.25 && chance < 0.40 && this.factorRisk > 1) { this.reactScreen &= 56; this.advice = "GalCop Police has confiscated your Pods."; this.sumPods = 0; return; }
	if (chance > 0.45 && chance < (0.50+this.rangePlus*0.7) && this.factorRisk > 3) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*3.2))+".0 credits\nfor kidnapping "+this.lastPodName+".";
		this.calculatePenalty(this.sumTotal*3.2); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	this.advice = "The family paid to you: "+this.sumPods+".0 credits.";
	return;
}
this.giveBack = function(chance)
{
	if (chance < (0.75+this.rangePlus*0.5)) { this.reactScreen &= 7; this.sumCargo = 0; return; }
	this.advice = "For returning the "+this.lastCargoName+"\nwe'll award you "+this.sumCargo+".0 credits.\n\nIt takes a few moments to transfer it\nto your account.";
	this.showScreen("VECTOR_MESSAGE", 'vector_official'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_giftmusic.ogg', 1);
	return;
}
this.blackMarket = function(chance)
{
	if (this.factorRisk > 25 && chance < (0.10+this.rangePlus)) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*2.5))+".0 credits\nfor intentional dealing with stolen goods\nand added an entry to your ID.";
		this.calculatePenalty(this.sumTotal*2.5); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64; player.ship.bounty += 3;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	if (chance > 0.75) { this.reactScreen &= 7; this.sumCargo = 0; this.advice += "\nThe dealer tricked you and you lost your money."; return; }
	if (chance > 0.15 && chance < (0.20+this.rangePlus*0.5) && this.factorRisk > 1) { this.reactScreen &= 7; this.advice += "\nGalCop Police has confiscated your stolen goods.";
		this.sumCargo = 0; return; }
	if (chance > 0.45 && chance < (0.60+this.rangePlus*0.8) && this.factorRisk > 4) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*2))+".0 credits\nfor dealing with stolen goods.";
		this.calculatePenalty(this.sumTotal*2); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	this.advice += "\nOn the blackmarket you got: "+this.sumCargo+".0 credits.";
	return;
}
this.makeDeal = function(chance)
{
	if (this.factorRisk > 20 && chance < (0.10+this.rangePlus)) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*4.5))+".0 credits\nfor attempted extortion and added an entry\nto your ID.";
		this.calculatePenalty(this.sumTotal*4.5); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64; player.ship.bounty += 3;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	if (chance > 0.15 && chance < (0.20+this.rangePlus*0.5) && this.factorRisk > 1) { this.reactScreen &= 7; this.advice += "\nGalCop Police has confiscated your stolen goods.";
		this.sumPods = 0; return; }
	if (chance > 0.45 && chance < (0.50+this.rangePlus*0.8) && this.factorRisk > 5) { this.advice = "GalCop Police fined you with "+(Math.ceil(this.sumTotal*3))+".0 credits\nfor attempted extortion.";
		this.calculatePenalty(this.sumTotal*3); this.sumPods = 0; this.sumCargo = 0; this.reactScreen = 64;
		this.showScreen("VECTOR_MESSAGE", 'vector_caught'+Math.floor(Math.random()*2)+'.png', null, null, 'vector_caughtmusic.ogg', 1); return; }
	this.advice += "\nThe assurance paid: "+this.sumCargo+".0 credits.";
	return;
}

this.calculatePenalty = function(penalty)
{
	if (player.credits < penalty) { player.credits = 30; return; }
	player.credits -= penalty;
	return;
}
this.calculateSum = function(i,amount)
{
	var vectorCurrentName = this.vectorNames[i].split(" ");
	this.nickName = vectorCurrentName[0]; this.familyName = vectorCurrentName[1];
	if (!vectorCurrentName[2]) { vectorCurrentName[2] = '(unknown)'; }
	this.typeName = vectorCurrentName[2]; var factorPod = 1;
	if (vectorCurrentName[2] == '(unknown)') { factorPod = 1.0; this.lastPodName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Frood)') { factorPod += 1.3; this.lastPodName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Geek)') { factorPod += 1.6; this.lastPodName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Millionaire)') { factorPod += 2; this.lastPodName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Collection)') { factorPod += 1.1; this.lastCargoName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Precious)') { factorPod += 0.7; this.lastCargoName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Heirloom)') { factorPod += 0.3; this.lastCargoName = this.nickName+' '+this.familyName; }
	if (vectorCurrentName[2] == '(Unknown)') { factorPod += 0.2; this.lastCargoName = this.nickName+' '+this.familyName; }
	var singleSum = Math.log(system.productivity*this.expFactor*(factorPod*((1+system.government)/2)))*(500*this.expFactor)*(1+Math.random());
	this.sumToOffer += singleSum;
	return;
}
this.calculateRisk = function(pods)
{
	this.factorRisk = 2;
	if (player.ship.dockedStation.isMainStation) this.factorRisk *= 1.5;
	else { var curstat = player.ship.dockedStation.name;
		if (curstat == "Pirate Rock" || curstat == "Collective ZGF") this.factorRisk *= 0.7;
		if (curstat == "Free Trade Zone" || curstat == "Rebel Outpost" || curstat == "Pirate Base" || curstat == "Hacker Outpost") this.factorRisk *= 0.8;
		if (curstat == "Astromine Penal Colony" || curstat == "Augeaian Orbital Repair Facility" || curstat == "Collective SLAPU Imperial AstroFactory" || curstat == "Black Monk Monastery") this.factorRisk *= 0.8;
		if (curstat == "Deep Space Hoopy Hotel : Lernean Branch" || curstat == "Deep Space Hoopy Hotel : Hades Branch" || curstat == "Deep Space Hoopy Hotel : Hades Branch" || curstat == "Hesperides Wiseguy Way-Station") this.factorRisk *= 1.1;
		if (player.ship.dockedStation.AI == "randomhitsbarAI.plist") this.factorRisk *= 1.2;
		if (curstat == "Sun Research Station Alpha" || curstat == "Sun Research Station Beta" || curstat == "Sun Research Station Omega" || curstat == "Sun Research Station Delta") this.factorRisk *= 1.2;
		if (curstat == "The Link Base" || curstat == "Griff Research Ltd Orbital Base" || curstat == "Rock Hermit" || curstat == "Salvage Gang") this.factorRisk *= 1.2;
		if (curstat == "GRS Buoy Factory" || curstat == "Special Interstellar Repairs and Shipyard Facility") this.factorRisk *= 1.6;
		if (curstat == "Liberty Station" || curstat == "Special Branch Orbital Headquaters" || curstat == "Navy SecCom Station" || curstat == "Taranis Corporation HQ") this.factorRisk *= 1.8; }
	this.factorRisk *= (Math.log((this.sumPods+this.sumCargo)/32)*(1+system.government)*Math.random())*this.expFactor;
	this.factorRisk = Math.ceil(this.factorRisk/(1+(system.government*Math.random())));
	return;
}

this.setSound = function(newSound)
{
	if (!this.audio) return;
	if (newSound == 1) { this.mySound.sound = 'vector_passenger1.ogg'; this.mySound.play(); missionVariables.vector_passengerState = 1; }
	if (newSound == 2) { this.mySound.sound = 'vector_passenger2.ogg'; this.mySound.play(); missionVariables.vector_passengerState = 2; }
	return;
}

this.finishedAndExit = function()
{
	if (this.logging) { log('Vector','Pods:'+this.amountPodsA+' Cargo:'+this.amountPodsB+' SumA:'+this.sumPods+' SumB:'+this.sumCargo);
		log('Vector','expFactor:'+this.expFactor+' factorRisk:'+this.factorRisk+' sumTotal:'+this.sumTotal);
		log('Vector','Last Pod:'+this.lastPodName+' Last Cargo:'+this.lastCargoName);
		log('Vector','Screen:'+this.reactScreen+' sumOffer:'+this.sumToOffer+' PassState:'+missionVariables.vector_passengerState); }
	missionVariables.vector_epods = 0; missionVariables.vector_epod = ""; missionVariables.vector_cpods = 0; missionVariables.vector_cpod = "";
	this.nickName = null; this.familyName = null; this.typeName = null; this.sumToOffer = null; this.podSound = 0; this.hasShown = true;
	if (!(this.reactScreen&64)) player.credits += this.sumPods+this.sumCargo;
	missionVariables.offering = null; mission.choice = null;
}

this.showScreen = function(text,image,offer,model,music,advice)
{
	if (this.audio) mission.runMissionScreen(text,image,offer,null,music);
	else mission.runMissionScreen(text,image,offer,null,null);
	// If two messages one will get lost, but I don't want to flood the screen, so only special screens will be shown always
	if (advice) { mission.addMessageText(this.advice); this.advice = ""; }
	return;
}

this.shipExitedWitchspace = function()
{
	if (system.isInterstellarSpace) return;
	if (system.countShipsWithRole('trader') > 8 || system.countShipsWithRole('vector') >= 1) return;
	this.addChance++; if (this.addChance > 7) this.addChance = 1;
	if (this.logging) log('Vector','Vector: Conditions:'+(system.ID&this.addChance)+' '+this.addChance+' Dist:'+this.expFactor+' ships:'+system.countShipsWithRole('vector')+' Gov:'+system.government);
	if ((system.ID&this.addChance) == this.addChance && system.government > 3 && player.score > 200) system.legacy_addSystemShips('vector_richman',1,this.expFactor);
}
