this.name           = "hyperRadio";
this.author         = "Svengali";
this.copyright      = "CC3.0-by-nc-sa";
this.description    = "HyperRadio";
this.version        = "1.06";

this.startUp = function()
{
	if (!this.hyperradio_play)
	{
		this.hyperradio_play = true;
		this.hyperradioTimerA = new Timer(this, this.hyperradioTimer, 0.5, 7);
		this.hyperradioTimerA.stop();
		this.hyperradio_iss_warning = true;
		if (oolite.compareVersion("1.71.2") < 0) { delete this.shipWillDockWithStation; }
		else { delete this.shipDockedWithStation; }
	}
}

// Can be removed in the next version - just a clean-up for 'old' variables
this.reset = function()
{
	if (missionVariables.hyperradio_play) { missionVariables.hyperradio_play = null; }
	if (missionVariables.hyperradio_current) { missionVariables.hyperradio_current = null; }
	if (missionVariables.hyperradio_next) { missionVariables.hyperradio_next = null; }
}

// Generates error in v1.71.1
this.shipDockedWithStation = function()
{
	this.hyperradioTimerA.stop();
	Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_play = true;
	this.CheckHyperradioLicence();
}

// Generates error in v1.71.2
this.shipWillDockWithStation = function()
{
	this.hyperradioTimerA.stop();
	Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_play = true;
	this.CheckHyperradioLicence();
}

this.shipLaunchedFromStation = function()
{
	if (player.hasEquipment("EQ_HYPER_RADIO"))
	{
		this.hyperradio_iss_warning = true;
		this.hyperradio_play = true;
		this.hyperradio_current = "start";
		this.hyperradio_next = "start";
		if (!missionVariables.hyperradio_last) { missionVariables.hyperradio_last = String(Math.floor(20 + (clock.days))); }
		this.hyperradioTimerA.start();
	}
}	

this.GetHyperradioSongName = function ()
{
	// Careful with expandDescriptions. If expanding an empty array Oolite will crash
	let Listofsongs = [expandDescription("[hyperradio_songlist]"), expandDescription("[hyperradio_songlist]"),
		 expandDescription("[hyperradio_songlist]"), expandDescription("[hyperradio_songlist]")];
	let songselect = Math.round(Math.random()*(Listofsongs.length-1));
	if (Listofsongs[0] == Listofsongs[1] && Listofsongs[0] == Listofsongs[2] && Listofsongs[0] == Listofsongs[3])
	{
		this.hyperradio_next = Listofsongs[0];
		// only if no or no valid descriptions.plist is found
		if (this.hyperradio_next == "hyperradio_songlist")
		{
			player.consoleMessage('WARNING. NO VALID ENTRY FOUND. HYPERRADIO DISABLED',8);
			log('HYPERRADIO','There is a problem with your descriptions.plist. It is not there or not valid. Please check it.');
		}
		return;
	}
	while (this.hyperradio_current == this.hyperradio_next) { songselect = Math.round(Math.random()*(Listofsongs.length-1)); this.hyperradio_next = Listofsongs[songselect]; }
	return;
}

this.CheckHyperradioLicence = function()
{
	if (clock.days >= parseInt(missionVariables.hyperradio_last))
	{
		player.removeEquipment("EQ_HYPER_RADIO");
		missionVariables.hyperradio_last = null;
		this.hyperradio_play = true;
		player.consoleMessage('Your HyperRadio licence is expired. Buy a new one at your local dealer.', 6);
		this.hyperradioTimerA.stop();
		return ("expired");
	}
	return ("ok");
}

this.shipExitedWitchspace = function()
{
	if (system.isInterstellarSpace && this.hyperradio_iss_warning && player.hasEquipment("EQ_HYPER_RADIO"))
	{
		if (this.hyperradio_current != "start") { Sound.stopMusic(this.hyperradio_current); }
		player.commsMessage('Hyperradio deactivated. Could not transfer data.', 8);
		this.hyperradio_iss_warning = false;
		this.hyperradioTimerA.stop();
	}
	if (!system.isInterstellarSpace) { this.hyperradio_play = true; this.hyperradio_iss_warning = true; this.hyperradioTimerA.start(); }
}

this.hyperradioTimer = function()
{
	if (player.status == "STATUS_IN_FLIGHT")
	{
		if (guiScreen == "GUI_SCREEN_SYSTEM_DATA" && !this.hyperradio_play && this.hyperradio_iss_warning)
		{
			if (player.hasEquipment("EQ_HYPER_RADIO") && this.CheckHyperradioLicence() == "ok")
			{
				Sound.stopMusic(this.hyperradio_current);
				this.GetHyperradioSongName();
				// Stop timer if no valid descriptions.plist is found
				if (this.hyperradio_next == "hyperradio_songlist") { this.hyperradioTimerA.stop(); }
				else
				{
					this.hyperradio_current = this.hyperradio_next;
					player.consoleMessage('Connection established.');
					this.hyperradio_play = true;
					Sound.playMusic(this.hyperradio_current);
				}
			}
		}
		if (guiScreen == "GUI_SCREEN_MAIN" && this.hyperradio_play) { this.hyperradio_play = false; }
	}
}