this.name      = "buoyRepair"; 
this.author    = "eric walch (script), Svengali (artwork)"; 
this.copyright = " 2008 the Oolite team.";
this.description = "This script adds buoy repairships when one of the two main navigation buoys gets destroyed";
this.version   = "1.01.5";

this.startUp = this.reset = function()
{
    this.newstart = true
    this.NLaunchQueueAdded = false
    this.testing = false
}

this.statusCheck = function()
{
    if(player.docked) this.buoyStatusTimer.stop()
    else
    {
        if(!system.isInterstellarSpace && system.countShipsWithRole("buoy-witchpoint") == 0 && system.countShipsWithRole("repairBuoyTuggerW") == 0)
            system.legacy_addShips("repairBuoyTuggerW", 1)
        if(!system.isInterstellarSpace && !this.NLaunchQueueAdded && system.shipsWithRole("buoy", system.mainStation, 20000).length == 0 && system.countShipsWithRole("repairBuoyTuggerN") == 0)
        {
            if (oolite.compareVersion("1.72") > 0) system.mainStation.call("launchShipWithRole:", "repairBuoyTuggerN")
            else system.legacy_addSystemShips("repairBuoyTuggerL", 1, 20) // far away in oolite 1.72+ 
            // (1.71 has a problem witch double launches when using scriptActions on the mainStation.)
            this.NLaunchQueueAdded = true
            if(this.testing) log("buoyRepair", "adding repairBuoyTuggerN to launch queue")
        }
    }
}

this.shipLaunchedFromStation = function()
{
    if(this.buoyStatusTimer)
        this.buoyStatusTimer.start()
    else
        this.buoyStatusTimer = new Timer(this, this.statusCheck, 15, (this.testing ? 15 : 120))
    if(this.newstart) this.addStation()
}

this.addStation = function()
{
    this.newstart = false
    if(system.economy < 2 && ((system.government > 3 && system.techLevel < 11 && system.techLevel > 4) || this.testing))
    {
        this.grsVector = new Vector(system.ID, system.ID, system.ID-256).direction()
        system.legacy_addShipsAtPrecisely("repaired-buoy-station", 1, "abs", system.mainPlanet.position.add(this.grsVector.multiply(system.mainPlanet.radius * 2)))
        this.grsStation = system.shipsWithPrimaryRole("repaired-buoy-station")[0];
        let upVector = this.grsStation.orientation.vectorUp()
        let angle = upVector.angleTo(this.grsVector)
        let cross = upVector.cross(this.grsVector).direction()
        // align the upVector to the this.grsvector
        let quaternion = this.rotateQ(this.grsStation.orientation, cross, -angle)
        if(system.economy == 1)  // tilt the station dock towards the planet in average industrial
            quaternion = this.rotateQ(quaternion, quaternion.vectorRight(), -1.1) // good values are -1.05 till -1.15
        this.grsStation.setOrientation(quaternion)
    }
}

if (0 < oolite.compareVersion("1.72")) 
{ 
    this.rotateQ = function(q, axis, angle) 
    { 
        angle *= 0.5; 
        axis = axis.multiply(Math.sin(angle)); 
        return q.multiply(Math.cos(angle), axis.x, axis.y, axis.z); 
    } 
} 
else 
{ 
    this.rotateQ = function(q, axis, angle) { return q.rotate(axis, angle); } 
}

this.shipExitedWitchspace = function()
{
    if(system.isInterstellarSpace) return
    this.addStation()
    this.NLaunchQueueAdded = false
}