"use strict";
this.name = "Goods Container 40 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "2.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	// keep tally of pylon accessories bought
	this.$gc4Count++;
    // and don't let them exceed ship's pylon-capacity
	if ((equipment == "EQ_GC4_MINE") && (this.$gc4Count<=this.$gc4MCap)) {
		player.ship.cargoSpaceCapacity += 40;
		this.$gc4Containers++;
		pc("Modifying pylon hardpoints for container clamping...",9);
		pc("Fitting 40 TC Class Container #"+this.$gc4Containers+"...",9);
		pc("F4 'Your FE Shipyards' to check your Licence.",9);
	} else
	// unmount & sell cancels all container additions
	if (equipment == "EQ_MISSILE_REMOVAL") {
		player.ship.cargoSpaceCapacity -= this.$gc4Containers*40;
		pc("Removing all 40 TC Class Containers...",9)
		pc("Restoring pylon hardpoints for weapons-use...",9);
		if ((this.$gc4Containers>0) && (!this.$gc4HFExempt)) {
			// dismantling fee
			var dft = this.$gc4Containers*this.$gc4DismantlingFee;
			this.$gc4DismantlingFeeTotal += dft;
			player.credits -= dft;
			pc("Dismantling Fee: "+dft+" cr",9);
		}
		this.$gc4Count = 0;
		this.$gc4Containers = 0;
		// reset system-to-system runs w/containers
		this.$gc4Runs = 0;
		// reset fee totals
		this.$gc4HandlingFeeTotal = 0;
		this.$gc4MaintenanceFeeTotal = 0;
	}
}


this.playerBoughtNewShip = function(ship, price) {
	// missile capacity (not exceed)
	this.$gc4MCap = player.ship.missileCapacity;
	this.$gc4Count = 0;
	this.$gc4Containers = 0;
}


this.equipmentRemoved = function(equipmentKey) {
    if (equipmentKey == "EQ_GC4_MINE") {
		player.ship.cargoSpaceCapacity -= 40;
		this.$gc4Containers--;	
		player.consoleMessage("40 TC Goods Container removed.",5);
	}
}


this.shipReleasedEquipment = function(mine) {
	this.$gc4Count--;
    if (mine == "EQ_GC4_MINE") {
		player.ship.cargoSpaceCapacity -= 40;
		this.$gc4Containers--;
		player.commsMessage("40 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 40000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.shipFiredMissile = function(missile, target) {
	this.$gc4Count--;
    if (missile == "EQ_GC4_MINE") {
		player.ship.cargoSpaceCapacity -= 40;
		this.$gc4Containers--;	
		player.commsMessage("40 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 40000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	// missile capacity (not exceed)
	this.$gc4MCap = player.ship.missileCapacity;
	this.$gc4Count = player.ship.missiles.length;
	// Load cargo space, missile & container counts if present
	if (missionVariables.gc4Cargo != null) 
		player.ship.cargoSpaceCapacity = missionVariables.gc4Cargo;
	if (missionVariables.gc4Count != null)
		this.$gc4Count = missionVariables.gc4Count;
	if (missionVariables.gc4Containers != null) 
		this.$gc4Containers = missionVariables.gc4Containers;
	// Load total fees taken
	if (missionVariables.gc4HandlingFeeTotal != null)
		this.$gc4HandlingFeeTotal = missionVariables.gc4HandlingFeeTotal;
	if (missionVariables.gc4HandlingPaid != null)
		this.$gc4HandlingPaid = missionVariables.gc4HandlingPaid;
	if (missionVariables.gc4MaintenanceFeeTotal != null)
		this.$gc4MaintenanceFeeTotal = missionVariables.gc4MaintenanceFeeTotal;
	if (missionVariables.gc4DismantlingFeeTotal != null)
		this.$gc4DismantlingFeeTotal = missionVariables.gc4DismantlingFeeTotal; 
    // Load system-to-system runs w/container
	if (missionVariables.gc4Runs != null)
		this.$gc4Runs = missionVariables.gc4Runs;
	// Load Handling fee count
	if (missionVariables.gc4HandlingCount != null)
		this.$gc4HandlingCount = missionVariables.gc4HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.gc4HFExempt != null)
		this.$gc4HFExempt = missionVariables.gc4HFExempt;
	// Load Maintenance fee count
	if (missionVariables.gc4MaintenanceCount != null)
		this.$gc4MaintenanceCount = missionVariables.gc4MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// TEST
	var sta = player.ship.dockedStation;
	if ((this.$gc4Containers<this.$gc4MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	// prepare container Account screen
	this._gc4PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$gc4Containers>0) this._gc4PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$gc4ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$gc4ET = true;
	// TEST	
	if (this.$gc4ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$gc4FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$gc4FES = true;
	// TEST	
	if (this.$gc4ET) log(this.name, "Finds FE Ships Player present");
	// missile capacity (not exceed)
	this.$gc4MCap = 0;
	// pylon-use count
	this.$gc4Count = 0;
	// container count
	this.$gc4Containers = 0;
	// purchase cost of container in cr
	this.$gc4Cost = 40000;
	// handling fee
	this.$gc4HandlingFee = 0.005*this.$gc4Cost; // 0.005 of cost
	this.$gc4HandlingFeeTotal = 0;
	this.$gc4HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$gc4HandlingCount = 0;
	this.$gc4HFExempt = "no";
	// maintenance fee
	this.$gc4MaintenanceFee = 0.05*this.$gc4Cost; // 0.05 of cost
	this.$gc4MaintenanceFeeTotal = 0;
	this.$gc4MaintenancePaid = "no" // or "yes"
	this.$gc4MaintenanceInterval = 40; // in runs (according to cost)
	this.$gc4MaintenanceCount = 0;
	// dismantling fee
	this.$gc4DismantlingFee = 0.1*this.$gc4Cost; // 0.1 of cost
	this.$gc4DismantlingFeeTotal = 0.0;
	// system-to-system runs w/container
	this.$gc4Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.gc4Count = this.$gc4Count;
	missionVariables.gc4Cargo = player.ship.cargoSpaceCapacity;
	missionVariables.gc4Containers = this.$gc4Containers;
	// save total fees taken
	missionVariables.gc4HandlingFeeTotal = this.$gc4HandlingFeeTotal;
	missionVariables.gc4MaintenanceFeeTotal = this.$gc4MaintenanceFeeTotal;
	missionVariables.gc4DismantlingFeeTotal = this.$gc4DismantlingFeeTotal;
	missionVariables.gc4HandlingPaid = this.$gc4HandlingPaid;
	// system-to-system runs w/container
	missionVariables.gc4Runs =this.$gc4Runs;
	// handling fee count
	missionVariables.gc4HandlingCount = this.$gc4HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.gc4HFExempt = this.$gc4HFExempt;
	// maintenance fee count
	missionVariables.gc4MaintenanceCount = this.$gc4MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$gc4HFExempt;
	// check we have containers, the fee is not paid, and we're not exempt
	if ((this.$gc4Containers>0) && (this.$gc4HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$gc4Containers; x++)
			fee += this.$gc4HandlingFee;
		// record fee and debit trader's account
		this.$gc4HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$gc4HandlingPaid = "yes";
		pc("40 TC Container handling fees: "+fee+" cr",9);
		this.$gc4HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$gc4Containers>0) this._gc4DoMaintenance();

	// TEST
	if ((this.$gc4Containers<this.$gc4MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	
	// prepare container Account and Licence page
	this._gc4PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$gc4Containers>0) this._gc4PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$gc4HandlingPaid = "no";
	this.$gc4Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._gc4DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$gc4Runs;
	var intv = this.$gc4MaintenanceInterval;
	var mfee = this.$gc4MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x containers
		var fee = 0;
		for (var x=1; x<= this.$gc4Containers; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$gc4MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("40 TC Container Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$gc4MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._gc4PrepAcc = function(station) {
	station.setInterface("gc4Acc",{
	title: "Your FE Shipyards 40 TC Container Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 40 TC Goods Container account screen shows terms, fees paid, load, and other useful information.",
	callback: this._gc4ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._gc4ShowAcc = function() {
	var hfc = this.$gc4HandlingCount;
	var mfc = this.$gc4MaintenanceCount;
	var mfi = this.$gc4MaintenanceInterval;
	var hft = this.$gc4HandlingFeeTotal;
	var mft = this.$gc4MaintenanceFeeTotal;
	var dft = this.$gc4DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$gc4Containers>0) 
		parameters.message +="Your Account and Licence for 40 TC Class Goods Containers x "+this.$gc4Containers+": \n\n"; 
	 else
		parameters.message +="You have no 40 TC Class Containers licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our containers are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Container account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylons for weapons-use. \n";
	
	parameters.choicesKey = "gc4Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._gc4PrepEx = function(station) {
	station.setInterface("gc4Ex",{
	title: "Your FE Shipyards Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 40-ton container class." ,
	callback: this._gc4ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._gc4ShowEx = function() {
	var priv = ((this.$gc4ET)||(this.$gc4FES));
	var privo = "";
	if (this.$gc4FES) privo="FE shipowner";
	if (this.$gc4ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 40 TC container fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "gc4YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$gc4HFExempt = "yes"; else this.$gc4HFExempt = "no";
		} else this.$gc4HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}



