this.name           = "hyperradio";
this.author         = "Svengali";
this.copyright      = "CC-by-nc-sa-3.0";
this.description    = "Can be expanded with musicpacks. Compatible to OXPConfig.";
this.version        = "1.10";

// Declare a global station list with default entry - this list is expanded by musicpacks (if installed)
var hyperradio_stationlist = new Array("[hyperradio_songlist0]");

this.startUp = function()
{
	this.logging = false; this.extraA = true; this.extraB = false;
}

this.reset = function()
{
	// This is necessary because the music handling is different in v1.71.2
	if (oolite.compareVersion("1.71.2") < 0) { delete this.shipWillDockWithStation; }
	else { delete this.shipDockedWithStation; }
	// Get the completed list - possibly expanded by musicpacks
	this.hyperradio_stationlist = hyperradio_stationlist;
	this.hyperradio_stations = this.hyperradio_stationlist.length;
	this.hyperradio_limit = 0;
	let hyperradio_counterlimit = this.hyperradio_stations;
	while (hyperradio_counterlimit >= 1) { hyperradio_counterlimit/= 2; this.hyperradio_limit++; }
	this.hyperradio_limit = Math.pow(2,this.hyperradio_limit)-1;
	if (this.logging) { log('Hyperradio','Hyperradio: Stations found:'+this.hyperradio_stations+' Limit:'+this.hyperradio_limit); }
	this.hyperradio = false; this.hyperradio_canplay = false;
}

this.shipDockedWithStation = function()
{
	if (this.hyperradio_current) Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_canplay = false; this.CheckHyperradioLicence();
}

this.shipWillDockWithStation = function()
{
	if (this.hyperradio_current) Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_canplay = false; this.CheckHyperradioLicence();
}

this.shipWillLaunchFromStation = function()
{
	if (this.extraB) { this.hyperradio_stationlist.sort(function() { return 0.5-Math.random(); } ); this.extraB = false; }
	if (player.hasEquipment("EQ_HYPER_RADIO")) { this.hyperradio = true;
		if (this.hyperradio_stations > 1) { this.SelectHyperradioStation(); }
		else { this.hyperradio_stationselect = 0; } }
}

this.shipLaunchedFromStation = function()
{
	if (this.hyperradio && !system.isInterstellarSpace) {
		this.hyperradio_current = 'start'; this.hyperradio_next = 'start';
		if (!missionVariables.hyperradio_last) { missionVariables.hyperradio_last = String(Math.floor(20 + (clock.days))); }
		this.hyperradio_canplay = true; }
}

this.shipExitedWitchspace = function()
{
	if (this.hyperradio) {
		if (system.isInterstellarSpace) {
			if (this.hyperradio_current != 'start') { Sound.stopMusic(this.hyperradio_current); }
			player.commsMessage('Hyperradio deactivated. Could not transfer data.', 8); this.hyperradio_canplay = false; return; }
		else if (this.hyperradio_stations > 1) { this.SelectHyperradioStation(); }
			else { this.hyperradio_stationselect = 0; }
			this.hyperradio_canplay = true; }
}

this.alertConditionChanged = function()
{
    if (player.alertCondition == 3 && this.hyperradio) { Sound.stopMusic(this.hyperradio_current); }
    if (player.alertCondition < 3 && player.alertCondition != 0 && this.hyperradio && !system.isInterstellarSpace) { this.hyperradio_canplay = true; }
}

this.shipLaunchedEscapePod = function()
{
	if (this.extraA) { Sound.stopMusic(this.hyperradio_current); Sound.playMusic('hyperradio-escapepod.ogg'); }
}

this.SelectHyperradioStation = function()
{
	this.hyperradio_stationselect = system.ID&this.hyperradio_limit;
		if (this.logging) { log('Hyperradio','Hyperradio: SELECTEDA:'+this.hyperradio_stationselect+' in System:'+system.ID); }
	if (this.hyperradio_stationselect == 0 && Math.random() > 0.5) {
		this.hyperradio_stationselect += Math.floor(Math.random()*(this.hyperradio_stations-1))+1;
		if (this.hyperradio_stationselect > (this.hyperradio_stations-1)) { this.hyperradio_stationselect = this.hyperradio_stations-1; }
		if (this.logging) { log('Hyperradio','Hyperradio: SELECTEDB:'+this.hyperradio_stationselect); } }
	if (this.hyperradio_stationselect > (this.hyperradio_stations-1)) {
		this.hyperradio_stationselect -= Math.ceil(Math.random()*(this.hyperradio_stations-1))+1;
		this.hyperradio_stationselect = Math.min((this.hyperradio_stations-1),this.hyperradio_stationselect);
		if (this.logging) { log('Hyperradio','Hyperradio: SELECTEDC:'+this.hyperradio_stationselect); } }
	return;
}

this.GetHyperradioSongName = function()
{
	let listname = this.hyperradio_stationlist[this.hyperradio_stationselect];
	let Listofsongs = [expandDescription(listname), expandDescription(listname), expandDescription(listname), expandDescription(listname), expandDescription(listname)];
	if (Listofsongs[0] == "" || !Listofsongs[0] || !Listofsongs[0].match('.ogg')) {
		player.consoleMessage('Hyperradio: NO VALID ENTRY FOUND! See Logfile for Details.',8);
		log('Hyperradio','Hyperradio: WARNING. NO VALID ENTRY IN DESCRIPTIONS.PLIST FOUND. Error in:'+Listofsongs[0]+' '+listname+' Station:'+this.hyperradio_stationselect);
		return('malfunction'); } 
	if (Listofsongs[0] == Listofsongs[1] && Listofsongs[0] == Listofsongs[2] && Listofsongs[0] == Listofsongs[3]) { this.hyperradio_next = Listofsongs[0]; return('ok'); }
	let songselect = 4;
	while (this.hyperradio_current == this.hyperradio_next) { songselect = Math.min(Math.floor(Math.random()*5),4); this.hyperradio_next = Listofsongs[songselect]; }
	return('ok');
}

this.CheckHyperradioLicence = function()
{
	if (clock.days >= parseInt(missionVariables.hyperradio_last)) {
		player.removeEquipment("EQ_HYPER_RADIO");
		this.hyperradio = false; missionVariables.hyperradio_last = null; this.hyperradio_canplay = false;
		player.consoleMessage('Your HyperRadio licence is expired. Buy a new one at your local dealer.', 6);
		return('expired'); }
	return('ok');
}

this.guiScreenChanged = function(to)
{
	if (player.status == "STATUS_IN_FLIGHT" && to == "GUI_SCREEN_SYSTEM_DATA") {
			if (this.hyperradio && this.CheckHyperradioLicence() == 'ok' && this.hyperradio_canplay) {
				Sound.stopMusic(this.hyperradio_current);
				if (this.GetHyperradioSongName() == 'malfunction' || this.hyperradio_next == this.hyperradio_stationlist[this.hyperradio_stationselect]) { this.hyperradio_canplay = false; return; }
				else { this.hyperradio_current = this.hyperradio_next;
					player.consoleMessage('Connection established.');
					Sound.playMusic(this.hyperradio_current); } } }
}
