this.name      = "buoyRepairShip"; 
this.author    = "eric walch"; 
this.copyright = " 2008 the Oolite team.";
this.description = "ship for repairing Witchpoint & Station Buoy";
this.version   = "1.01";

this.shipSpawned = function()
{
    let list = ["NL", "DG", "RF", "PH", "TZ"]
    if(this.ship.shipDisplayName == this.ship.shipDescription)  //sometimes the nameswitch happened before shipSpawned() was called.
    this.ship.shipDisplayName = this.ship.shipDisplayName + " " + list[Math.floor(Math.random() * list.length)] + Math.ceil(Math.random()*127)
    if(this.ship.subEntities && this.ship.subEntities.length > 2)
    {
        if(worldScripts.buoyRepair.testing) log("buoyRepair", "Adding " + this.ship.shipDisplayName +" with role " + this.ship.primaryRole + " and towing a " + this.ship.subEntities[2].shipDescription)
        // if(this.ship.primaryRole == "repairBuoyTuggerW") this.ship.subEntities[2].call("switchLightsOff") // replace Call by function!!!
        if(this.ship.primaryRole == "repairBuoyTuggerN")
        {
            worldScripts.buoyRepair.NLaunchQueueAdded = false // flag main script NBuoyTugger ship launched
            if(system.shipsWithPrimaryRole("repairBuoyTuggerN").length > 1 || system.shipsWithRole("buoy", system.mainStation, 20000).length > 0)
            {
                this.ship.AIState = "GO_TO_STATION"; // repair a bug with double launches by sending duplicates back home.
                this.ship.primaryRole = "repairBuoyTuggerE"; // we don't want duplicates with this role.
                return;
            }
        }
    }
    else
    {
        if(this.ship.primaryRole == "defense_ship" && !this.ship.target) this.ship.setAI("dockingAI.plist")
        if(worldScripts.buoyRepair.testing) log("buoyRepair", "Adding " + this.ship.shipDisplayName +" with role " + this.ship.primaryRole + " and towing nothing.")
    }
    delete this.shipSpawned;
}

this.shipDied = function(whom, why)
{
    if(worldScripts.buoyRepair.testing) log("buoyRepair", this.ship.shipDisplayName + " was killed by a " + (whom?(whom.shipDisplayName?whom.shipDisplayName:whom):"[undefined]") + ", because of " + why)
    if(this.ship.subEntities && this.ship.subEntities.length > 2) // ship still has all his subentities.
    {
        if(worldScripts.buoyRepair.testing) log("buoyRepair", "Ship was towing a: " + this.ship.subEntities[2].shipDescription)
        if(this.ship.primaryRole == "repairBuoyTuggerG")
        {
            if(worldScripts.buoyRepair.testing) log("buoyRepair", "ship towing a G-beacon died");
            this.addBuoy("GRS-factory-buoy")
        }
        if(this.ship.primaryRole == "repairBuoyTuggerN")
        {
            if(worldScripts.buoyRepair.testing) log("buoyRepair", "ship towing a N-beacon died");
            this.addBuoy("repaired-GRS-buoy")
            system.legacy_addShips("repairBuoyTuggerE", 1); // add a replacement at the witchpoint for ballance
        }
        if(this.ship.primaryRole == "repairBuoyTuggerW")
        {
            if(worldScripts.buoyRepair.testing) log("buoyRepair", "ship towing a W-beacon died"); 
            this.addBuoy("repaired-GRS-buoy-witchpoint")
        }
    }
    else
    {
        if(this.ship.primaryRole == "repairBuoyTuggerG") 
        {
        this.ship.switchAI("buoyRepairShipGAI.plist") // a dead ship with ejected pilot has a nullAI.plist
        this.ship.reactToAIMessage("GRS_G-BUOY_DIED")
        }
    }
}

this.shipDockedWithStation= function(station)
{
    if(worldScripts.buoyRepair.testing) log("buoyRepair", this.ship.shipDisplayName + " docked at " + station.shipDescription + " with a energy level of " + Math.round(this.ship.energy) + " out of " + this.ship.maxEnergy); 
}

this.addBuoy = function(buoyRole)
{
    system.legacy_addSystemShips(buoyRole, 1, 20)
    let buoy = system.shipsWithPrimaryRole(buoyRole)[0];
    buoy.AIState = "LIGHTS_OFF"
    buoy.setOrientation(this.ship.orientation)
    buoy.setPosition(this.ship.position.subtract(this.ship.heading.multiply(115))) // value from subentity Z-distance
}

this.switch = function(buoyName, buoyRole, newAIState)
{
    let subentities = this.ship.subEntities
    for (let i=0; i<subentities.length; i++)
    {
        if(subentities[i].shipDescription == buoyName) // Only release beacon if still present.
        {
            system.legacy_addSystemShips("switchedRepairBuoyTugger", 1, 20) // add replacement ship to system.
            let oldShip = this.ship;
            let newShip = system.shipsWithPrimaryRole("switchedRepairBuoyTugger")[0];
            system.legacy_addSystemShips(buoyRole, 1, 20)
            let buoy = system.shipsWithPrimaryRole(buoyRole)[0];
            buoy.AIState = "LIGHTS_OFF"
            let target = player.target
            let oldOrientation = oldShip.orientation
            let oldPosition = oldShip.position
            let oldVector = oldShip.heading //vector with lenght 1 meter
            newShip.shipDisplayName = oldShip.shipDisplayName
            oldShip.setPosition(oldShip.position.multiply(100))
            newShip.setOrientation(oldOrientation)
            buoy.setOrientation(oldOrientation)
            newShip.setPosition(oldPosition)
            buoy.setPosition(oldPosition.subtract(oldVector.multiply(115)))
            if(target == oldShip) player.target = newShip.ID
            newShip.primaryRole = "repairBuoyTugger" // in case there are more switchings going on.
            newShip.AIState = newAIState
            oldShip.AIState = "DISAPPEAR"
            if(worldScripts.buoyRepair.testing) log("buoyRepair", "Replaced: " + buoyRole)
        }
    }
}

this.releaseBuoyW = function()
{
    this.switch("Navigation Buoy", "repaired-GRS-buoy-witchpoint", "MOVE_OUT")
}

this.releaseBuoyG = function()
{
        this.switch("Navigation Buoy", "GRS-factory-buoy", "GO_TO_STATION")
        if(this.ship.subEntities.length < 3) this.ship.reactToAIMessage("GRS_G-BUOY_DIED")
}

this.releaseBuoyN = function()
{
    if(Math.random() < 0.7) this.switch("Navigation Buoy", "repaired-GRS-buoy", "DOCK_AT_MAIN_STATION")
    else 
    {
        this.switch("Navigation Buoy", "repaired-GRS-buoy", "MOVE_OUT")
        system.legacy_addShips("repairBuoyTuggerE", 1)
    }
}

this.findGRSStation = function()
{
    this.ship.target = worldScripts.buoyRepair.grsStation.ID
}


this.hyperspaceHelp = function()
{
  if(this.ship.distanceTravelled > 9000) this.ship.AIState = "GO_WITCHPOINT";
}