"use strict";
this.name = "Goods Container 10 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "2.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	// keep tally of pylon accessories bought
	this.$gc1Count++;
    // and don't let them exceed ship's pylon-capacity
	if ((equipment == "EQ_GC1_MINE") && (this.$gc1Count<=this.$gc1MCap)) {
		player.ship.cargoSpaceCapacity += 10;
		this.$gc1Containers++;
		pc("Modifying pylon hardpoints for container clamping...",9);
		pc("Fitting 10 TC Class Container #"+this.$gc1Containers+"...",9);
		pc("F4 'Your FE Shipyards' to check your Licence.",9);
	} else
	// unmount & sell cancels all container additions
	if (equipment == "EQ_MISSILE_REMOVAL") {
		player.ship.cargoSpaceCapacity -= this.$gc1Containers*10;
		pc("Removing all 10 TC Class Containers...",9)
		pc("Restoring pylon hardpoints for weapons-use...",9);
		if ((this.$gc1Containers>0) && (!this.$gc1HFExempt)) {
			// dismantling fee
			var dft = this.$gc1Containers*this.$gc1DismantlingFee;
			this.$gc1DismantlingFeeTotal += dft;
			player.credits -= dft;
			pc("Dismantling Fee: "+dft+" cr",9);
		}
		this.$gc1Count = 0;
		this.$gc1Containers = 0;
		// reset system-to-system runs w/containers
		this.$gc1Runs = 0;
		// reset fee totals
		this.$gc1HandlingFeeTotal = 0;
		this.$gc1MaintenanceFeeTotal = 0;
	}
}


this.playerBoughtNewShip = function(ship, price) {
	// missile capacity (not exceed)
	this.$gc1MCap = player.ship.missileCapacity;
	this.$gc1Count = 0;
	this.$gc1Containers = 0;
}


this.equipmentRemoved = function(equipmentKey) {
    if (equipmentKey == "EQ_GC1_MINE") {
		player.ship.cargoSpaceCapacity -= 10;
		this.$gc1Containers--;	
		player.consoleMessage("10 TC Goods Container removed.",5);
	}
}


this.shipReleasedEquipment = function(mine) {
	this.$gc1Count--;
    if (mine == "EQ_GC1_MINE") {
		player.ship.cargoSpaceCapacity -= 10;
		this.$gc1Containers--;
		player.commsMessage("10 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 10000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.shipFiredMissile = function(missile, target) {
	this.$gc1Count--;
    if (missile == "EQ_GC1_MINE") {
		player.ship.cargoSpaceCapacity -= 10;
		this.$gc1Containers--;	
		player.commsMessage("10 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 10000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	// missile capacity (not exceed)
	this.$gc1MCap = player.ship.missileCapacity;
	this.$gc1Count = player.ship.missiles.length;
	// Load cargo space, missile & container counts if present
	if (missionVariables.gc1Cargo != null) 
		player.ship.cargoSpaceCapacity = missionVariables.gc1Cargo;
	if (missionVariables.gc1Count != null)
		this.$gc1Count = missionVariables.gc1Count;
	if (missionVariables.gc1Containers != null) 
		this.$gc1Containers = missionVariables.gc1Containers;
	// Load total fees taken
	if (missionVariables.gc1HandlingFeeTotal != null)
		this.$gc1HandlingFeeTotal = missionVariables.gc1HandlingFeeTotal;
	if (missionVariables.gc1HandlingPaid != null)
		this.$gc1HandlingPaid = missionVariables.gc1HandlingPaid;
	if (missionVariables.gc1MaintenanceFeeTotal != null)
		this.$gc1MaintenanceFeeTotal = missionVariables.gc1MaintenanceFeeTotal;
	if (missionVariables.gc1DismantlingFeeTotal != null)
		this.$gc1DismantlingFeeTotal = missionVariables.gc1DismantlingFeeTotal; 
    // Load system-to-system runs w/container
	if (missionVariables.gc1Runs != null)
		this.$gc1Runs = missionVariables.gc1Runs;
	// Load Handling fee count
	if (missionVariables.gc1HandlingCount != null)
		this.$gc1HandlingCount = missionVariables.gc1HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.gc1HFExempt != null)
		this.$gc1HFExempt = missionVariables.gc1HFExempt;
	// Load Maintenance fee count
	if (missionVariables.gc1MaintenanceCount != null)
		this.$gc1MaintenanceCount = missionVariables.gc1MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// TEST
	var sta = player.ship.dockedStation;
	if ((this.$gc1Containers<this.$gc1MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	// prepare container Account screen
	this._gc1PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$gc1Containers>0) this._gc1PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$gc1ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$gc1ET = true;
	// TEST	
	if (this.$gc1ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$gc1FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$gc1FES = true;
	// TEST	
	if (this.$gc1ET) log(this.name, "Finds FE Ships Player present");
	// missile capacity (not exceed)
	this.$gc1MCap = 0;
	// pylon-use count
	this.$gc1Count = 0;
	// container count
	this.$gc1Containers = 0;
	// purchase cost of container in cr
	this.$gc1Cost = 10000;
	// handling fee
	this.$gc1HandlingFee = 0.005*this.$gc1Cost; // 0.005 of cost
	this.$gc1HandlingFeeTotal = 0;
	this.$gc1HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$gc1HandlingCount = 0;
	this.$gc1HFExempt = "no";
	// maintenance fee
	this.$gc1MaintenanceFee = 0.05*this.$gc1Cost; // 0.05 of cost
	this.$gc1MaintenanceFeeTotal = 0;
	this.$gc1MaintenancePaid = "no" // or "yes"
	this.$gc1MaintenanceInterval = 10; // in runs (according to cost)
	this.$gc1MaintenanceCount = 0;
	// dismantling fee
	this.$gc1DismantlingFee = 0.1*this.$gc1Cost; // 0.1 of cost
	this.$gc1DismantlingFeeTotal = 0.0;
	// system-to-system runs w/container
	this.$gc1Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.gc1Count = this.$gc1Count;
	missionVariables.gc1Cargo = player.ship.cargoSpaceCapacity;
	missionVariables.gc1Containers = this.$gc1Containers;
	// save total fees taken
	missionVariables.gc1HandlingFeeTotal = this.$gc1HandlingFeeTotal;
	missionVariables.gc1MaintenanceFeeTotal = this.$gc1MaintenanceFeeTotal;
	missionVariables.gc1DismantlingFeeTotal = this.$gc1DismantlingFeeTotal;
	missionVariables.gc1HandlingPaid = this.$gc1HandlingPaid;
	// system-to-system runs w/container
	missionVariables.gc1Runs =this.$gc1Runs;
	// handling fee count
	missionVariables.gc1HandlingCount = this.$gc1HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.gc1HFExempt = this.$gc1HFExempt;
	// maintenance fee count
	missionVariables.gc1MaintenanceCount = this.$gc1MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$gc1HFExempt;
	// check we have containers, the fee is not paid, and we're not exempt
	if ((this.$gc1Containers>0) && (this.$gc1HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$gc1Containers; x++)
			fee += this.$gc1HandlingFee;
		// record fee and debit trader's account
		this.$gc1HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$gc1HandlingPaid = "yes";
		pc("10 TC Container handling fees: "+fee+" cr",9);
		this.$gc1HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$gc1Containers>0) this._gc1DoMaintenance();

	// TEST
	if ((this.$gc1Containers<this.$gc1MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	
	// prepare container Account and Licence page
	this._gc1PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$gc1Containers>0) this._gc1PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$gc1HandlingPaid = "no";
	this.$gc1Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._gc1DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$gc1Runs;
	var intv = this.$gc1MaintenanceInterval;
	var mfee = this.$gc1MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x containers
		var fee = 0;
		for (var x=1; x<= this.$gc1Containers; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$gc1MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("10 TC Container Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$gc1MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._gc1PrepAcc = function(station) {
	station.setInterface("gc1Acc",{
	title: "Your FE Shipyards 10 TC Container Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 10 TC Goods Container account screen shows terms, fees paid, load, and other useful information.",
	callback: this._gc1ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._gc1ShowAcc = function() {
	var hfc = this.$gc1HandlingCount;
	var mfc = this.$gc1MaintenanceCount;
	var mfi = this.$gc1MaintenanceInterval;
	var hft = this.$gc1HandlingFeeTotal;
	var mft = this.$gc1MaintenanceFeeTotal;
	var dft = this.$gc1DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$gc1Containers>0) 
		parameters.message +="Your Account and Licence for 10 TC Class Goods Containers x "+this.$gc1Containers+": \n\n"; 
	 else
		parameters.message +="You have no 10 TC Class Containers licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our containers are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Container account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylons for weapons-use. \n";
	
	parameters.choicesKey = "gc1Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._gc1PrepEx = function(station) {
	station.setInterface("gc1Ex",{
	title: "Your FE Shipyards Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 10-ton container class." ,
	callback: this._gc1ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._gc1ShowEx = function() {
	var priv = ((this.$gc1ET)||(this.$gc1FES));
	var privo = "";
	if (this.$gc1FES) privo="FE shipowner";
	if (this.$gc1ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 10 TC container fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "gc1YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$gc1HFExempt = "yes"; else this.$gc1HFExempt = "no";
		} else this.$gc1HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}



