//Copyright Paul Cooper 2023 Version 0.8.0



var speciesFunc = function(value) {
	
	if (typeof value === "object") value = value[4].species;
	
	let baseSpecies = value.split(" ").pop();
	let idx = lookupArrays.Species.map(e => e.split(" ").pop()).indexOf(baseSpecies);
	return {
		aFrontColor: ["#7F3F00", "#007F00", "#7FFF7F", "#FF0000", "#3F3FFF", "#7F7F7F", "#7F0FFF", "#FF7F3F", "#FFFFF0"][idx],
		aSystemShape: "Circle",
		aSystemSize: 1
	};
	
}

var governmentFunc = function(value) {
	
	if (typeof value === "object") value = value[4].government;
	
	let idx = lookupArrays.Governments.indexOf(value);
	return {
		aFrontColor: ["#FFA500", "#B8860B", "#6495ED", "#A9A9A9", "#FF0000", "#FFD700", "#00FA9A", "#3d3aff"][idx],
		aSystemShape: "Circle",
		aSystemSize: 1
	};
	
}

var economyFunc = function(value) {
	
	if (typeof value === "object") value = value[4].economy;
	
	let idx = lookupArrays.Economies.indexOf(value);
	return {
		aFrontColor: ["#808080", "#AAAAAA", "#D3D3D3", "#4682B4", "#48D1CC", "#228B22", "#32CD32", "#ADFF2F"][idx],
		aSystemShape: "Circle",
		aSystemSize: 1
	};
	
}

var techFunc = function(value) {
	
	if (typeof value === "object") value = value[4].techlevel;
	
	return {
		//colour: ["#BF0909", "#BC094B", "#BA0976", "#BA0999", "#A609B7", "#7509B5", "#4308AF", "#0837AD", "#0856AF", "#0879B2", "#0998B5", "#09B7B4", "#09BA93", "#09BC57", "#09BF24"][value-1],
		aFrontColor: ["#BF0909", "#BF0909", "#BF0909", "#7509B5", "#7509B5", "#7509B5", "#0856AF", "#0856AF", "#0856AF", "#09B7B4", "#09B7B4", "#09B7B4", "#09BF24", "#09BF24", "#09BF24"][value-1],
		aSystemShape: ["Triangle", "Square", "Circle"][(value-1) % 3],
		aSystemSize: Math.sqrt((value-1)/14)
	}

}

var productivityFunc = function(value) {
	
	if (typeof value === "object") value = value[4].productivity;
	
	let index = Math.floor(value / 5000);
	let index2 = index;
	
	index = [0, 1, 2, 3, 4, 4, 5, 5, 6, 6, 7, 7][index];
	
	if (index === undefined) index = 7;
	
	index2 = [0, 1, 2, 3, 4, 4, 5, 5, 6, 6, 7, 7][index2];
	
	if (index2 === undefined) index2 = 7;
	
	return {
		aFrontColor: ["#ff271c", "#ff8165", "#ffc2b0", "#ffffff", "#ddffd4", "#b6ffa8", "#88ff7b", "#40ff46"][index],
		aSystemShape: "Circle",
		aLabelRange: ["0-5K Mcr", "5-10K Mcr", "10-15K Mcr", "15-20K Mcr", "20-30K Mcr", "30-40K Mcr", "40-50K Mcr", "50K+ Mcr"][index],
		aLabelContinuous: ["5K Mcr", "10K Mcr", "15K Mcr", "20K Mcr", "30K Mcr", "40K Mcr", "50K Mcr", "60K Mcr"][index2],
		aSystemSize: Math.sqrt(value/62480)
	}
	
}

var populationFunc = function(value) {
	
	if (typeof value === "object") value = value[4].population;
	
	let index = Math.floor(value);
	let index2 = index;
	
	index = [0, 1, 2, 3, 4, 5, 6][index];
	
	if (index === undefined) index = 6;
	
	index2 = [0, 1, 2, 3, 4, 5, 6, 7][index2];
	
	if (index2 === undefined) index2 = 7;
	
	return {
		aFrontColor: ["#d7ffce", "#f3f5c4", "#ffdda2", "#ff9e63", "#ff5986", "#ff0bbf", "#cf54ff"][index],
		aSystemShape: "Circle",
		aLabelRange: ["<1 Billion", "1-2 Billion", "2-3 Billion", "3-4 Billion", "4-5 Billion", "5-6 Billion", "6+ Billion"][index],
		aLabelContinuous: ["0.1 Billion", "1 Billion", "2 Billion", "3 Billion", "4 Billion", "5 Billion", "6 Billion", "7 Billion"][index2],
		aSystemSize: Math.sqrt(value/7.1)
	}
	
}

var radiusFunc = function(value) {
	
	if (typeof value === "object") value = value[4].radius;
	
	let index = Math.floor(value / 1000) - 2;
	let index2 = index;
	
	index = [0, 1, 2, 3, 4][index];
	
	if (index === undefined) index = 4;
	
	index2 = [0, 1, 2, 3, 4, 5][index2];
	
	if (index2 === undefined) index2 = 5;
	
	return {
		aFrontColor: ["#699679", "#02cf80", "#00bdff", "#007bd4", "#b16bff"][index], //#702d8a
		aSystemShape: "Circle",
		aLabelRange: ["2-3K Km", "3-4K Km", "4-5K Km", "5-6K Km", "6K+ Km"][index],
		aLabelContinuous: ["2000 Km", "3000 Km", "4000 Km", "5000 Km", "6000 Km", "7000 Km"][index2],
		aSystemSize: (value/6911)
	}

}


function SystemIcon(aParentScene, aSize, aMaxSize, styling)
{ 
	this.Parent=aParentScene;
	this.ClassName="SystemIcon";
	this.ObjectType="SystemIcon";
	this.Center=new Vector(0,0,0);
	this.stylingType= styling.aOptions;
	this.FrontColor=styling.aFrontColor;
	this.FrontColor2=styling.aFrontColor2 || null;
	this.StrokeColor=styling.aStrokeColor;
	this.StrokeWeight=styling.aStrokeWeight;
	this.SystemShape=styling.aSystemShape;
	this.SystemSize=styling.aSystemSize;
	this.Zoom=_Object3DZoom;
	this.Shift=_Object3DShift;
	this.SetFrontColor=_Object3DSetFrontColor;
	this.SetBackColor=_Object3DSetBackColor;
	this.SetStrokeColor=_Object3DSetStrokeColor;
	this.SetStrokeWeight=_Object3DSetStrokeWeight;
	this.SetVisibility=_Object3DSetVisibility;
	this.SetId=_Object3DSetId;
	this.SetEventAction=_Object3DSetEventAction;
	this.Poly3D=new Array();
	this.Poly3D[0]=new Poly3D(aParentScene, styling.aFrontColor, null, styling.aStrokeColor, styling.aStrokeWeight, SystemSVG);
	with (this.Poly3D[0])
	{ AddPoint(0,0,0); Update(); }
	this.Poly3D[0].Size=aSize;
	this.Poly3D[0].MaxSize=aMaxSize;
	this.Poly3D[0].ParentObject=this;
	this.SetOrderWeight=_Object3DSetOrderWeight;
}

function makeShape(doc, shape, size, x, y, fill, stroke, strokewidth, attenuation) {
	switch (shape) {
		case "Circle":
			return makeCircle(doc, size, x, y, fill, stroke, strokewidth, attenuation);
		case "Triangle":
			return makeTriangle(doc, size, x, y, fill, stroke, strokewidth, attenuation);
		case "Square":
			return makeSquare(doc, size, x, y, fill, stroke, strokewidth, attenuation);
	}
}

function makeCircle(doc, size, x, y, fill, stroke, strokewidth, attenuation) {
	var cir = doc.createElementNS("http://www.w3.org/2000/svg","circle");
	cir.setAttribute("cx", x);
	cir.setAttribute("cy", y);
	cir.setAttribute("r", size);
	cir.setAttribute("fill", AttenuateColour(fill, attenuation));
	cir.setAttribute("stroke", AttenuateColour(stroke, attenuation));
	cir.setAttribute("stroke-width", strokewidth);
	return cir;
}

function makeTriangle(doc, size, x, y, fill, stroke, strokewidth, attenuation) {
	var trig = doc.createElementNS("http://www.w3.org/2000/svg","polygon");
	let scale = Math.sqrt(2 * Math.PI / 3 / Math.sqrt(3));
	trig.setAttribute("points", "" + 0 + ", " + (-scale * size) + " " + (Math.sqrt(3) / 2 * scale * size) + ", " + (scale * size / 2) + " " + (-Math.sqrt(3) / 2 * scale * size) + ", " + (scale * size / 2) ); 
	trig.setAttribute("fill", AttenuateColour(fill, attenuation));
	trig.setAttribute("stroke", AttenuateColour(stroke, attenuation));
	trig.setAttribute("stroke-width", strokewidth);
	return trig;
}

function makeSquare(doc, size, x, y, fill, stroke, strokewidth, attenuation) {
	var square = doc.createElementNS("http://www.w3.org/2000/svg","polygon");
	let scale = Math.sqrt(Math.PI) / 2;
	square.setAttribute("points", "" + (-scale * size) + ", " + (scale * size) + " " + (scale * size) + ", " + (scale * size) + " " + (scale * size) + ", " + (-scale * size) + " " + (-scale * size) + ", " + (-scale * size) ); 
	square.setAttribute("fill", AttenuateColour(fill, attenuation));
	square.setAttribute("stroke", AttenuateColour(stroke, attenuation));
	square.setAttribute("stroke-width", strokewidth);
	return square;
}

function content(doc, con, styling, size, offsetType) {
	let sizeModifier = 1;
	let dimensions;
	if (styling.stylingType.sizeStyle && styling.stylingType.sizeStyle !== "None") {
		sizeModifier = styling.SystemSize + 0.5;
	}
	if (styling.FrontColor2) {
		let cir = makeShape(doc, styling.SystemShape, size * 1.33 * sizeModifier, 0, 0, styling.FrontColor2, styling.StrokeColor, styling.StrokeWeight, styling.attenuation);
		con.appendChild(cir);
		cir = makeShape(doc, styling.SystemShape, size * 0.83 * sizeModifier, 0, 0, styling.FrontColor, styling.StrokeColor, styling.StrokeWeight, styling.attenuation);
		con.appendChild(cir);
		dimensions = {width: size * 1.33 * 2 * sizeModifier, height: size * 1.33 * 2 * sizeModifier};
	}
	else {
		let cir;
		if (styles.circleStyle === "None" && offsetType === "none") {
			cir = makeShape(doc, styling.SystemShape, size * sizeModifier, 0, 0, styling.FrontColor, styling.StrokeColor, styling.StrokeWeight, styling.attenuation);
		}
		else if (offsetType === "key") {
			cir = makeShape(doc, styling.SystemShape, size * sizeModifier, 0, 0, styling.FrontColor, styling.StrokeColor, 0, styling.attenuation);
		}
		else {
			cir = makeShape(doc, styling.SystemShape, size  *1.33 * sizeModifier, 0, 0, styling.FrontColor, styling.StrokeColor, 0, styling.attenuation);
		}
		con.appendChild(cir);
		dimensions = {width: size * 2 * sizeModifier, height: size * 2 * sizeModifier};
	}
	return dimensions;
}

function createSymbol(doc, className, size, styling, offsetType) {

	let con = doc.createElementNS("http://www.w3.org/2000/svg","g");
	con.setAttribute("class", className);
	dimensions = content(doc, con, styling, size, offsetType);
	if (offsetType === "key") {
		con.setAttribute("transform", "translate(" + (dimensions.width/2) + "," + (dimensions.width/2) + ")");
	}
	if (offsetType === "key") con.setAttribute("viewbox", "0 0 " + dimensions.width + " " + dimensions.width);
	return con;
	
}

function updateSymbol(doc, con, styling, size, offsetType) {
	con.replaceChildren();
	content(doc, con, styling, size, offsetType);
}


function SystemSVG(aShape, aPoly)
{
	//<circle cx="100" cy="50" r="40" stroke="black" stroke-width="2" fill="red"/>
	
	var svg = this.Parent.Parent.GetSVGDoc(); 
	
	
	
	aShape.setAttribute("visibility", aPoly.Visibility);
	var Pos = aPoly.Parent.ScreenPos(aPoly.Center);
	var Scale = aPoly.Parent.ScreenScale(aPoly.Center);
	var Size = aPoly.Size;
	
	if (Scale*Size > aPoly.MaxSize) Scale = aPoly.MaxSize / Size; //Size = aPoly.MaxSize;
	
	var attenuation = CalculateAttenuation(aPoly);
	var con;
	
	let styling = {
		stylingType: aPoly.ParentObject.stylingType,
		FrontColor: aPoly.FrontColor,
		FrontColor2: aPoly.ParentObject.FrontColor2,
		StrokeColor: aPoly.StrokeColor,
		StrokeWeight: aPoly.StrokeWeight,
		attenuation: attenuation,
		SystemShape: aPoly.ParentObject.SystemShape,
		SystemSize: aPoly.ParentObject.SystemSize
	}
	
	if (aShape.getAttribute("ObjectType") != aPoly.ParentObject.ObjectType)
	{
		while (aShape.childNodes.length >= 1)
		{
			aShape.removeChild(aShape.firstChild);       
		}
		
		con = createSymbol(svg, "system", Size, styling, "none");
		con.setAttribute("stylingType", stylesToString(aPoly.ParentObject.stylingType));

		aShape.appendChild(con);
		aShape.setAttribute("ObjectType", aPoly.ParentObject.ObjectType);
	}
	else {
		con = aShape.querySelector("g.system");
		if (con.getAttribute("stylingType") !== stylesToString(aPoly.ParentObject.stylingType)) {
			con.setAttribute("stylingType", stylesToString(aPoly.ParentObject.stylingType));
			updateSymbol(svg, con, styling, Size, "none");
		}
	}
	
	con.setAttribute("transform", "translate(" + Pos.x + "," + Pos.y + ") scale(" + Scale + ")");

}

function stylesToString(styles) {
	var keys = ["circleStyle", "ringStyle", "sizeStyle"];
	return keys.map(e => styles[e]).join("-");
}
