this.name      = "buoyRepairShip"; 
this.author    = "eric walch"; 
this.copyright = " 2008 the autors.";
this.description = "ship for repairing Witchpoint & Station Buoy";
this.version   = "1.02";

this.shipSpawned = function()
{
    if(this.ship.displayName == this.ship.name)  //sometimes the nameswitch happened before shipSpawned() was called.
    this.ship.displayName = worldScripts.buoyRepair.addShipnumber(this.ship.displayName)
    if(this.ship.subEntities && this.ship.subEntities.length > 2)
    {
        if(worldScripts.buoyRepair.logging) log("buoyRepair", "Adding " + this.ship.displayName +" with role " + this.ship.primaryRole + " and towing a " + this.ship.subEntities[2].name)
        // if(this.ship.primaryRole == "repairBuoyTuggerW") this.ship.subEntities[2].call("switchLightsOff") // replace Call by function!!!
        if(this.ship.primaryRole == "repairBuoyTuggerN")
        {
            worldScripts.buoyRepair.NLaunchQueueAdded = false // flag main script NBuoyTugger ship launched
            if(system.shipsWithPrimaryRole("repairBuoyTuggerN").length > 1 || system.shipsWithRole("buoy", system.mainStation, 15000).length > 0)
            {
                this.ship.AIState = "GO_TO_STATION";
                this.ship.primaryRole = "repairBuoyTuggerE"; // we don't want duplicates with this role.
                return;
            }
        }
    }
    else
    {
        if(this.ship.primaryRole == "defense_ship") 
        {
            if(this.ship.target) this.ship.setAI("interceptAI.plist")
            else this.ship.setAI("dockingAI.plist")
        }
        if(worldScripts.buoyRepair.logging) log("buoyRepair", "Adding " + this.ship.displayName +" with role " + this.ship.primaryRole + " and towing nothing.")
    }
    if(this.playerTarget) player.ship.target = this.ship
    delete this.shipSpawned;
}

this.shipDied = function(whom, why)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " was killed by a " + (whom?(whom.displayName?whom.displayName:whom):"[undefined]") + ", because of " + why)
    if(this.ship.subEntities && this.ship.subEntities.length > 2) // ship still has all his subentities.
    {
        if(worldScripts.buoyRepair.logging) log("buoyRepair", "Ship was towing a: " + this.ship.subEntities[2].name)
        if(this.ship.primaryRole == "repairBuoyTuggerG")
        {
            if(worldScripts.buoyRepair.logging) log("buoyRepair", "ship towing a G-beacon died");
            this.addBuoy("GRS-factory-buoy")
        }
        if(this.ship.primaryRole == "repairBuoyTuggerN")
        {
            if(worldScripts.buoyRepair.logging) log("buoyRepair", "ship towing a N-beacon died");
            this.addBuoy("repaired-GRS-buoy")
            system.legacy_addShips("repairBuoyTuggerE", 1); // add a replacement at the witchpoint for ballance
        }
        if(this.ship.primaryRole == "repairBuoyTuggerW")
        {
            if(worldScripts.buoyRepair.logging) log("buoyRepair", "ship towing a W-beacon died"); 
            this.addBuoy("repaired-GRS-buoy-witchpoint")
        }
    }
    else
    {
        if(this.ship.primaryRole == "repairBuoyTuggerG") 
        {
        this.ship.switchAI("buoyRepairShipGAI.plist") // a dead ship with ejected pilot has a nullAI.plist
        this.ship.reactToAIMessage("GRS_G-BUOY_DIED") // The dead ship's AI has to shedule a new launch.
        }
    }
    if(this.ship.primaryRole == "repairBuoyTugger") 
        {if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.tugger--}
    if(this.ship.primaryRole == "repairBuoyTuggerE")
        {if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.tuggerE--}
}

this.shipExitedWormhole = function()
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " entered wormhole"); 
    if(this.ship.primaryRole == "repairBuoyTuggerE")
        {if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.tuggerE--}
}

this.shipDockedWithStation= function(station)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " docked at " + station.name + " with a energy level of " + Math.round(this.ship.energy) + " out of " + this.ship.maxEnergy); 
    if(this.ship.primaryRole == "repairBuoyTugger") 
        {if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.tugger--}
}

this.addBuoy = function(buoyRole)
{
    var buoy = this.ship.spawnOne(buoyRole);
    buoy.AIState = "LIGHTS_OFF"
    buoy.setOrientation(this.ship.orientation)
    buoy.setPosition(this.ship.position.subtract(this.ship.heading.multiply(this.ship.subentities[2].position.z)))
}

this.releaseBuoyW = function()
{
    worldScripts.buoyRepair.switch(this.ship, "Navigation Buoy", "repaired-GRS-buoy-witchpoint", "MOVE_OUT")
}

this.releaseBuoyG = function()
{
        worldScripts.buoyRepair.switch(this.ship, "Navigation Buoy", "GRS-factory-buoy", "GO_TO_STATION")
        if(this.ship.subEntities.length < 3) this.ship.reactToAIMessage("GRS_G-BUOY_DIED")
}

this.releaseBuoyN = function()
{
    if(Math.random() < 0.7) worldScripts.buoyRepair.switch(this.ship, "Navigation Buoy", "repaired-GRS-buoy", "DOCK_AT_MAIN_STATION")
    else 
    {
        worldScripts.buoyRepair.switch(this.ship, "Navigation Buoy", "repaired-GRS-buoy", "MOVE_OUT")
        system.legacy_addShips("repairBuoyTuggerE", 1)
    }
}

this.findGRSStation = function()
{
    if(worldScripts.buoyRepair.grsStation) this.ship.target = worldScripts.buoyRepair.grsStation
    else this.ship.target = system.mainStation
}

this.hyperspaceHelp = function()
{
  if(this.ship.distanceTravelled > 9000) this.ship.AIState = "GO_WITCHPOINT";
}