this.name      = "buoyRepairDocker"; 
this.author    = "eric walch"; 
this.copyright = " 2008 eric walch.";
this.description = "Clamp Docking";
this.version   = "1.02";

this.shipSpawned = function()
{
    if(this.ship.displayName == this.ship.name)
            this.ship.displayName = worldScripts.buoyRepair.addShipnumber(this.ship.displayName)
    if(worldScripts.buoyRepair.grsStation) this.grsStation = worldScripts.buoyRepair.grsStation
    this.clamp = false
    this.goingReverse = false
    this.dockings = 0;
}

this.shipExitedWormhole = function()
{
    if(worldScripts.buoyRepair.grsStation) this.grsStation = worldScripts.buoyRepair.grsStation;
    else this.grsStation = false
    this.cleanup()
}

this.shipDied = function(whom, why)
{
    if(this.clamp)
    {
        if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " was killed by a " + (whom&&whom.isShip?whom.displayName:whom) + ", because of " + why+ (whom&&whom.isStation?" at clamp "+(this.clamp?this.clamp:"none."):""))
        this.dockEscorts()
    }
    this.resetClamp()
    this.cleanup()
    if(whom != this.grsStation && this.ship.isTrader) this.ship.spawn("cargopod", Math.ceil(Math.random()*15))
}

this.shipCollided = function(whom)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " collided with " + (whom.isShip?whom.displayName:whom)+", Remaining energy: "+ Math.round(this.ship.energy) +" out of "+this.ship.maxEnergy+ (whom.isStation?" At clamp "+(this.clamp?this.clamp:"none."):""))
}

this.shipDockedWithStation= function(station)
{
    this.cleanup()
}

this.cleanup = function()
{
    if(this.reverseShip) this.reverseShip.remove()
    if(this.marker && this.marker.isValid) this.marker.remove()
    if(worldScripts.buoyRepair.grsStation && this.ship.primaryRole == "buoy_repair_docker") worldScripts.buoyRepair.docker--
}

this.requestClamp = function()
{
    if(!this.grsStation) {this.ship.reactToAIMessage("GRS_NO_FREE_CLAMP"); return;}
    this.clamp = this.grsStation.script.requestFreeClamp();
    if(this.clamp==0)
    {
        this.clamp = false; 
        this.ship.reactToAIMessage("GRS_NO_FREE_CLAMP");
    }
    else
    {
        this.grsStation.script.clampOn(this.clamp)
        this.ship.reactToAIMessage("GRS_FREE_CLAMP");
    }
}

this.resetClamp = function()
{
    if(this.clamp) this.grsStation.script.clampOff(this.clamp)
    this.clamp = false
}

this.setApproachA = function()
{
    this.setApproach(7000)  // far away
}

this.setApproachB = function()
{
    this.setApproach(2300) // lining up point, 700m before the clamp.
}

this.setApproachC = function()
{
    this.setApproach(1500) // immediately before the clamp.
}

this.setApproachD = function()
{
    this.setApproach(this.ship.scriptInfo.GRS_dockinglength)  // endpoint for stopping. Can be different for each ship.
    this.grsStation.script.raiseLightning(this.clamp)
}

this.setApproachE = function()
{
    this.setApproach(7000)  // far away
    this.grsStation.script.lowerLightning(this.clamp)
}

this.setApproach = function(distance)
{
    var position = this.grsStation.position
    if(this.clamp == 2)
        position = position.subtract(this.grsStation.orientation.vectorRight().multiply(distance))
    else position = position.subtract(this.grsStation.orientation.vectorForward().multiply(distance))
    position = position.subtract(this.grsStation.orientation.vectorUp().multiply(40)) // a little bit lower.
    this.setMarker(position)
    this.ship.target = this.marker
}

this.resetApproach = function()
{
    if(this.clamp) 
    {
        this.marker.setPosition(this.marker.position.multiply(100+Math.random()))
    }
    else this.ship.reactToAIMessage("GRS_NO_FREE_CLAMP");
}

this.setMarker = function(pos)
{
    if(!this.marker || (this.marker && !this.marker.isValid))
    {
        this.marker = this.ship.spawnOne("buoy_repair_marker")
    }
    this.marker.setPosition(pos)
}

this.checkPlayerDistance = function()
{
    if(this.ship.position.distanceTo(player.ship) < 30E3)
        this.ship.reactToAIMessage("PLAYER_CLOSE");
    else 
    {
       this.ship.reactToAIMessage("PLAYER_FAR_AWAY"); 
    if(worldScripts.buoyRepair.logging) log("BuoyRepair", this.ship.displayName + " terminated clamp docking because player is to far away.")
    }
    /* Remark: when a ship is further away than Math.sqrt(1E9) (=31622.7766 meters) from the player, there is only a rough 
    collision detection and the ship will collide at the outher hull of the station at about 2040 meters from the station core.
    Oolite does not try anymore to detect local collision with any part of the clamps.
    */
}

this.findGRSStation = function()
{
    if(worldScripts.buoyRepair.grsStation) this.ship.target = this.grsStation
    else this.ship.reactToAIMessage("NO_GRS_STATION");
}

this.reverse = function()
{
    if(this.goingReverse) return;
    if(worldScripts.buoyRepair.logging) log("BuoyRepair", this.ship.displayName + " at clamp "+this.clamp+", docked succesful " + (++this.dockings) +" times.")
    if(!this.reverseShip || !this.reverseShip.isValid)
    {
        this.reverseShip = this.ship.spawnOne(this.ship.scriptInfo.GRS_reverseShip)
        this.reverseShip.displayName = this.ship.displayName
    }
    this.reverseShip.setPosition(this.ship.position)
    var orientation = this.ship.orientation;
    this.reverseShip.setOrientation(orientation.rotate(orientation.vectorUp(), Math.PI))
    this.ship.setPosition(this.ship.position.multiply(120+Math.random()))
    this.goingReverse = true
    this.reverseShip.AIState = "TAIL_FIRST"
}

this.forward = function()
{
    if(!this.goingReverse) return;
    if(!this.reverseShip || !this.reverseShip.isValid) {this.ship.remove(); return}
    this.reverseShip.AIState = "STOP"
    this.ship.setPosition(this.reverseShip.position)
    var orientation = this.reverseShip.orientation;
    this.ship.setOrientation(orientation.rotate(orientation.vectorUp(), Math.PI))
    this.reverseShip.setPosition(this.reverseShip.position.multiply(120+Math.random()))
    this.goingReverse = false
}

this.setupReverse = function()
{
    if(!this.reverseShip || (this.reverseShip && !this.reverseShip.isValid))
    {
        this.reverseShip = this.ship.spawnOne(this.ship.scriptInfo.GRS_reverseShip)
        this.reverseShip.displayName = this.ship.displayName
        this.reverseShip.setPosition(this.ship.position.multiply(120+Math.random()))
        this.reverseShip.AIState = "STOP"
    }
    if(this.reverseShip.subEntities.length > this.ship.subEntities.length) this.removeSubs()
}

this.removeSubs = function()
{
    var subPresent = false
    for(let i=0;i<this.reverseShip.subEntities.length;i++)
    {
        subPresent = false
        for(let j=0;j<this.ship.subEntities.length;j++)
        {
            var Org = this.ship.subEntities[j].position
            var Copy = this.reverseShip.subEntities[i].position
            if(Copy.x == -Org.x && Copy.y == Org.y && Copy.z == -Org.z) subPresent = true
            // Ships copy is rotated over the y-axis. x and z position are inverted!
        }
        if(!subPresent) this.reverseShip.subEntities[i].remove()
    }
}

this.parkEscorts = function()
{
    var escorts = this.ship.escorts
    if(!escorts) return;
    for(let i=0;i<escorts.length;i++)
    {
        if(escorts[i].isValid) escorts[i].setAI("buoyRepairEscortAI.plist")
    }
}

this.callEscorts = function()
{
    var escorts = this.ship.escorts
    if(!escorts) return;
    for(let i=0;i<escorts.length;i++)
    {
        if(escorts[i].isValid)
        {
            escorts[i].switchAI("escortAI.plist")
            escorts[i].AIState = "FLYING_ESCORT"
        }
    }
}

this.dockEscorts = function()
{
    var escorts = this.ship.escorts
    if(!escorts) return;
    for(let i=0;i<escorts.length;i++)
    {
        if(escorts[i].isValid)
        {
            escorts[i].switchAI("dockingAI.plist")
        }
    }
}

this.hyperspaceHelp = function()
{
  if(this.ship.distanceTravelled > 9000) this.ship.AIState = "GO_WITCHPOINT";
}