this.name      = "buoyRepairController"; 
this.author    = "eric walch"; 
this.copyright = " 2008 the autors.";
this.description = "Station control vessel";
this.version   = "1.02";

this.routes = worldScripts.buoyRepair.routes
this.positionCounter = 0

this.shipSpawned = function()
{
    if(this.ship.displayName == this.ship.name)
            this.ship.displayName = worldScripts.buoyRepair.addShipnumber(this.ship.displayName)
    if(worldScripts.buoyRepair.grsStation) this.grsStation = worldScripts.buoyRepair.grsStation
    this.route = this.routes[Math.floor(Math.random()*this.routes.length)]
    if(this.ship.primaryRole == "defense_ship") 
    {
        if(this.ship.target) this.ship.setAI("interceptAI.plist")
    }
}

this.shipExitedWormhole = function()
{
    if(worldScripts.buoyRepair.grsStation) this.grsStation = worldScripts.buoyRepair.grsStation;
    else this.grsStation = false
}

this.shipDied = function(whom, why)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " was killed by a " + (whom&&whom.isShip?whom.displayName:whom) + ", because of " + why)
    if(this.marker && this.marker.isValid) this.marker.explode()
    if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.controller--
}

this.shipCollided = function(whom)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " collided with " + (whom&&whom.isShip?whom.displayName:whom))
    if(this.ship.energy < this.ship.maxEnergy) this.ship.reactToAIMessage("STOP");
}
    

this.shipDockedWithStation= function(station)
{
    if(worldScripts.buoyRepair.grsStation) worldScripts.buoyRepair.controller--
}

this.nextPosition = function()
{
    if(this.positionCounter<this.route.length)
    {
        this.setApproach(this.route[this.positionCounter])
        if(worldScripts.buoyRepair.logging) log("buoyRepair", this.ship.displayName + " gets coordinate set nr. "+ this.positionCounter +": "+this.route[this.positionCounter])
        this.positionCounter++
        this.ship.reactToAIMessage("APPROACH_COORDINATES");
    }
    else this.ship.reactToAIMessage("END_CONTROL");
    if(this.ship.position.distanceTo(player.ship) > 30E3) this.ship.reactToAIMessage("END_CONTROL");
}

this.setApproach = function(position)
{
    var newPosition = this.grsStation.position
    newPosition = newPosition.add(this.grsStation.orientation.vectorRight().multiply(position.x))
    newPosition = newPosition.add(this.grsStation.orientation.vectorUp().multiply(position.y))
    newPosition = newPosition.add(this.grsStation.orientation.vectorForward().multiply(position.z))
    this.setMarker(newPosition)
    this.ship.target = this.marker
}

this.resetMarker = function()
{
    this.marker.setPosition(this.marker.position.multiply(100+Math.random()))
}

this.setMarker = function(pos)
{
    if(!this.marker || (this.marker && !this.marker.isValid))
    {
        this.marker = this.ship.spawnOne("buoy_repair_marker")
    }
    this.marker.setPosition(pos)
}

this.findGRSStation = function()
{
    if(worldScripts.buoyRepair.grsStation) this.ship.target = this.grsStation
    else this.ship.reactToAIMessage("NO_GRS_STATION");
}