this.name      = "buoyRepair"; 
this.author    = "eric walch (script), Svengali (artwork)"; 
this.copyright = " 2008 the Oolite team.";
this.description = "This script adds buoy repairships when one of the two main navigation buoys gets destroyed";
this.version   = "1.00";

this.startUp = this.reset = function()
{
    this.newstart = true
    this.NLaunchQueueAdded = false
    this.testing = false
}

this.statusCheck = function()
{
    if(player.docked) this.buoyStatusTimer.stop()
    else
    {
        if(!system.isInterstellarSpace && system.countShipsWithRole("buoy-witchpoint") == 0 && system.countShipsWithRole("repairBuoyTuggerW") == 0)
            system.legacy_addShips("repairBuoyTuggerW", 1)
        if(!system.isInterstellarSpace && !this.NLaunchQueueAdded && system.shipsWithRole("buoy", system.mainStation, 20000).length == 0 && system.countShipsWithRole("repairBuoyTuggerN") == 0)
        {
            if (oolite.compareVersion("1.72") > 0) system.mainStation.call("launchShipWithRole:", "repairBuoyTuggerN")
            else system.legacy_addSystemShips("repairBuoyTuggerL", 1, 20) // far away in oolite 1.72+
            this.NLaunchQueueAdded = true
            if(this.testing) log("buoyRepair", "adding repairBuoyTuggerN to launch queue")
        }
    }
}

this.shipLaunchedFromStation = function()
{
    if(this.buoyStatusTimer)
        this.buoyStatusTimer.start()
    else
        this.buoyStatusTimer = new Timer(this, this.statusCheck, 15, (this.testing ? 15 : 120))
    if(this.newstart) this.addStation()
}

this.addStation = function()
{
    this.newstart = false
    if(system.economy < 2 && ((system.government > 3 && system.techLevel < 12 && system.techLevel > 3) || this.testing && !system.isInterstellarSpace) )
    {
        system.legacy_addShipsAtPrecisely("repaired-buoy-station", 1, "pwp", 0.5, 0.5, 2.0)
        let factory = system.shipsWithPrimaryRole("repaired-buoy-station")[0];
        let factoryPos = factory.position
        let planet = system.mainPlanet.position
        let factoryVector = new Vector(planet.subtract(factoryPos)).direction()
        let a = Math.sqrt(1 - (factoryVector.x * factoryVector.x + factoryVector.y * factoryVector.y + factoryVector.z * factoryVector.z)) // normalize quarterion
        if(!(a > 0)) a = 0;
        factory.setOrientation(a, factoryVector.x, factoryVector.y, factoryVector.z)

        system.legacy_addShipsAtPrecisely("buoy_repair_shuttle_u", 2, "pwp", 0.4, 0.4, 0.83)
        
        system.legacy_addShipsAt("GRS-factory-buoy", 1, "pwu", 0.5, 0.5, 20)
        let factoryBuoy = system.shipsWithPrimaryRole("GRS-factory-buoy")[0];
        factoryVector = factory.heading //vector with lenght 1 meter
        factoryBuoy.setPosition(factoryPos.add(factoryVector.multiply(9000))) //move buoy at 9 000 vector units
        system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", 0.02, 0.02, 0.25)
        system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", 0.01, 0.01, 0.50)
        system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", 0.00, 0.00, 0.75)
    }
}

this.shipExitedWitchspace = function()
{
    this.addStation()
    this.NLaunchQueueAdded = false
}