/*

ahruman-futurevision.js

Compatibility script providing some Oolite 1.71 facilities for Oolite 1.70.

*/

this.name			= "ahruman-futurevision";
this.author         = "Jens Ayton";
this.copyright      = "This work is hereby placed in the public domain.";
this.version        = "1.70";


/**** Global functions changed to lowercase ****/
function log()
{
	if (arguments.length == 1)
	{
		Log(arguments[0]);
	}
	else
	{
		LogWithClass.apply(undefined, arguments);
	}
}


function expandDescription(desc)
{
	return ExpandDescription(desc);
}


function displayNameForCommodity(commodity)
{
	return commodity;
}


function randomName()
{
	return RandomName();
}


this.startUp = function ()
{
	// debugConsole is not set up at script loading time, so we need to use startUp.
	var global = (function () { return this; } ).call();
	if (global.debugConsole !== undefined)
	{
		global.consoleMessage = global.ConsoleMessage;
	}
	
	delete this.startUp;
}


/**** Random vectors, in three marvelous flavours ****/

/*	This generates random vectors distrubuted evenly over the surface of the
	unit sphere. It does this the simple way, by generating vectors in the
	half-unit cube and rejecting those outside the half-unit sphere (and the
	zero vector), then normalizing the result. (Half-unit measures are used
	to avoid unnecessary multiplications of Math.random() values.)
*/
Vector.randomDirection = function (scale)
{
	if (scale == undefined)  scale = 1.0;	// maxLength is optional
	
	var result, sqM;
	do
	{
		result = new Vector(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
		sqM = result.squaredMagnitude();
	}
	while (sqM == 0.0 || sqM > 0.25);	// We're confining to a sphere of radius 0.5 using the sqared magnitude; 0.5 squared is 0.25.
	
	result = result.direction();
	if (scale !== undefined)  result = result.multiply(scale);
	return result;
}


//	Produces vectors randomly distributed in the unit sphere, with even
//	distribution, but a bias towards longer vectors.
Vector.random = function (maxLength)
{
	if (maxLength === undefined)  maxLength = 1.0;	// maxLength is optional
	
	var result, sqM;
	do
	{
		result = new Vector(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
		sqM = result.squaredMagnitude();
	}
	while (sqM > 0.25);	// We're confining to a sphere of radius 0.5 using the sqared magnitude; 0.5 squared is 0.25.
	
	return result.multiply(maxLength * 2.0);
}


//	Produces vectors with random direction and evenly distributed length, but
//	bias towards higher density near the centre.
Vector.randomDirectionAndLength = function (maxLength)
{
	if (maxLength === undefined)  maxLength = 1.0;	// maxLength is optional
	return Vector.randomDirection().multiply(Math.random() * maxLength);
}


/**** Vector and Quaternion toArray() methods ****/

Vector.__proto__.toArray = function ()
{
	return [x, y, z];
}


Quaternion.__proto__.toArray = function ()
{
	return [w, x, y, z];
}


/**** Dummy implementation of Sound. Does not actually play sound. ****/
function Sound(name)
{
	var n = name;
	this.__defineGetter__("name", function () { return n; } );	// Read-only property
}

Sound.prototype =
{
	toString: function ()
	{
		return "[Sound \"" + this.name + "\"]";
	}
};

Sound.load = function (name)
{
	return new Sound(name);	// Note: constructor syntax can't be used directly in 1.71. Why? I don't remember.
}

Sound.playMusic = function (name) {}
Sound.stopMusic = function () {}


/**** Dummy implementation of SoundSource. Also does not actually play sound. ****/
function SoundSource()  {}

SoundSource.prototype =
{
	sound: null,
	isPlaying: false,
	loop: false,
	repeatCount: 1,
	
	toString: function () { return "[object SoundSource]"; },
	play: function (count)
	{
		if (count !== undefined && count > 0)
		{
			if (count > 100)  count = 100;
			this.repeatCount = count;
		}
		this._remainingCount = this.repeatCount ? this.repeatCount : 1;
		this._playOnce();
	},
	stop: function ()
	{
		if (this.isPlaying)
		{
			log("dummySoundSource.end", "Stopping sound " + this.sound.name);
			this._timer.stop();
			this._timer = null;
			this.isPlaying = false;
		}
	},
	playOrRepeat: function ()
	{
		if (this.isPlaying)  this._remainingCount++;
		else  this.play();
	},
	playSound: function (snd)
	{
		this.sound = snd;
		this.play();
	},
	
	// Dummy implementation properties not in the real thing
	_timer: null,
	_duration: 3,
	_remainingCount: 0,
	_playOnce: function ()
	{
		if (this.sound)
		{
			if (!this.isPlaying)  log("dummySoundSource.start", "Starting sound " + this.sound.name);
			this.isPlaying = true;
			this._timer = new Timer(this, this._timeOut, this._duration);
			this._timer.isPersistent = true;
			this._remainingCount--;
		}
	},
	_timeOut: function ()
	{
		this._timer = null;
		if (this.loop)  this._remainingCount++;
		if (this._remainingCount > 0)
		{
			log("dummySoundSource.repeat", "Repeating sound " + this.sound.name);
			this._playOnce();
		}
		else
		{
			log("dummySoundSource.end", "Stopping sound " + this.sound.name);
			this.isPlaying = false;
		}
	}
};



/**** Testing ****/
/*
//	Function to test distribution of Vector.random().
testVectorRandomizer = function testVectorRandomizer(rFunc)
{
	var i, granularity = 20, iterations = 10000;
	var bins = [];
	var v, m;
	
	for (i = 0; i < granularity; i++)  bins[i] = 0;
	
	for (i = 0; i < iterations; i++)
	{
		v = rFunc();
		m = v.magnitude();
		
		if (m < 0.0)  log("Vector.random.test", "Vector with negative length! |" + v + "| = " + m);	// Can't happen. Really. I hope.
		else if (m > 1.0001)  log("Vector.random.test", "Vector too long: |" + v + "| = " + m);		// Shouldn't happen.
		else
		{
			if (m >= 1.0)  m = 1.0;	// Allow lengths up to 1.0001 because of inaccuracies.
			m *= granularity;
			m = Math.ceil(m) - 1;
			
			bins[m]++;
		}
	}
	
	for (i = 0; i != granularity; i++)
	{
		log("Vector.random.test", "Bin " + i + ": " + bins[i] + "  (" + 100.0 * bins[i] / iterations + "%)");
	}
}


function randomTest() { testVectorRandomizer(Vector.random); }
function randomDLTest() { testVectorRandomizer(Vector.randomDirectionAndLength); }
function randomDirTest() { testVectorRandomizer(Vector.randomDirection); } // should produce results in bin 19 (or granularity - 1) only.
*/
