this.name      = "buoyRepairShuttle"; 
this.author    = "eric walch"; 
this.copyright = " 2008 the Oolite team.";
this.description = "Shuttle script";
this.version   = "1.00";

this.shipSpawned = function()
{
    let list = ["NL", "DG", "RF", "PH", "TZ"]
    this.ship.shipDisplayName = this.ship.shipDisplayName + " " + list[Math.floor(Math.random() * list.length)] + Math.ceil(Math.random()*127)
    if(this.ship.primaryRole == "buoy_repair_shuttle")
    {
        this.ship.switchAI("fallingBuoyRepairShuttleAI.plist");
        this.ship.primaryRole = "shuttle"
    }
    delete this.shipSpawned;
}

this.shipApproachingPlanetSurface = function()
{
    if(this.ship.primaryRole == "shuttle")
    {
        this.ship.switchAI("fallingBuoyRepairShuttleAI.plist"); // make sure it is not in a gotoWaypointAI
        this.ship.AIState = "LANDING"
        if(worldScripts.buoyRepair.testing) log("repairBuoy", this.ship.shipDisplayName + " is approaching surface and prepares for landing.")
    }
}
// the AI message "APPROACH_SURFACE" is often not working because the AI switches to gotoWaypointAI before.

this.shipDied = function(whom, why)
{
    if(worldScripts.buoyRepair.testing) log("buoyRepair", this.ship.shipDisplayName + " was killed by a " + (whom.shipDisplayName?whom.shipDisplayName:whom) + ", because of " + why)
}

this.findGRSStation = function()
{
    this.ship.target = worldScripts.buoyRepair.grsStation.ID
}


this.checkDistance = function()
{
    let planet = system.mainPlanet
    let distance = planet.position.distanceTo(this.ship) - planet.radius
    if(distance < 2000)  this.ship.AIState = "APPROACH"

}