this.name        = "OXPConfig";
this.author      = "svengali";
this.copyright   = "CC-by-nc-sa-3.0";
this.description = "Configuration Tool for oxps";
this.version     = "1.01";

this.startUp = function()
{
	this.oxpConfigTimer = new Timer(this, this.oxpConfigTimer, 0, 10);
	this.shouldShow = false; this.showsNow = false; this.started = false; this.currentPage = 0; this.currentCommander = "";
}

this.reset = function()
{
	if (!this.started) {
		this.numberOfOxps = expandDescription("[OXPCONFIG_OVERALLB]");
		this.currentOxp = new Array(); this.started = true; }
	if (missionVariables.oxpConfig_settings && this.currentCommander != player.name) { this.currentCommander = player.name; this.loadSettings(); }
	this.oxpConfigTimer.start(); this.oxpOverride = 0;
}

this.oxpConfigTimer = function()
{
	if (player.status == "STATUS_DOCKED" && guiScreen == "GUI_SCREEN_GAMEOPTIONS") { this.shouldShow = true; this.oxpConfigTimer.stop();
		player.consoleMessage('OXPConfig activated.\nStep to SYSTEM_DATA_SCREEN for configuration screens.', 2); }
}

this.guiScreenChanged = function(to)
{
	if (this.shouldShow && player.status == "STATUS_DOCKED") {
		if (to == "GUI_SCREEN_SYSTEM_DATA") { this.showConfigScreens(); return; }
		else if(to != "GUI_SCREEN_SYSTEM_DATA" && !this.showsNow) {
			this.currentPage = 0; this.shouldShow = false; this.oxpConfigTimer.start();
			player.consoleMessage('OXPConfig de-activated.', 3);
			missionVariables.offering = null; mission.choice = null; } }
}

this.showConfigScreens = function(stored,loaded)
{
	missionVariables.offering = "OXP-CONFIG"; this.showsNow = true;
	mission.runMissionScreen("OXPCONFIG_FIRST", null, "OXPCONFIG_TOPLEVEL", null, null);
	if (loaded == 1) { mission.addMessageTextKey("OXPCONFIG_LOADED"); }
	if (loaded == 2) { mission.addMessageTextKey("OXPCONFIG_LOADEDERROR"); }
	if (stored == 1) { mission.addMessageTextKey("OXPCONFIG_STORED"); }
	if (stored == 2) { mission.addMessageTextKey("OXPCONFIG_STOREDERROR"); }
	mission.addMessageTextKey("OXPCONFIG_WELCOMEA"); mission.addMessageTextKey("OXPCONFIG_WELCOMEB");
	mission.addMessageTextKey("OXPCONFIG_QUEST");
}

this.showNextScreen = function(nextchoice,oxp)
{
	this.oxpOverride = 0;
	if (oxp) { let checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
		if (!worldScripts[checkoxp]) { this.changedOxp = oxp; mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null);
			mission.addMessageText(expandDescription("[OXPCONFIG"+oxp+"_INFO0]")+' is not installed.'); mission.setChoicesKey("OXPCONFIG_CHANGE0"); return; }
		if (typeof(worldScripts[checkoxp].logging) == 'undefined') this.oxpOverride |= 1;
		if (typeof(worldScripts[checkoxp].audio) == 'undefined') this.oxpOverride |= 2;
		if (typeof(worldScripts[checkoxp].extraA) == 'undefined') this.oxpOverride |= 4;
		if (typeof(worldScripts[checkoxp].extraB) == 'undefined') this.oxpOverride |= 8;
		if (this.oxpOverride == 15) { this.changedOxp = oxp; mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null);
			mission.addMessageText('This version of '+checkoxp+' is not compatible. Maybe it is an older version.'); mission.setChoicesKey("OXPCONFIG_CHANGE0"); return; } }
	if (!nextchoice || nextchoice == "") { mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null); }
	else { mission.runMissionScreen("OXPCONFIG_FIRST", null, nextchoice, null, null); }
	if (oxp) { this.changedOxp = oxp;
		for (let i = 0; i != 3; i++) { this.currentOxp[i] = expandDescription("[OXPCONFIG"+oxp+"_INFO"+i+"]"); }
		mission.addMessageText('Current OXP: '+worldScripts[this.currentOxp[0]].name+' '+worldScripts[this.currentOxp[0]].version+'\r\r\rAuthor:'+worldScripts[this.currentOxp[0]].author+' #'+oxp);
		mission.addMessageTextKey("OXPCONFIG_DIVIDE");
		if ((this.currentOxp[1]&1) && !(this.oxpOverride&1)) { mission.addMessageText('logging : '+worldScripts[this.currentOxp[0]].logging); }
		if ((this.currentOxp[1]&2) && !(this.oxpOverride&2)) { mission.addMessageText('audio     : '+worldScripts[this.currentOxp[0]].audio); }
		if ((this.currentOxp[1]&4) && !(this.oxpOverride&4)) { mission.addMessageText('extraA   : '+worldScripts[this.currentOxp[0]].extraA); }
		if ((this.currentOxp[1]&8) && !(this.oxpOverride&8)) { mission.addMessageText('extraB   : '+worldScripts[this.currentOxp[0]].extraB); }
		let a = "OXPCONFIG_CHANGE"+((~this.oxpOverride)&this.currentOxp[1]); mission.setChoicesKey(a);
		if (this.currentOxp[2] != "" && this.currentOxp[2]) { mission.addMessageTextKey("OXPCONFIG_DIVIDE"); mission.addMessageText("\nOptions info:\n"+this.currentOxp[2]); }
		if ((this.oxpOverride&this.currentOxp[1])) mission.addMessageText('Not supported options disabled.');
	}
	mission.addMessageTextKey("OXPCONFIG_QUEST");
}

this.missionScreenEnded = function()
{
    if(mission.choice && missionVariables.offering == "OXP-CONFIG" && this.shouldShow && this.showsNow) this.choiceEvaluation();
	else if (missionVariables.offering != "OXP-CONFIG" && this.shouldShow && !this.showsNow) this.shouldShow = false;
}

this.missionChoiceWasReset = function()
{
   if(mission.choice && missionVariables.offering == "OXP-CONFIG" && this.shouldShow && this.showsNow) this.choiceEvaluation();
}

this.choiceEvaluation = function()
{
	if (missionVariables.offering == "OXP-CONFIG") {
		switch (mission.choice) {
			case "OXPCONFIG_CHANGE":
				this.showNextScreen("OXPCONFIG_PAGE1"); this.currentPage = 1; break;
			case "OXPCONFIG_RELOAD":
				if (this.loadSettings()) { this.showConfigScreens(null,1); break; }
				else { this.showConfigScreens(null,2); break; }
			case "OXPCONFIG_SAVE":
				if (this.storeSettings()) { this.showConfigScreens(1,null); break; }
				else { this.showConfigScreens(2,null); break; }
			case "OXPCONFIG_ZQUIT":
				missionVariables.offering = null; mission.choice = null; this.showsNow = false; break;
			case "OXPCONFIG_PAGEA0":
				this.showNextScreen(null,"0"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA1":
				this.showNextScreen(null,"1"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA2":
				this.showNextScreen(null,"2"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA3":
				this.showNextScreen(null,"3"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEB0":
				this.showNextScreen(null,"4"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB1":
				this.showNextScreen(null,"5"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB2":
				this.showNextScreen(null,"6"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB3":
				this.showNextScreen(null,"7"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEC0":
				this.showNextScreen(null,"8"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC1":
				this.showNextScreen(null,"9"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC2":
				this.showNextScreen(null,"10"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC3":
				this.showNextScreen(null,"11"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEX":
				this.currentPage++; this.showNextScreen("OXPCONFIG_PAGE"+this.currentPage); break;
			case "OXPCONFIG_PAGEY":
				this.currentPage--; this.showNextScreen("OXPCONFIG_PAGE"+this.currentPage); break;
			case "OXPCONFIG_PAGEZ":
				this.showConfigScreens(null,null); break;
			case "OXPCONFIG_CHANGEA":
				if (!worldScripts[this.currentOxp[0]].logging) worldScripts[this.currentOxp[0]].logging = true;
				else worldScripts[this.currentOxp[0]].logging = false;
				this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGEB":
				if (!worldScripts[this.currentOxp[0]].audio) worldScripts[this.currentOxp[0]].audio = true;
				else worldScripts[this.currentOxp[0]].audio = false;
				this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGEC":
				if (!worldScripts[this.currentOxp[0]].extraA) worldScripts[this.currentOxp[0]].extraA = true;
				else worldScripts[this.currentOxp[0]].extraA = false;
				this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGED":
				if (!worldScripts[this.currentOxp[0]].extraB) worldScripts[this.currentOxp[0]].extraB = true;
				else worldScripts[this.currentOxp[0]].extraB = false;
				this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_ZA":
				if (this.changedOxp >= 0 && this.changedOxp <= 3) { this.showNextScreen("OXPCONFIG_PAGE1"); break; }
				if (this.changedOxp >= 4 && this.changedOxp <= 7) { this.showNextScreen("OXPCONFIG_PAGE2"); break; }
				if (this.changedOxp >= 8 && this.changedOxp <= 11) { this.showNextScreen("OXPCONFIG_PAGE3"); break; }
			default:
				break;
	} }
}

this.shipWillDockWithStation = function()
{
	this.oxpConfigTimer.start();
}

this.shipWillLaunchFromStation = function()
{
	if (missionVariables.offering) log('OXPConfig','OXPConfig: missionVariables.offering not cleared - '+missionVariables.offering);
	if (typeof(mission.choice) != 'object') log('OXPConfig','OXPConfig: mission.choice not cleared - '+mission.choice);
	this.oxpConfigTimer.stop(); this.shouldShow = false; this.showsNow = false; this.currentPage = 0; this.oxpOverride = 0;
}

this.loadSettings = function()
{
	if (!this.numberOfOxps) { log('OXPConfig','OXPConfig: Can not load settings. No Number of oxps available.'); return (false); }
	if (missionVariables.oxpConfig_settings) let settings = parseInt(missionVariables.oxpConfig_settings);
	else { log('OXPConfig','OXPConfig: Can not load settings. No stored value found.'); return (false); }
	let maxValue = Math.pow(2,this.numberOfOxps*4); let oxp = 0; let checkoxp = ''; let loop = 0;
	if (settings > maxValue) { log('OXPConfig','OXPConfig: Stored value is not valid.'); return (false); }
	if (missionVariables.oxpConfig_storedOxps) {
		if (this.numberOfOxps > missionVariables.oxpConfig_storedOxps) { loop = missionVariables.oxpConfig_storedOxps; log('OXPConfig','OXPConfig: Updated database found.'); }
		else loop = this.numberOfOxps;
	}
	else { let c = settings; while (c > 0) { loop++; c = c>>>4; }
		log('OXPConfig','OXPConfig: Updated database found. OXPConfig only changes '+loop+' oxps.'); }
	log('OXPConfig','OXPConfig: settings loaded:'+settings);
	for (let i = 0; i < (loop*4); i += 4) {
		checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
		if (!worldScripts[checkoxp]) { oxp++; settings = settings>>>4; continue; }
		if (typeof(worldScripts[checkoxp].logging) != 'undefined') {
			if ((settings&1)) worldScripts[checkoxp].logging = true;
			else worldScripts[checkoxp].logging = false;
		}
		if (typeof(worldScripts[checkoxp].audio) != 'undefined') {
			if ((settings&2)) worldScripts[checkoxp].audio = true;
			else worldScripts[checkoxp].audio = false;
		}
		if (typeof(worldScripts[checkoxp].extraA) != 'undefined') {
			if ((settings&4)) worldScripts[checkoxp].extraA = true;
			else worldScripts[checkoxp].extraA = false;
		}
		if (typeof(worldScripts[checkoxp].extraB) != 'undefined') {
			if ((settings&8)) worldScripts[checkoxp].extraB = true;
			else worldScripts[checkoxp].extraB = false;
		}
		oxp++; settings = settings>>>4;
	}
	log('OXPConfig','OXPConfig: settings done.');
	return (true);
}

this.storeSettings = function()
{
	if (!this.numberOfOxps) { log('OXPConfig','OXPConfig: Can not store settings. No Number of oxps available.'); return (false); }
	let settings = 0; let oxp = 0; let checkoxp = ''; let maxAnd = (Math.pow(2,(this.numberOfOxps*4))-1);
	if (missionVariables.oxpConfig_settings) settings = parseInt(missionVariables.oxpConfig_settings);
	for (let i = 0; i < (this.numberOfOxps*4); i += 4) {
		checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
		if (!worldScripts[checkoxp]) { oxp++; continue; }
		if (typeof(worldScripts[checkoxp].logging) != 'undefined') {
			if (!worldScripts[checkoxp].logging) settings &= maxAnd-Math.pow(2,i);
			else settings |= Math.pow(2,i);
		}
		if (typeof(worldScripts[checkoxp].audio) != 'undefined') {
			if (!worldScripts[checkoxp].audio) settings &= maxAnd-Math.pow(2,i+1);
			else settings |= Math.pow(2,i+1);
		}
		if (typeof(worldScripts[checkoxp].extraA) != 'undefined') {
			if (!worldScripts[checkoxp].extraA) settings &= maxAnd-Math.pow(2,i+2);
			else settings |= Math.pow(2,i+2);
		}
		if (typeof(worldScripts[checkoxp].extraB) != 'undefined') {
			if (!worldScripts[checkoxp].extraB) settings &= maxAnd-Math.pow(2,i+3);
			else settings |= Math.pow(2,i+3);
		}
		oxp++; }
	log('OXPConfig','OXPConfig: settings:'+settings);
	missionVariables.oxpConfig_settings = String(settings);
	missionVariables.oxpConfig_storedOxps = oxp;
	return (true);
}
