"use strict";

this.name = "Little Friends";
this.author = "Reval";
this.description = "For a modest cost, the Merchanters' League is pleased to provide its traders with a regular escort of fully refitted robot-piloted milspec Mamba IIe fighters.";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.0.1";

/* 

For you, the old-school trader raised to ply the arrow-straight course from Witchpoint to Main Station, being perhaps hesitant - or loath - to drive your run offlane for safety, we of the Galactic Merchanters' League (M.L.) have the perfect solution: For a modest fee and running contract, M.L. can provide your ship with a regular escort of fully refitted robot-piloted milspec Mamba IIe fighters. 

Your programmed escorts will join you on Station-undock as well as on arrival at the post-Hyperjump Witchpoint destination.

The Mamba IIe robot escort will appear as deep blue blips on your scanner.

They are programmed to interdict potential attackers as soon as they scan them. Thus, they do not always 'stick close' to your mothership. They will resume escort duty after a successful pre-emptive defence, provided they are in a condition to do so.

Version 1.0.0
--------------
Initial public offering.

Version 1.0.1
-------------
Tidied up code and added M.L. Service fees plus Contract Options to the F4 Interfaces

*/


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_LF_MAMBA_ESCORT") {		
		pc("Preparing "+this.$lfNumEscort+"x Mamba IIe Escort contract.",9);
		pc("Please verify details on your M.L. F4 Interface.",9);
		this.$lfEscortEnabled="yes";
	} else
	// Service cancellation removal and refund
	if (equipment == "EQ_LF_MAMBA_ESCORT_REM") {
		player.ship.removeEquipment("EQ_LF_MAMBA_ESCORT");
		player.ship.removeEquipment("EQ_LF_MAMBA_ESCORT_REM");
		pc("Cancelling your Mamba IIe Escort Service.",9);
		player.credits += this.$lfCost/2;
		pc("Amount refunded: "+ this.$lfCost/2,9);
	}
}



this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$lfHFExempt;
	// check we have service, the fee is not paid, and we're not exempt
	if ((this.$lfHasEscort) && (this.$lfNumEscort>0) && (this.$lfHandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$lfNumEscort; x++)
			fee += this.$lfHandlingFee;
		// record fee and debit trader's account
		this.$lfHandlingFeeTotal += fee;
		player.credits -= fee;
		this.$lfHandlingPaid = "yes";
		pc(this.$lfNumEscort+" x Mamba Escort handling fee: "+fee+" cr",9);
		this.$lfHandlingCount++;
	}
	if (this.$lfHasEscort) {
		// conditionally take maintenance fee
		if (this.$lfNumEscort>0) this._lfDoMaintenance();
		// prepare Escort Contract and Options pages
		this._lfPrepAcc(station);
		this._lfPrepOpt(station);
		// prepare handling fee waiver request if ET or FESP is present
		//if (this.$lfNumEscort>0) this._lfPrepEx(station);
	}
}


this.shipLaunchedFromStation = function(stationLaunchedFrom) {
	var pc = player.commsMessage;
	// ESCORTS
	this.$lfHasEscort = (player.ship.equipmentStatus ("EQ_LF_MAMBA_ESCORT") === "EQUIPMENT_OK");
	if (this.$lfHasEscort && this.$lfNumEscort>0) {
		pc("Mamba Escorts are arriving...",6);
		var ships = system.addShips("lf_escort", this.$lfNumEscort, system.mainStation.position,0.2);
		// report miscreants in system
		var mis = system.countShipsWithPrimaryRole("pirate");
		// muster escorts
		pc("Mamba Escort reports Miscreants in system: "+mis,9);
		pc(" ");
	} else pc("Escorts hirable from Main Station. Good Luck!");

}



this.shipExitedWitchspace = function() {
	var pc = player.commsMessage;
	// report miscreants in system
	var mis = system.countShipsWithPrimaryRole("pirate");
	// muster escorts somewhere near witchpoint
	if (this.$lfHasEscort && this.$lfNumEscort>0) {
		pc("Mamba Escorts are arriving...",6);
		var ships = system.addShips("lf_escort", this.$lfNumEscort);
		pc("Mamba Escort reports Miscreants in system: "+mis,9);
		pc(" ");
	} else pc("Escorts hirable from Main Station. Good Luck!");
	// set handling paid to 'no'
	this.$lfHandlingPaid = "no";
	this.$lfRuns ++;
}



this.shipWillDockWithStation = function(station) {
	// remove fast-docking equipment
	player.ship.removeEquipment("EQ_ET_AUTODOCK");
}


this.shipWillLaunchFromStation = function(station) {
	// enable fast docking
	this._installAutoDock();
}


this.playerWillSaveGame = function(message) {
	missionVariables.lfNumEscort = this.$lfNumEscort;
	missionVariables.lfEscortEnabled = this.$lfEscortEnabled;
	// save total fees taken
	missionVariables.lfHandlingFeeTotal = this.$lfHandlingFeeTotal;
	missionVariables.lfMaintenanceFeeTotal = this.$lfMaintenanceFeeTotal;
	missionVariables.lfDismantlingFeeTotal = this.$lfDismantlingFeeTotal;
	missionVariables.lfHandlingPaid = this.$lfHandlingPaid;
	// system-to-system runs w/pod
	missionVariables.lfRuns =this.$lfRuns;
	// handling fee count
	missionVariables.lfHandlingCount = this.$lfHandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.lfHFExempt = this.$lfHFExempt;
	// maintenance fee count
	missionVariables.lfMaintenanceCount = this.$lfMaintenanceCount;
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.lfNumEscort != null) 
		this.$lfNumEscort = missionVariables.lfNumEscort;
	if (missionVariables.lfEscortEnabled != null) 
		this.$lfEscortEnabled = missionVariables.lfEscortEnabled;
	// Load total fees taken
	if (missionVariables.lfHandlingFeeTotal != null)
		this.$lfHandlingFeeTotal = missionVariables.lfHandlingFeeTotal;
	if (missionVariables.lfHandlingPaid != null)
		this.$lfHandlingPaid = missionVariables.lfHandlingPaid;
	if (missionVariables.lfMaintenanceFeeTotal != null)
		this.$lfMaintenanceFeeTotal = missionVariables.lfMaintenanceFeeTotal;
	if (missionVariables.lfDismantlingFeeTotal != null)
		this.$lfDismantlingFeeTotal = missionVariables.lfDismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.lfRuns != null)
		this.$lfRuns = missionVariables.lfRuns;
	// Load Handling fee count
	if (missionVariables.lfHandlingCount != null)
		this.$lfHandlingCount = missionVariables.lfHandlingCount;
	// Load handling fee exemption status
	if (missionVariables.lfHFExempt != null)
		this.$lfHFExempt = missionVariables.lfHFExempt;
	// Load Maintenance fee count
	if (missionVariables.lfMaintenanceCount != null)
		this.$lfMaintenanceCount = missionVariables.lfMaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// ESCORTS PRESENT?
	this.$lfHasEscort = (player.ship.equipmentStatus ("EQ_LF_MAMBA_ESCORT") === "EQUIPMENT_OK");
	if (this.$lfHasEscort) {
		// prepare pod Account screen
		var sta = player.ship.dockedStation;
		this._lfPrepAcc(sta);
		this._lfPrepOpt(sta);
		// optionally, prepare handling fee waiver request
		//if (this.$lfNumEscort>0) this._lfPrepEx(sta);
	}
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// declare & initialize globals
	// Trader may be provided with Mamba IIe escort ships
	this.$lfHasEscort = false;
	// Traders have the option to disable the service
	this.$lfEscortEnabled = "no";
	// Traders may choose the number of ships to escort them
	this.$lfNumEscort = 4;
	// purchase cost of Escort contract
	this.$lfCost = 1000;
	// handling fee for Escort Service
	this.$lfHandlingFee = 0.05*this.$lfCost; 
	this.$lfHandlingFeeTotal = 0;
	this.$lfHandlingPaid = "yes"; // or "no" - easier than boolean
	this.$lfHandlingCount = 0;
	this.$lfHFExempt = "no";
	// maintenance fee for ships and robots
	this.$lfMaintenanceFee = 0.075*this.$lfCost;
	this.$lfMaintenanceFeeTotal = 0;
	this.$lfMaintenancePaid = "no" // or "yes"
	this.$lfMaintenanceInterval = 10; // in runs (according to cost)
	this.$lfMaintenanceCount = 0;
	// fee for cancellation of Escort contract
	this.$lfDismantlingFee = 0.5*this.$lfCost; 
	this.$lfDismantlingFeeTotal = 0.0;
	// system-to-system runs w/service
	this.$lfRuns = 0;
}


// assess and take maintenance fee
this._lfDoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$lfRuns;
	var intv = this.$lfMaintenanceInterval;
	var mfee = this.$lfMaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$lfNumEscort; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$lfMaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc(this.$lfNumEscort,"x Mamba Escort maintenance fee: "+fee+" cr",9);
		// update Maintenance count
		this.$lfMaintenanceCount++;
	}
}


this._installAutoDock = function() {
	var p = player.ship;
	// give the escort-contracted trader free fast-docking facilities at any station
	if (p.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") {
			p.awardEquipment("EQ_ET_AUTODOCK");
	}
}


/* F4 Interfaces */


// create M.L.S.S. 'Contract & Account' page 
this._lfPrepAcc = function(station) {
	station.setInterface("lfAcc",{
	title: "Your M.L.S.S. Mamba Escort Contract",
	category: "M.L.S.S.",
	summary: "Your M.L. Ship Services Mamba IIe Escort account screen shows terms, fees and other pertinent information.",
	callback: this._lfShowAcc.bind(this)
	});	
}


// show M.L.S.S. 'Contract & Account' page
this._lfShowAcc = function() {
	var hfc = this.$lfHandlingCount;
	var mfc = this.$lfMaintenanceCount;
	var mfi = this.$lfMaintenanceInterval;
	var hft = this.$lfHandlingFeeTotal;
	var mft = this.$lfMaintenanceFeeTotal;
	var dft = this.$lfDismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "Merchanters' League Ship Services (M.L.S.S.)";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$lfNumEscort>0) 
		parameters.message +="This constitutes your Contract and Account for Robot Mamba IIe Escort x "+this.$lfNumEscort+": \n\n"; 
	 else
		parameters.message +="You have no Mamba Escort Service contract with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Cancellation fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our technologically enhanced Mamba IIe milspec escort defence craft and their neuromechanical pilots require constant maintenance and, frequently, salvage, damage-repair and replacement of losses. \n\n";
	
	parameters.message += "The handling charge (0.05 of cost) is levied upon docking, the maintenance fee (0.075 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "Should you opt to cancel your Mamba Escort contract with us at any time, we must charge a cancellation fee (0.5 of initial cost) to cover any unforseen losses or legal fees incurred during service. \n";
	
	parameters.choicesKey = "lfAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("M.L. Ship Services thanks you for your custom.");
	}
}



// create M.L.S.S. 'Escort Options' page 
this._lfPrepOpt = function(station) {
	station.setInterface("lfOpt",{
	title: "Your M.L.S.S. Mamba Escort Options",
	category: "M.L.S.S.",
	summary: "M.L. Ship Services offers you these choices regarding your Mamba IIe 'Little Friends' Escort contract.",
	callback: this._lfShowOpt.bind(this)
	});	
}


// Offer M.L.S.S. Options for Mamba Escort Service
this._lfShowOpt = function() {
		
	var parameters = new Object();
	var pc = player.commsMessage;
	
	parameters.title = "Merchanters' League Ship Services (M.L.S.S.)";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$lfNumEscort>0) 
		parameters.message +="M.L.S.S. is pleased to offer you the following options as to the numbert of Escort craft to be deployed with your ship: \n\n"; 
	 else
		parameters.message +="You have no Mamba Escort ships deployed at this time. Please select from the options below: \n\n";
		
	
	parameters.choicesKey = "lfOptions";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "0_NONE") this.$lfNumEscort=0; else 
		if (choice === "1_ONE")  this.$lfNumEscort=1; else
		if (choice === "2_TWO")  this.$lfNumEscort=2; else
		if (choice === "3_THREE")this.$lfNumEscort=3; else
		if (choice === "4_FOUR") this.$lfNumEscort=4; else
		if (choice === "5_FIVE") this.$lfNumEscort=5; else
		if (choice === "6_SIX")  this.$lfNumEscort=6;
			
		if (this.$lfNumEscort<1) { 
			this.$lfEscortEnabled="no";
			pc("M.L.S.S. notes your request for no Escort."); 
		} else {
			this.$lfEscortEnabled="yes";
			pc("M.L.S.S. notes your request for "+this.$lfNumEscort+" Escorts.");
		}
	}
}

