"use strict";
this.name        = "radio";
this.author      = "Norby";
this.copyright   = "2013 Norbert Nagy";
this.licence     = "CC BY-NC-SA 3.0";
this.description = "You can answer to a question on the HUD menu using this equipment.";
this.version     = "1.0";

this.activated = function () { //step to the next answer in the HUD menu
	worldScripts["hudreq"].$HUDReq_Step(1);
}

this.mode = function () { //confirm selection in the HUD menu
	worldScripts["hudreq"].$HUDReq_Step(0);
}

this.back = function () { //step back to the previous answer in the HUD menu
	player.consoleMessage("Thank you for implementing the back button!", 10);
	worldScripts["hudreq"].$HUDReq_Step(-1);
}

this.closed = function () { //close the HUD menu
	player.consoleMessage("Thank you for implementing the close button!", 10);
	player.consoleMessage("Bye!");
	worldScripts["hudreq"].$HUDReq_ExitFromHUDReq();
}

this.entered = function ( text ) { //Input Box
	player.consoleMessage("You entered \""+text+"\", thank you!", 10);
}

this.keypressed = function ( key ) { //Keyboard mode
	player.consoleMessage("You pressed \""+text+"\", thank you!", 10);
}
