"use strict";
this.name        = "logevents";
this.author      = "Norby";
this.copyright   = "2013 Norbert Nagy";
this.licence     = "CC BY-NC-SA 3.0";
this.description = "Log player events to review a battle, with added ShipVersion OXP support.";
this.version     = "1.0";

this.$LogEvents_On = true; //turn off means no event logging at all
this.$LogEvents_Prefix = "LogEvents"; //this will be the messageClass string in the log

this.$LogEvents_Ships = []; //store the ships spawned during timer
this.$LogEvents_Timer = null; //store the timer pointer


//these documented as ship script events but usually works as a world script event for the player also
this.shipTargetAcquired = function(target) {
	this.$LogEvents_Player( "targeted", target, "who has "+this.$LogEvents_NPCLeft( target ) );
}

this.shipTakingDamage = function(amount, whom, type) {
	var s = "shield damage";
	if( amount > 0 ) s = Math.round( amount ) + " " + type;
	this.$LogEvents_Player( "taking "+s+" from", whom, this.$LogEvents_PlayerLeft() );
}

this.cascadeWeaponDetected = function(weapon) {
	this.$LogEvents_Player( "detected cascade weapon "+weapon );
}

this.shipBeingAttackedUnsuccessfully = function(whom) {
	this.$LogEvents_Player( "attacked unsuccessfully by", whom );
}

this.shipCloakActivated = function() {
	this.$LogEvents_Player( "cloak is activated" );
}

this.shipCloakDectivated = function() {
	this.$LogEvents_Player( "cloak is deactivated" );
}

this.shipEnergyBecameFull = function() {
	this.$LogEvents_Player( "energy is full" );
}

this.shipEnergyIsLow = function() {
	this.$LogEvents_Player( "energy is low" );
}

this.shipHitByECM = function(pulsesRemaining) {
	this.$LogEvents_Player( "hit by ECM, "+pulsesRemaining+" remaining" );
}

this.commsMessageReceived = function(message, sender) {
	this.$LogEvents_Player( "got message from", sender, ": "+message );
}

this.distressMessageReceived = function(aggressor, sender) {
	this.$LogEvents_Player( "got distress message from", sender,
			     ": Help! "+this.$LogEvents_TargetName(aggressor)+" attacking me!" );
}

this.shipBountyChanged = function(delta, reason) {
	if(delta != 0) this.$LogEvents_Player( "bounty is changed by "+delta+
		" to "+player.bounty+" due to "+reason );
}

this.shipCloseContact = function(otherShip) {
	this.$LogEvents_Player( "is in close contact with", otherShip);
}

this.shipReachedEndPoint = function() {
	this.$LogEvents_Player( "reached endpoint" );
}

this.shipReachedNavPoint = function() {
	this.$LogEvents_Player( "reached navpoint" );
}


//world script events
this.playerWillSaveGame = function(message) {
	this.$LogEvents_Player( message );
}

this.shipWillDockWithStation = function(station) {
	this.$LogEvents_Player( "will dock to", station );
}

this.shipDockedWithStation = function(station) {
	this.$LogEvents_Player( "docked to", station );
}

this.shipWillLaunchFromStation = function(station) {
	var m2 = "";
	if( player.ship ) m2 = "flying "+this.$LogEvents_TargetName(player.ship);
	this.$LogEvents_Player( "will launch from", station, m2 );
}

this.shipLaunchedFromStation = function(station) {
	this.$LogEvents_Player( "launched from", station );
}

this.playerStartedAutoPilot = function() {
	this.$LogEvents_Player( "started AutoPilot" );
}

this.playerCancelledAutoPilot = function() {
	this.$LogEvents_Player( "cancelled AutoPilot" );
}

this.playerDockingRefused = function() {
	this.$LogEvents_Player( "docking refused" );
}

this.playerRequestedDockingClearance = function(message) {
	this.$LogEvents_Player( "requested docking clearance and "+message);
}

this.playerStartedJumpCountdown = function(type, seconds) {
	this.$LogEvents_Player( "started "+seconds+" seconds "+type+" jump countdown");
}

this.playerCancelledJumpCountdown = function() {
	this.$LogEvents_Player( "cancelled jump countdown");
}

this.playerJumpFailed = function(reason) {
	this.$LogEvents_Player( "jump failed due to "+reason);
}

this.shipWillEnterWitchspace = function(cause) {
	this.$LogEvents_Player( "will enter witchspace due to "+cause);
}

this.shipWillExitWitchspace = function() {
	this.$LogEvents_Player( "will exit witchspace");
}

this.shipExitedWitchspace = function() {
	this.$LogEvents_Player( "exited from witchspace");
}

this.playerEnteredNewGalaxy = function(galaxyNumber) {
	this.$LogEvents_Player( "entered "+galaxyNumber+". galaxy");
}

this.shipEnteredStationAegis = function(station) {
	this.$LogEvents_Player( "entered to the aegis of", station);
}

this.shipExitedStationAegis = function(station) {
	this.$LogEvents_Player( "exited from aegis of", station);
}

this.shipEnteredPlanetaryVicinity = function(planet) {
	this.$LogEvents_Player( "entered to the vicinity of "+planet.toString());
}

this.shipExitedPlanetaryVicinity = function(planet) {
	this.$LogEvents_Player( "exited from the vicinity of "+planet.toString());
}

this.shipApproachingPlanetSurface = function(planet) {
	this.$LogEvents_Player( "approaching the surface of "+planet.toString());
}

this.shipLeavingPlanetSurface = function(planet) {
	this.$LogEvents_Player( "leaving the surface of "+planet.toString());
}

this.alertConditionChanged = function(newCondition, oldCondition) {
	this.$LogEvents_Player( "alert condition changed from "+oldCondition+" to "+newCondition);
}

this.playerTargetedMissile = function(missile) {
	this.$LogEvents_Player( "targeted missile "+missile.name );
}

this.shipAttackedOther = function(other) {
	this.$LogEvents_Player( "attacked", other, "who has "+this.$LogEvents_NPCLeft( other ) );
}

this.shipAttackedWithMissile = function(missile, whom) {
	this.$LogEvents_Player( "attacked with "+missile.name+" from", whom );
}

this.shipBeingAttacked = function(whom) {
	this.$LogEvents_Player( "attacked by", whom, this.$LogEvents_PlayerLeft() );
}

this.shipBeingAttackedByCloaked = function() {
	this.$LogEvents_Player( "attacked by a cloaked ship "+this.$LogEvents_PlayerLeft() );
}

this.shipKilledOther = function(whom, damageType) {
	this.$LogEvents_Player( "killed", whom, "with "+damageType);
}

this.shipTargetDestroyed = function(target) {
	this.$LogEvents_Player( "target", target, "is destroyed");
}

this.shipDied = function(whom, why) {
	this.$LogEvents_Player( "got "+why+" from", whom, "and died!");
}

this.shipFiredMissile = function(missile, target) {
	this.$LogEvents_Player( "fired missile "+missile.name+" to", target);
}

this.shipTargetLost = function(target) {
	if( target ) this.$LogEvents_Player( "lost lock on", target);
}

this.shipTargetCloaked = function() {
	this.$LogEvents_Player( "target cloaked");
}

this.equipmentDamaged = function(equipment) {
	if( equipment.isVisible ) //to avoid HUD control equipments
		this.$LogEvents_Player( equipment.toString()+" damaged" );
}

this.equipmentDestroyed = function(equipment) {
	if( equipment.isVisible ) //to avoid HUD control equipments
	this.$LogEvents_Player( equipment.toString()+" destroyed" );
}

this.equipmentRepaired = function(equipment){
	if( equipment.isVisible ) //to avoid HUD control equipments
		this.$LogEvents_Player( equipment.toString()+" repaired" );
}

this.playerBoughtCargo = function(commodity, units, price) {
	this.$LogEvents_Player( "bought "+units+" "
		+expandDescription("[commodity-name "+commodity+"]")
		+" for "+(price/10)+" credits");
}

this.playerBoughtEquipment = function(equipment) {
	this.$LogEvents_Player( "bougth "+equipment.toString() );
}

this.playerBoughtNewShip = function(ship) {
	this.$LogEvents_Player( "bought new ship:", ship );
}

this.playerSoldCargo = function(commodity, units, price) {
     	this.$LogEvents_Player( "sold "+units+" "
		+expandDescription("[commodity-name "+commodity+"]")
		+" for "+(price/10)+" credits");
}

this.shipScoopedFuel = function() {
	this.$LogEvents_Player( "scooped 0.1 LY fuel" );
}

this.shipScoopedOther = function(whom) {
	this.$LogEvents_Player( "scooped", whom );
}

this.compassTargetChanged = function(whom, mode) {
	this.$LogEvents_Player( "compass targeted", whom, "in mode "+mode );
}

this.dayChanged = function(newday) {
	this.$LogEvents_Player( "new day "+newday );
}

this.guiScreenChanged = function(to, from) {
	this.$LogEvents_Player( "gui screen changed from "+from+" to "+to );
}

this.guiScreenWillChange = function(to, from) {
	this.$LogEvents_Player( "gui screen will change from "+from+" to "+to );
}

this.missionChoiceWasReset= function() {
	this.$LogEvents_Player( "mission choice was reset" );
}

this.missionScreenEnded = function() {
	this.$LogEvents_Player( "mission screen ended" );
}

this.missionScreenOpportunity= function() {
	this.$LogEvents_Player( "mission screen opportunity" );
}

this.reportScreenEnded = function() {
	this.$LogEvents_Player( "report screen ended" );
}

this.shipCollided = function(otherShip)
{
	this.$LogEvents_Player( "collided with", otherShip );
}

this.shipSpawned = function(ship) {
	this.$LogEvents_Ships[ this.$LogEvents_Ships.length ] = ship;
	if( !this.$LogEvents_Timer ) //give some time to run all shipSpawned before get ShipVersion
		this.$LogEvents_Timer = new Timer(this, this.$LogEvents_Timed, 0.1, 0);
}

this.shipLaunchedEscapePod = function(escapepod)
{
	this.$LogEvents_Player( "launched Escape Pod" );
}

this.viewDirectionChanged = function(viewString) {
	this.$LogEvents_Player( viewString );
}


//LogEvents functions
this.$LogEvents_NPCLeft = function( target ) {
	if( !target ) return("unknown energy");
	var sh = "";
	if( worldScripts["customshields"] && target && target.script
		&& target.script.customshieldsforwardshieldlevel ) { //asteroids has not shield
		sh = Math.round( target.script.customshieldsforwardshieldlevel ) + "+" +
			Math.round( target.script.customshieldsaftshieldlevel ) + " shield and ";
	}
	return( sh + Math.round( target.energy ) + " energy" );
}

this.$LogEvents_Player = function( message1, target, message2, nolosttarget ) { //with target
	if( worldScripts["logevents"].$LogEvents_On ) {
		var n = "";
		if( typeof( target ) != 'undefined' ) //give "lost target" message only if null
			n = worldScripts["logevents"].$LogEvents_TargetName( target );
		var s = "";
		if( n && n.length > 0 ) s += " "+n;
		if( message2 && message2.length > 0 ) s += " " + message2;
		if( message1 ) message1 = " " + message1;
		else message1 = "";
		log( this.$LogEvents_Prefix, "Player" + message1 + s );
	}
}

this.$LogEvents_PlayerLeft = function() {
	if( player.ship ) return( Math.round( player.ship.forwardShield ) + "+" +
		+ Math.round( player.ship.aftShield ) + " shield and "
		+ Math.round( player.ship.energy ) + " energy left");
}

this.$LogEvents_TargetName = function( target ) { //support for ShipVersion OXP to log ship version also
	if( !target ) return("lost target");
	var n = target.name;
	if( target.script && target.script.$Detectors_Origname )
		n = target.script.$Detectors_Origname;
	return( n + " " + target.entityPersonality );
}

this.$LogEvents_Timed = function() {
	for(var i = 0; i < this.$LogEvents_Ships.length; i++ ) {
		var ship = this.$LogEvents_Ships[i];
		if( !ship.isVisualEffect && ship.isVisible && ship.name.indexOf("customshields") == -1 ) {
			var d = "unknown";
			if( player.ship && player.ship.position && ship && ship.position ) //no ship when died
				d = Math.round( player.ship.position.distanceTo( ship.position ) /1000 );
			var o = "";
			var owner = this.$LogEvents_Ships[i].owner;
			if( owner ) o = " from " + this.$LogEvents_TargetName( owner );
			log( this.$LogEvents_Prefix,
			     this.$LogEvents_TargetName( ship ) + o + " spawned at " + d + " km" );
		}
	}
	this.$LogEvents_Ships = []; //start new array
	this.$LogEvents_Timer.stop();
	delete this.$LogEvents_Timer;
}
