"use strict";
this.name        = "hudreq";
this.author      = "Norby";
this.copyright   = "2013 Norbert Nagy";
this.licence     = "CC BY-NC-SA 3.0";
this.description = "Requests for new core game features to support OXP improvements.";
this.version     = "1.0";

//demo communication messages after answers, other js can overwrite these arrays
//must place all ships with messages into the first line also to work
//and place identification code into the _GetShipEQ function
this.$HUDReq_Comm = ["EQ_HUD_BUOYREQ","EQ_HUD_CORIOLISREQ"];
this.$HUDReq_Comm["EQ_HUD_BUOYREQ"] = [ { startmenu:1,
	leftanim:[1,1,1,1,1,1,2,3,2,1,1,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,2,3,3,3,3,1,1,1,1,1,1] }, //animation series
	//menu 1
	[{text:"Yes!", after:"Please confirm!", next:3}, //next menu number, negative:exit but recallable, null=close talk
	{text:"No.", after:"No!", next:0},
	{text:"Not now.", after:"Maybe later.", next:-1}],
	//menu 2 is empty here to fit into the combined hudreq.plist with the menu of the buoyreq.js
	[],
	//menu 3
	[{text:"Yes.", after:"Super! Then please imlpement the requested features."},
	{text:"No, I choose another.", after:"Then I ask again!", next:1},
	{text:"No, I want to leave.", after:"What a pity.", next:-1} ] ];
this.$HUDReq_Comm["EQ_HUD_CORIOLISREQ"] = this.$HUDReq_Comm["EQ_HUD_BUOYREQ"]; //demo for the Voice label only
this.$HUDReq_LogAnswers = true; //turn off means no answer logging

//internal variables, should not touch these
this.$HUDReq_ConnectAt = 4; //wait time to connecting in 0.25 seconds (4 means 1 seconds)
this.$HUDReq_ClearedTarget = false; //to help lock the Station activate do scan after released the Buoy target lock
this.$HUDReq_DC = 0; //debug counter
this.$HUDReq_GetShipEQs = []; //will store all GetShipEQ fuctions including in other jses also
this.$HUDReq_Menu = 0; //number of the actual HUD menu
this.$HUDReq_Line = 0; //number of the selected menu item in the actual menu
this.$HUDReq_RadioCall = false; //flag if the target is called by radio
this.$HUDReq_Ship = null; //the last targeted ship (store after lost target also)
this.$HUDReq_ShipEQ = null; //name of the eq which contains the picture of the targeted ship
this.$HUDReq_SoundNext = null; //beep
this.$HUDReq_SoundNo = null; //boop
this.$HUDReq_SoundScan = null; //radio scan
this.$HUDReq_SoundStay = null; //sell
this.$HUDReq_SoundStep = null; //guiclick
this.$HUDReq_SoundYes = null; //buy
this.$HUDReq_Timer = []; //0:connecting, 1:marker animation, 2-3:left pic anim, 4-5: right pic anim
this.$HUDReq_TimerC = []; //counters for the timers (3:left pic frame counter, 5:right pic frame counter)
this.$HUDReq_Timers = 5; //how many timer used by this script and need to clear if close the HUD menu

//world script events
this.startUp = function() {
	this.$HUDReq_SoundNext = new SoundSource;
	this.$HUDReq_SoundNext.sound = "beep.ogg";
	this.$HUDReq_SoundNext.loop = false;
	this.$HUDReq_SoundNext.repeatCount = 0;
	this.$HUDReq_SoundNo = new SoundSource;
	this.$HUDReq_SoundNo.sound = "boop.ogg";
	this.$HUDReq_SoundNo.loop = false;
	this.$HUDReq_SoundNo.repeatCount = 0;
	this.$HUDReq_SoundScan = new SoundSource;
	this.$HUDReq_SoundScan.sound = "radioscan.ogg";
	this.$HUDReq_SoundScan.loop = false;
	this.$HUDReq_SoundScan.repeatCount = 0;
	this.$HUDReq_SoundStay = new SoundSource;
	this.$HUDReq_SoundStay.sound = "sell.ogg";
	this.$HUDReq_SoundStay.loop = false;
	this.$HUDReq_SoundStay.repeatCount = 0;
	this.$HUDReq_SoundStep = new SoundSource;
	this.$HUDReq_SoundStep.sound = "guiclick.ogg";
	this.$HUDReq_SoundStep.loop = false;
	this.$HUDReq_SoundStep.repeatCount = 0;
	this.$HUDReq_SoundYes = new SoundSource;
	this.$HUDReq_SoundYes.sound = "buy.ogg";
	this.$HUDReq_SoundYes.loop = false;
	this.$HUDReq_SoundYes.repeatCount = 0;
}

this.equipmentDamaged = this.equipmentDestroyed = function(equipment) {
	if(equipment == "EQ_HUDRADIO") {
		var m = "Radio is trashed, buy a new one at any Station.";
		log("HUDReq", m);
		player.commsMessage(m, 5);
		player.ship.removeEquipment("EQ_HUDRADIO"); 
	} else if( !equipment.isVisible ) {
		player.ship.setEquipmentStatus( equipment, "EQUIPMENT_OK" );//fix virtual equipments
//		log("HUDReq", equipment+" fixed");//debug
		player.ship.takeInternalDamage(); //but damage another
	}
}

this.guiScreenChanged = function(to, from) { //hide HUD menu at status screens
//	player.consoleMessage(from+" -> "+to);//debug	
	if( !worldScripts["hudreq"].$HUDReq_ShipEQ || player.ship.docked ) return; //no target or docked, hiding not needed
	//unfortunately option screen (F2) can not be catched here during pause because event handlers are paused also
	var g = [ "GUI_SCREEN_OPTIONS", "GUI_SCREEN_STATUS", "GUI_SCREEN_SHORT_RANGE_CHART",
		"GUI_SCREEN_SYSTEM_DATA", "GUI_SCREEN_MARKET" ];
	if( g.indexOf(to) > -1 ) {
		worldScripts["hudreq"].$HUDReq_HideTarget( worldScripts["hudreq"].$HUDReq_ShipEQ );
		worldScripts["hudreq"].$HUDReq_HideMenu(); //hide HUD menu if any
	} else if( to == "GUI_SCREEN_MAIN" && worldScripts["hudreq"].$HUDReq_Menu > 0 ) { //unhide HUD menu if any
		worldScripts["hudreq"].$HUDReq_ShowTarget( worldScripts["hudreq"].$HUDReq_ShipEQ ); //unhide target
		if( worldScripts["hudreq"].$HUDReq_Line < 1 ) worldScripts["hudreq"].$HUDReq_Line = 1; //for sure
		worldScripts["hudreq"].$HUDReq_UnHideMenu(); //show menu again
	}
}

this.shipTargetAcquired = function(target) {
//	player.consoleMessage(target.name+" acquired dc"+(worldScripts["hudreq"].$HUDReq_DC++));//debug
	worldScripts["hudreq"].$HUDReq_Ship = target; //the targeted ship (store after lost target also)
	worldScripts["hudreq"].$HUDReq_HideTargetOuterFrame(); //clear animated frame (bugfix if reident)
	worldScripts["hudreq"].$HUDReq_RadioCall = false; //not recalled, avoid "no message" at every targeting
	worldScripts["hudreq"].$HUDReq_Acquired( target );
}

this.shipTargetLost = this.shipWillDockWithStation = this.shipWillEnterWitchspace = function(target) {
//	var t = "target"; if(target) t = target.name;
//	player.consoleMessage(t+" lost dc"+(worldScripts["hudreq"].$HUDReq_DC++));//debug
	worldScripts["hudreq"].$HUDReq_HideTarget( worldScripts["hudreq"].$HUDReq_ShipEQ );
	worldScripts["hudreq"].$HUDReq_ExitFromHUDReq();
}

this.shipWillLaunchFromStation = function() {
	if( !worldScripts["hudmenu"] && player.ship.hud != "hudreq.plist") { //hudmenu will be the new version
		player.ship.hud = "hudreq.plist";
		//the next lines will not in the HUDMenu OXP to must buy Radio and do not send help message
		worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDRADIO" ); //award only once
		player.consoleMessage("Select Radio (N) then activate (n) to choose and mode (b) to confirm", 10);
		worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDWRITABLE_LEGEND" );
		player.ship.hudlegends["writable legend"].text="Thank you very much for making script-writable legends!";
	}
}


//HUDReq functions
this.$HUDReq_Acquired = function( target ) {
	var radiocall =  worldScripts["hudreq"].$HUDReq_RadioCall;
	worldScripts["hudreq"].$HUDReq_RadioCall = false; //for sure
	var eq = null;
	if( target ) {	//check if the target ship has picture
		eq = worldScripts["hudreq"].$HUDReq_GetEQ( target );
	}
	if( eq ) { //show ship picture (will remain after talk until targeted)
//		player.consoleMessage(worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq )+" "+eq);//debug
		worldScripts["hudreq"].$HUDReq_Remove( worldScripts["hudreq"].$HUDReq_ShipEQ ); //if any
		worldScripts["hudreq"].$HUDReq_ShipEQ = eq;
		worldScripts["hudreq"].$HUDReq_ShowTarget( eq ); 
	} else { //no picture for the target so clear the old one
		worldScripts["hudreq"].shipTargetLost(target);
	}
	
	//check if there is a message pddattached to the target
	if( worldScripts["hudreq"].$HUDReq_Menu != 0 ) return; //retarget during menu walk, skip
//	player.consoleMessage(target.name+"*"+worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq )
//		+" "+eq+" dc"+(worldScripts["hudreq"].$HUDReq_DC++));//debug
	var c = worldScripts["hudreq"].$HUDReq_Comm[eq]; //communication array
	var r = 0;
	if( c && c[0] && c[0].restartcounter ) r = c[0].restartcounter;
//	player.consoleMessage(r);//debug
	if( target && worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq ) > -1
		&& c && c[0] && c[0].startmenu > 0 && r >= 0) {  //no message if target picture only or restartcounter is active
		if( player.alertCondition >= 3 && !radiocall ) {
			player.consoleMessage("Use your Radio if you want to talk in Red Alert.");
			return;
		}
		if( worldScripts["hudreq"].$HUDReq_Timer[0] ) { //speed up connecting
			worldScripts["hudreq"].$HUDReq_Timer[0].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[0];
			worldScripts["hudreq"].$HUDReq_TimerC[0] = worldScripts["hudreq"].$HUDReq_ConnectAt; //go to end
			worldScripts["hudreq"].$HUDReq_Timed();
		} else {
			worldScripts["hudreq"].$HUDReq_ClearTimers();
			player.ship.removeEquipment("EQ_HUDVOICE"); //for sure
			worldScripts["hudreq"].$HUDReq_TimerC[0] = 0;
			worldScripts["hudreq"].$HUDReq_Timer[0] =
				new Timer(this, worldScripts["hudreq"].$HUDReq_Timed, 0, 0.25); //wait to connect
			var n = worldScripts["hudreq"].$HUDReq_TargetName(target); //shipversion support
			player.consoleMessage("Connecting "+n+"...");
		}	
	} else {
		if( eq ) {
			var n = target.name;
			if( worldScripts["detectors"] && target.script ) n = target.script.$Detectors_Origname;
			if( worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq ) > -1 //no message if target picture only
				&& c && c[0] && r < 1 ) {
				var s = c[0].closedmsg;
				if( r && r > -10 ) {//restart max. at the 10+1.call
					if( s && s.length > 0 ) player.consoleMessage(n+": "+s, 5); //after closed talk
					c[0].restartcounter--; //counter to restart
				} else if( r == -10 ) //no restart if < -10
					c[0].restartcounter = 1; //restarted by repeated calls
			} else if( radiocall ) {
				player.consoleMessage("No message from "+n, 5); //only if called by Radio
			}
		}
		worldScripts["hudreq"].$HUDReq_ExitFromHUDReq();
	}
}

this.$HUDReq_Award = function( eq, damaged ) {
	if( eq && EquipmentInfo.infoForKey( eq ) && !worldScripts["hudreq"].$HUDReq_Exists( eq ) ) {
		player.ship.awardEquipment( eq );
		if( damaged ) player.ship.setEquipmentStatus( eq, "EQUIPMENT_DAMAGED" );
	}
}

this.$HUDReq_ClearTarget = function() {
	worldScripts["hudreq"].$HUDReq_ClearedTarget = true; //activate button will start new scan also
	//do not set player.ship.target = null; to avoid that the active ident relock the Buoy
	worldScripts["hudreq"].shipTargetLost();
}

this.$HUDReq_ClearTimers = function() {
	for(var i = 0; i <= worldScripts["hudreq"].$HUDReq_Timers; i++) {
		worldScripts["hudreq"].$HUDReq_TimerC[i] = 0; //reset counters
		if( worldScripts["hudreq"].$HUDReq_Timer[i] ) {
			worldScripts["hudreq"].$HUDReq_Timer[i].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[i];
		}
	}
}

this.$HUDReq_ExitFromHUDReq = function() {
	worldScripts["hudreq"].$HUDReq_HideMenu(); //hide HUD menu if any
	worldScripts["hudreq"].$HUDReq_ClearTimers();
	worldScripts["hudreq"].$HUDReq_Menu = 0;
	worldScripts["hudreq"].$HUDReq_Line = 0;
}

this.$HUDReq_Exists = function( eq ) {
	if( eq && player.ship.equipmentStatus( eq ) == "EQUIPMENT_DAMAGED" //HUD eqs started as damaged
		|| player.ship.equipmentStatus( eq ) == "EQUIPMENT_OK" ) return(true);
	return(false);
}

this.$HUDReq_GetEQ = function( target ) { //call all GetShipEQ fuctions including in other jses also
	if( !target || !target.isValid || !player.ship.isValid ) return( null );
	var eq = null;
	var len = worldScripts["hudreq"].$HUDReq_GetShipEQs.length;
	if( len > 0 ) {
		for(var i = 0; !eq && i < len; i++) eq = worldScripts["hudreq"].$HUDReq_GetShipEQs[i]( target );
	} else eq = worldScripts["hudreq"].$HUDReq_GetShipEQ( target ); //call the internal demo function only if no other js
	return( worldScripts["hudreq"].$HUDReq_GetShipEQ2( target, eq ) ); //call the fallback code also
}

this.$HUDReq_GetShipEQ = function( target ) { //determine to which ship has messages, will be override by other js
	var eq = null; //place here the identification code of the ships with messages (and pictures if not in _GetShipEQ2)
	if( !eq && target.dataKey == "buoy" && system.name == "Lave" ) eq = "EQ_HUD_BUOYREQ"; //with message
	if( !eq && target.dataKey == "coriolis-station" ) eq = "EQ_HUD_CORIOLISREQ"; //with message
	return(eq);
}

this.$HUDReq_GetShipEQ2 = function( target, eq ) { //provide fallback to help merge with other js
	if( eq ) return(eq);
	var k = target.dataKey;
	if( !eq && ( k == "buoy" || k == "buoy-witchpoint" ) ) eq = "EQ_HUD_BUOY"; //picture as buoy_lave but no message
	if( !eq && k == "coriolis-station" ) eq = "EQ_HUD_CORIOLIS"; //picture only
	if( !eq && k == "rock-hermit" ) eq = "EQ_HUD_ROCKHERMIT"; //picture only
	if( !eq && k == "thargoid" ) eq = "EQ_HUD_THARGOID"; //picture only
	if( !eq && k == "tharglet" ) eq = "EQ_HUD_THARGLET"; //picture only
	if( !eq && ( k == "viper" || k == "viper-pursuit") ) eq = "EQ_HUD_VIPER"; //picture only
	if( !eq ) eq = "EQ_HUD_OOLITE"; //fallback, please make nice pictures to all targetable entities
//or code visual effect ships (to do not collide) with repositioning before player and with the orientation of the target
//there are some nice but very complex example in the Vector OXP which using shaders and make HUD overlays
//	player.consoleMessage(worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq )+" "+eq);//debug
	return(eq);
}

this.$HUDReq_HideTarget = function( eq ) {
	if( eq ) {
		player.ship.removeEquipment( eq );
		worldScripts["hudreq"].$HUDReq_HideTargetFrame();
		player.ship.removeEquipment("EQ_HUDCONNECTING"); //for sure and bugfix
		player.ship.removeEquipment("EQ_HUDVOICE"); //for sure and bugfix
	}	
}

this.$HUDReq_HideTargetFrame = function() {
	player.ship.removeEquipment("EQ_HUDSHIPFRAME0");
//	player.consoleMessage("removed EQ_HUDSHIPFRAME0"); //debug
	player.ship.removeEquipment("EQ_HUDSHIPFRAME1");
	worldScripts["hudreq"].$HUDReq_HideTargetOuterFrame();
}

this.$HUDReq_HideTargetOuterFrame = function() {
	player.ship.removeEquipment("EQ_HUDSHIPFRAME2");
	player.ship.removeEquipment("EQ_HUDSHIPFRAME3");
	for(var i = 1; EquipmentInfo.infoForKey("EQ_HUDSHIPFRAME2_"+i); i++ )
		worldScripts["hudreq"].$HUDReq_Remove( "EQ_HUDSHIPFRAME2_"+i );
	for(var i = 1; EquipmentInfo.infoForKey("EQ_HUDSHIPFRAME3_"+i); i++ )
		worldScripts["hudreq"].$HUDReq_Remove( "EQ_HUDSHIPFRAME3_"+i );
}

this.$HUDReq_HideMenu = function() {
	worldScripts["hudreq"].$HUDReq_HideTargetOuterFrame();
	player.ship.removeEquipment("EQ_HUDCONNECTING");
	player.ship.removeEquipment("EQ_HUDVOICE");
	for(var i = 0; i <= worldScripts["hudreq"].$HUDReq_Timers; i++) { //stop but do not delete
		if( worldScripts["hudreq"].$HUDReq_Timer[i] ) worldScripts["hudreq"].$HUDReq_Timer[i].stop();
	}
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ; //not known the last anim so remove all
	for(var i = 1; EquipmentInfo.infoForKey(eq+"_"+i); i++ )
		player.ship.removeEquipment(eq+"_"+i); //remove talking picture with animations
	var oldmenu = worldScripts["hudreq"].$HUDReq_Menu;
	if( oldmenu < 1 ) return;
	for(i = 1; EquipmentInfo.infoForKey(eq+"_TALK"+oldmenu+"_"+i); i++ ) //hide talk lines
		player.ship.removeEquipment(eq+"_TALK"+oldmenu+"_"+i);
	for(i = 1; EquipmentInfo.infoForKey(eq+"_ANSWER"+oldmenu+"_"+i); i++ ) {
		player.ship.removeEquipment(eq+"_ANSWER"+oldmenu+"_"+i); //hide answer lines
		if(EquipmentInfo.infoForKey(eq+"_MARKER"+oldmenu+"_"+i))
			player.ship.removeEquipment(eq+"_MARKER"+oldmenu+"_"+i); //hide answer selectors
		for(var j = 1; EquipmentInfo.infoForKey(eq+"_MARKER"+oldmenu+"_"+i+"_"+j); j++ )
			player.ship.removeEquipment(eq+"_MARKER"+oldmenu+"_"+i+"_"+j); //hide animated markers
		if(EquipmentInfo.infoForKey(eq+"_PIC"+oldmenu+"_"+i))
			player.ship.removeEquipment(eq+"_PIC"+oldmenu+"_"+i); //hide right pictures
		for(var j = 1; EquipmentInfo.infoForKey(eq+"_PIC"+oldmenu+"_"+i+"_"+j); j++ )
			player.ship.removeEquipment(eq+"_PIC"+oldmenu+"_"+i+"_"+j);  //hide right animated pictures
	}
	worldScripts["hudreq"].$HUDReq_HidePicFrame();
}

this.$HUDReq_HidePicFrame = function() {
	player.ship.removeEquipment("EQ_HUDPICFRAME0"); //remove green right frame
	player.ship.removeEquipment("EQ_HUDPICFRAME1"); //remove yellow right frame
	player.ship.removeEquipment("EQ_HUDPICFRAME2"); //remove animated green right frame
	player.ship.removeEquipment("EQ_HUDPICFRAME3"); //remove animated yellow right frame
	for(var i = 1; EquipmentInfo.infoForKey("EQ_HUDPICFRAME2_"+i); i++ )
		worldScripts["hudreq"].$HUDReq_Remove( "EQ_HUDPICFRAME2_"+i );
	for(var i = 1; EquipmentInfo.infoForKey("EQ_HUDPICFRAME3_"+i); i++ )
		worldScripts["hudreq"].$HUDReq_Remove( "EQ_HUDPICFRAME3_"+i );
}

this.$HUDReq_UnHideMenu = function() {
	for(var i = 0; i <= worldScripts["hudreq"].$HUDReq_Timers; i++) { //continue timers
		if( worldScripts["hudreq"].$HUDReq_Timer[i] ) worldScripts["hudreq"].$HUDReq_Timer[i].start();
	}
	worldScripts["hudreq"].$HUDReq_ShowMenuLine( worldScripts["hudreq"].$HUDReq_Menu,
		worldScripts["hudreq"].$HUDReq_Line ); //show menu again and mark the recently selected line
}

this.$HUDReq_Log = function( message1, other, message2 ) { //logevents.js will do this
	if( worldScripts["hudreq"].$HUDReq_LogAttacks ) {
		var n = worldScripts["hudreq"].$HUDReq_TargetName(other); //shipversion support
		var p = worldScripts["hudreq"].$HUDReq_TargetName(player.ship); //shipversion support
		var s = "";
		if( n && n.length > 0 ) s += " "+n;
		if( message2 && message2.length > 0 ) s += " "+message2;
		log( "Player "+p, message1 + s );
	}
}

this.$HUDReq_Merge = function( comm, getshipeq ) { //merge the comm arrays and the GetShipEQ function from other js
	var len = worldScripts["hudreq"].$HUDReq_Comm.length;
	for(var i = 0; i < comm.length; i++ ) {
		var eq = comm[i];
		if( worldScripts["hudreq"].$HUDReq_Comm.indexOf(eq) < 0 ) //add to the main array or replace it
			worldScripts["hudreq"].$HUDReq_Comm[worldScripts["hudreq"].$HUDReq_Comm.length]=eq;
		worldScripts["hudreq"].$HUDReq_Comm[eq] = comm[eq];
	} //store the other GetShipEQ for GetEQ
	worldScripts["hudreq"].$HUDReq_GetShipEQs[worldScripts["hudreq"].$HUDReq_GetShipEQs.length] = getshipeq;
}

this.$HUDReq_Remove = function( eq ) {
	if( eq && EquipmentInfo.infoForKey( eq ) && worldScripts["hudreq"].$HUDReq_Exists( eq ) )
		player.ship.removeEquipment( eq );
}

this.$HUDReq_Scan = function( who ) { //find targets in the scanner with messages
	var eq = worldScripts["hudreq"].$HUDReq_GetEQ( who );
	if( worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq ) > -1 ) return true;
	return false;
}

this.$HUDReq_SetLine = function( menu, line ) { //move the marker and highlight the frame of the picture
	if(menu < 1) menu = 1;
	if(line < 1) line = 1;
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	var oldmenu = worldScripts["hudreq"].$HUDReq_Menu;
	var oldline = worldScripts["hudreq"].$HUDReq_Line;
	if( oldmenu > 0 && oldline > 0 ) {
		worldScripts["hudreq"].$HUDReq_Remove( eq+"_MARKER"+oldmenu+"_"+oldline ); //remove old marker
		for(var j = 1; EquipmentInfo.infoForKey(eq+"_MARKER"+oldmenu+"_"+oldline+"_"+j); j++ )
			player.ship.removeEquipment(eq+"_MARKER"+oldmenu+"_"+oldline+"_"+j);
		worldScripts["hudreq"].$HUDReq_Remove( eq+"_PIC"+oldmenu+"_"+oldline ); //hide old right picture
		for(var j = 1; EquipmentInfo.infoForKey(eq+"_PIC"+oldmenu+"_"+oldline+"_"+j); j++ )
			player.ship.removeEquipment(eq+"_PIC"+oldmenu+"_"+oldline+"_"+j); //hide old right animation
	}

	worldScripts["hudreq"].$HUDReq_Menu = menu; //set to new menu only here, not before
	worldScripts["hudreq"].$HUDReq_Award( eq+"_MARKER"+menu+"_"+line ); //set marker to the new line
	worldScripts["hudreq"].$HUDReq_Award( eq+"_MARKER"+menu+"_"+line+"_1" ); //animated marker
//	player.consoleMessage("setline "+eq+"_MARKER"+menu+"_"+line); //debug

	worldScripts["hudreq"].$HUDReq_HidePicFrame();
	var l = worldScripts["hudreq"].$HUDReq_Comm[eq][menu][line-1];
	switch( l.rfcolor ) { //right frame color, 1:green, 2:anim.green, 3:yellow, 4:anim.yellow
		case "anim_yellow":
		case 4: worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDPICFRAME3" ); //no break!
		case "yellow":
		case 3: worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDPICFRAME1" ); //yellow inner frame
			break;
		case "anim_green":
		case 2: worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDPICFRAME2" );//no break!
		case "green":
		case 1: worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDPICFRAME0" ); //green inner frame
	}
	if( l.rfcolor ) { //right frame means right picture is present also
		worldScripts["hudreq"].$HUDReq_Award( eq+"_PIC"+menu+"_"+line ); //show right picture
		worldScripts["hudreq"].$HUDReq_Award( eq+"_PIC"+menu+"_"+line+"_1" ); //animated right picture
	}

	worldScripts["hudreq"].$HUDReq_HideTargetOuterFrame(); //inner target frame must be remain!
	worldScripts["hudreq"].$HUDReq_Line = line; //save marker position
	var f = l.next;
//	player.consoleMessage(f);//debug
	if( f == null || typeof( f ) == 'undefined' ) { //close talk, means good exit
		player.ship.removeEquipment("EQ_HUDSHIPFRAME3");//remove yellow outer frame
		worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDSHIPFRAME2" ); //green outer frame
	} else if( f < 0 ) { //bad exit
		player.ship.removeEquipment("EQ_HUDSHIPFRAME2");//remove green outer frame
		worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDSHIPFRAME3" ); //yellow outer frame
	} else { //stay in, go to next menu
		player.ship.removeEquipment("EQ_HUDSHIPFRAME2");//remove yellow outer frame
		player.ship.removeEquipment("EQ_HUDSHIPFRAME3");//remove green outer frame
	}
	worldScripts["hudreq"].$HUDReq_StartRightAnim();//right animation, must set $HUDReq_Line before call
}

this.$HUDReq_ShowMenu = function( menu ) { //show new menu and set to line 1
	worldScripts["hudreq"].$HUDReq_ShowMenuLine( menu, 1 );
}

this.$HUDReq_ShowMenuLine = function( menu, line ) { //show a menu and set to the given line
	if( menu == 0 ) { //will remain in this menu
		worldScripts["hudreq"].$HUDReq_SoundStay.play();
		return;
	}
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	if( menu == null || typeof( menu ) == 'undefined' || menu < 0 ) { //exit from talk
		var z = worldScripts["hudreq"].$HUDReq_Comm[eq][0]; //0. menu line
		if( menu < 0 ) {
			worldScripts["hudreq"].$HUDReq_SoundNo.play();
			z.startmenu=Math.abs(menu); //show the abs(menu) when reconnect
		} else {
			worldScripts["hudreq"].$HUDReq_SoundYes.play();
			var r = z.recalls; //restart after how may calls
//			player.consoleMessage(r);//debug
			if( r >= 2 && r <= 11 ) z.restartcounter = Math.floor(r)-12;
			else if( r > 11 ) z.restartcounter = -11; //never restart
			else if( r < 2 ) z.restartcounter = -10; //min. 2 calls to restart
			else z.restartcounter = 0; //close the talk and restart immediately when called
		}
		worldScripts["hudreq"].$HUDReq_ExitFromHUDReq(); //clear menu and exit
		return;
	}

	var oldmenu = worldScripts["hudreq"].$HUDReq_Menu;
	if( oldmenu > 0 ) {
		var sm = worldScripts["hudreq"].$HUDReq_Comm[eq][0].startmenu;
		if( typeof( sm ) == 'undefined' ) sm = 1; //to help a bit if start menu number not present
		if( menu != sm ) worldScripts["hudreq"].$HUDReq_SoundNext.play(); //no sound at first menu
	}
	for(var i = 1; EquipmentInfo.infoForKey(eq+"_TALK"+oldmenu+"_"+i); i++ ) //hide old talk lines
		player.ship.removeEquipment(eq+"_TALK"+oldmenu+"_"+i);
	for(i = 1; EquipmentInfo.infoForKey(eq+"_ANSWER"+oldmenu+"_"+i); i++ ) //hide old answer lines
		player.ship.removeEquipment(eq+"_ANSWER"+oldmenu+"_"+i);
	for(i = 1; EquipmentInfo.infoForKey(eq+"_MARKER"+oldmenu+"_"+i); i++ ) {//hide old answer selectors
		player.ship.removeEquipment(eq+"_MARKER"+oldmenu+"_"+i);
		for(var j = 1; EquipmentInfo.infoForKey(eq+"_MARKER"+oldmenu+"_"+i+"_"+j); j++ )
			player.ship.removeEquipment(eq+"_MARKER"+oldmenu+"_"+i+"_"+j);
	}
	for(i = 1; EquipmentInfo.infoForKey(eq+"_TALK"+menu+"_"+i); i++ ) //show talk lines
		worldScripts["hudreq"].$HUDReq_Award( eq+"_TALK"+menu+"_"+i );
	for(i = 1; EquipmentInfo.infoForKey(eq+"_ANSWER"+menu+"_"+i); i++ ) //show answer lines
		worldScripts["hudreq"].$HUDReq_Award( eq+"_ANSWER"+menu+"_"+i );
//	worldScripts["hudreq"].$HUDReq_Menu = menu; //do not set, needed as old menu holder for the SetLine function
	worldScripts["hudreq"].$HUDReq_StartLeftAnim();//left animation
	worldScripts["hudreq"].$HUDReq_SetLine( menu, line ); //show new marker and frame
}

this.$HUDReq_ShowTarget = function( eq ) { //show target picture and frame
	var framecolor = 0; //green frame color
	if( worldScripts["hudreq"].$HUDReq_Ship.target == player.ship ) framecolor = 1; //yellow frame color if hostile
	worldScripts["hudreq"].$HUDReq_ShowTarget2( eq, framecolor );
}

this.$HUDReq_ShowTarget2 = function( eq, color ) { //show target picture and frame
	if( eq ) {
		worldScripts["hudreq"].$HUDReq_Award( eq ); //the picture of the target
		var c = 0;
		if(color) c = 1; //yellow (for sure if>1)
		worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDSHIPFRAME"+c ); //inner frame around target picture
//		player.consoleMessage("EQ_HUDSHIPFRAME"+c); //debug
		player.ship.removeEquipment("EQ_HUDCONNECTING"); //for sure and bugfix
		player.ship.removeEquipment("EQ_HUDVOICE"); //for sure and bugfix
	}
}

this.$HUDReq_StartLeftAnim = function() { //start left animation
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	if( EquipmentInfo.infoForKey(eq+"_2") ) {//at least one more picture exists to do animation
		var z = worldScripts["hudreq"].$HUDReq_Comm[eq][0]; //0. menu cpntains left anim data
		if( !z.leftanim ) { //this is the place of the left animation series
			if( typeof( z.leftanim ) == 'undefined' ) z.leftanim = []; //if no series then make it (8pic/sec)
			for(var i = 1; EquipmentInfo.infoForKey(eq+"_"+i); i++) z.leftanim[i-1] = i;
		}
		worldScripts["hudreq"].$HUDReq_TimerC[2] = 0;
		if( worldScripts["hudreq"].$HUDReq_Timer[2] ) {
			worldScripts["hudreq"].$HUDReq_Timer[2].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[2];
		}
		if( worldScripts["hudreq"].$HUDReq_Timer[3] ) {
			worldScripts["hudreq"].$HUDReq_Timer[3].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[3];
		}
		worldScripts["hudreq"].$HUDReq_Timer[2] = new Timer(this,
			worldScripts["hudreq"].$HUDReq_TimedAnim, 0, 0.25);
		worldScripts["hudreq"].$HUDReq_Timer[3] = new Timer(this, 
			worldScripts["hudreq"].$HUDReq_TimedAnim, 0.125, 0.25); //double timer to earn 8pic/seconds
	}
}

this.$HUDReq_StartRightAnim = function() { //start marker and right animation
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	var m = worldScripts["hudreq"].$HUDReq_Menu;
	var l = worldScripts["hudreq"].$HUDReq_Line - 1;
	if( m < 1 || l < 0 ) return;
	if( EquipmentInfo.infoForKey(eq+"_MARKER"+m+"_"+(l+1)+"_2") //at least one more picture exists to do animation
		|| EquipmentInfo.infoForKey(eq+"_PIC"+m+"_"+(l+1)+"_2")
		|| worldScripts["hudreq"].$HUDReq_Exists( "EQ_HUDPICFRAME2" ) //animated frame
		|| worldScripts["hudreq"].$HUDReq_Exists( "EQ_HUDPICFRAME3" )
		|| worldScripts["hudreq"].$HUDReq_Exists( "EQ_HUDSHIPFRAME2" )
		|| worldScripts["hudreq"].$HUDReq_Exists( "EQ_HUDSHIPFRAME3" ) ) {
		var a = worldScripts["hudreq"].$HUDReq_Comm[eq][m][l]; //actual line
		if( !a.markeranim ) {//this is the place of the marker animation series
			if( typeof( a.markeranim ) == 'undefined' ) a.markeranim = [];  //if no series then make it (8pic/sec)
			for(var i = 1; EquipmentInfo.infoForKey(eq+"_MARKER"+m+"_"+(l+1)+"_"+i); i++) a.markeranim[i-1] = i;
		}
		if( !a.rightanim ) {//this is the place of the right animation series
			if( typeof( a.rightanim ) == 'undefined' ) a.rightanim = []; //if no series then make it (8pic/sec)
			for(var i = 1; EquipmentInfo.infoForKey(eq+"_PIC"+m+"_"+(l+1)+"_"+i); i++) a.rightanim[i-1] = i;
		}
		worldScripts["hudreq"].$HUDReq_TimerC[1] = 0; //marker counter
		worldScripts["hudreq"].$HUDReq_TimerC[3] = 0; //left pic frame counter
		worldScripts["hudreq"].$HUDReq_TimerC[4] = 0; //right pic counter
		worldScripts["hudreq"].$HUDReq_TimerC[5] = 0; //right pic frame counter
		if( worldScripts["hudreq"].$HUDReq_Timer[4] ) {  //already exists, restart animation
			worldScripts["hudreq"].$HUDReq_Timer[4].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[4];
		}
		if( worldScripts["hudreq"].$HUDReq_Timer[5] ) {
			worldScripts["hudreq"].$HUDReq_Timer[5].stop();
			delete worldScripts["hudreq"].$HUDReq_Timer[5];
		}
//		player.consoleMessage(eq+" "+m+".menu "+(l+1)+".line start right anim timer");//debug
		worldScripts["hudreq"].$HUDReq_Timer[4] = new Timer(this,
			worldScripts["hudreq"].$HUDReq_TimedAnimRight, 0, 0.25);
		worldScripts["hudreq"].$HUDReq_Timer[5] = new Timer(this,
			worldScripts["hudreq"].$HUDReq_TimedAnimRight, 0.125, 0.25); //double timer to earn 8pic/seconds
	}
}

this.$HUDReq_Step = function( whichway ) { //called from radio.js, 1=next, -1=back, 0=confirm
	worldScripts["hudreq"].$HUDReq_RadioCall = true; //used by $HUDReq_Acquired which called if target set also
	var m = worldScripts["hudreq"].$HUDReq_Menu;
	if(m < 1 ) { //reconnecting if not in menu
		if( player.ship.target && whichway == 1 //recall the current with activate only (mode always scan)
			&& !worldScripts["hudreq"].$HUDReq_ClearedTarget )  { //activate scan only if requested
			worldScripts["hudreq"].$HUDReq_SoundStep.play();
			worldScripts["hudreq"].$HUDReq_Acquired( player.ship.target );
			return; //avoid any step in the currently nonexistent menu
		}
		worldScripts["hudreq"].$HUDReq_ClearedTarget = false; //activate scan only once
		if( !worldScripts["hudreq"].$HUDReq_Timer[0] ) //no sound if speed up connecting
			worldScripts["hudreq"].$HUDReq_SoundScan.play();
		var found = null; //find targets in the scanner with messages
		var st = system.filteredEntities(this, worldScripts["hudreq"].$HUDReq_Scan,
						 player.ship, player.ship.scannerRange);
		//choose the lowest forward angle to prefer Nav Buoy and not the Station when undock
		//later maybe show a list to choose, now turn at least towards the preferred target
		var a = 0; //means angle=180 degree, the 0 degree is the PI (3.14159...)
		for(var i = 0; i < st.length; i++) {
			var an = player.ship.vectorForward.angleTo(player.ship.position.subtract(st[i].position));
//			player.consoleMessage(st[i].name+" "+Math.round(an*1000)/1000);//debug
			if( an > a ) { found = st[i]; a = an; }
		}
		if( found ) {
			if( player.ship.target == found )
				worldScripts["hudreq"].$HUDReq_Acquired( player.ship.target ); //recall
			else player.ship.target = found; //will auto call shipTargetAcquired which start the talk
		} else player.consoleMessage("Nobody want to talk with you in the scanner range.", 5);
		return; //avoid any step in the currently nonexistent menu
	}
	var l = worldScripts["hudreq"].$HUDReq_Line;
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	if(whichway == 0) { //answer confirmed: send closing message and go to the next menu (or exit if none)
//		player.consoleMessage(m+" "+l); //debug
		var c = worldScripts["hudreq"].$HUDReq_Comm[eq];
		var t = c[m][l-1].text;//answer text (to log)
		var s = c[m][l-1].after;//the message after answer
		if( s && s.length > 0 ) {
			if( c[m][l-1].comms ) { //send to comms log
				var sh = worldScripts["hudreq"].$HUDReq_Ship;
				if( sh && sh.isValid && c[m][l-1].comms != 2 )
					sh.commsMessage( s, player.ship ); //from the ship if exists
				else player.commsMessage( s, 10 ); //comms=2 means direct comm to player (not logged)
			} else player.consoleMessage( s, 10 );  //write to the console
		}
		if( worldScripts["hudreq"].$HUDReq_LogAnswers )
			log("HUDReq", eq+" "+m+" "+t+" - "+s); //please send Logs/Latest.log to norbylite@gmail.com
		var n = c[m][l-1].next; //next menu
		worldScripts["hudreq"].$HUDReq_ShowMenu( n ); //if n==0 then will remain in this menu
		if( c[0].cbf ) c[0].cbf( m, l, c[m][l-1].select ); //callback to save selection
		return; //exit to avoid SetLine
	}
	if(whichway == 1) { //next line
		l++; //if over last answer line then go back to 1
		if(!EquipmentInfo.infoForKey(eq+"_ANSWER"+worldScripts["hudreq"].$HUDReq_Menu+"_"+l))
			l = 1;
	} else { //step back a line
		l--;
		if(l < 1) { //find last answer line
			l = 1;
			while(EquipmentInfo.infoForKey(eq+"_ANSWER"+m+"_"+l)) l++;
			l--;
		}
	}
	worldScripts["hudreq"].$HUDReq_SoundStep.play();
	worldScripts["hudreq"].$HUDReq_SetLine( m, l ); //move the marker and highlight the frame of the picture
}

this.$HUDReq_TargetName = function( target ) { //support for Detectors OXP and ShipVersion OXP (log ship version)
	if( !target || !target.isValid ) return("lost target");
	var n = target.name;
	if( target.script && target.script.$Detectors_Origname )
		n = target.script.$Detectors_Origname;
	return(n);
}

this.$HUDReq_Timed = function() { //wait to connecting
	if( worldScripts["hudreq"].$HUDReq_TimerC[0] < worldScripts["hudreq"].$HUDReq_ConnectAt ) {
		worldScripts["hudreq"].$HUDReq_TimerC[0]++; //connecting counter
		if( worldScripts["hudreq"].$HUDReq_Exists( "EQ_HUDCONNECTING" ) ) //flashing label
			worldScripts["hudreq"].$HUDReq_Remove( "EQ_HUDCONNECTING" );
		else worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDCONNECTING" );
		return;
	}
	player.ship.removeEquipment("EQ_HUDCONNECTING");
	worldScripts["hudreq"].$HUDReq_TimerC[0] = 0;
	if( worldScripts["hudreq"].$HUDReq_Timer[0] ) {
		worldScripts["hudreq"].$HUDReq_Timer[0].stop();
		delete worldScripts["hudreq"].$HUDReq_Timer[0];
	}
	
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	if( EquipmentInfo.infoForKey( eq+"_1" ) ) worldScripts["hudreq"].$HUDReq_Award( eq+"_1" ); //show the talking picture
	else worldScripts["hudreq"].$HUDReq_Award( "EQ_HUDVOICE" );//only if talking picture do not exist
	var m = worldScripts["hudreq"].$HUDReq_Comm[eq][0].startmenu;
//	player.consoleMessage(m+".menu "+worldScripts["hudreq"].$HUDReq_Comm.indexOf( eq )+" "+eq);//debug
	if( typeof( m ) == 'undefined' ) m = 1; //to help a bit if start menu number not present
	if( m < 1 ) return; //do not show
	worldScripts["hudreq"].$HUDReq_ShowMenu( m ); //this will be the first menu
}

this.$HUDReq_TimedAnim = function() { //blinking eyes or so
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	var c = worldScripts["hudreq"].$HUDReq_TimerC[2]++; //left picture animation counter
	var z = worldScripts["hudreq"].$HUDReq_Comm[eq][0]; //0. menu line
	var prev = z.leftanim[c];
	if( worldScripts["hudreq"].$HUDReq_TimerC[2] >= z.leftanim.length ) {
		worldScripts["hudreq"].$HUDReq_TimerC[2] = 0; //restart
		c = -1;
	}
	var next = z.leftanim[++c];
	if( next == prev ) return; //same picture, exit
	var eqp = eq + "_" + prev;
	worldScripts["hudreq"].$HUDReq_Remove( eqp ); //hide old picture if exists
	eqp = eq + "_" + next;
	worldScripts["hudreq"].$HUDReq_Award( eqp ); //show next picture
}

this.$HUDReq_TimedAnimRight = function() { //do marker and right picture animation
	var eq = worldScripts["hudreq"].$HUDReq_ShipEQ;
	var m = worldScripts["hudreq"].$HUDReq_Menu;
	var l = worldScripts["hudreq"].$HUDReq_Line - 1;
	if( m < 1 || l < 0 ) return;

	var msfa = false; //marker synced frame anim
	var a = worldScripts["hudreq"].$HUDReq_Comm[eq][m][l]; //actual line
	if( a.markeranim && a.markeranim[0] ) { //there are marker animation
		var c = worldScripts["hudreq"].$HUDReq_TimerC[1]++; //marker animation counter
		var prev = a.markeranim[c];
		if( worldScripts["hudreq"].$HUDReq_TimerC[1] >= a.markeranim.length ) {
			worldScripts["hudreq"].$HUDReq_TimerC[1] = 0; //restart
			c = -1;
		}
		var next = a.markeranim[++c];
//		player.consoleMessage(eq+" "+m+".menu "+(l+1)+".line "+next+".markerpic "+prev+".prevmarkerpic");//debug
		if( c < 2 || next != prev ) { //skip if same picture but always show the first picture
			var eqp = eq + "_MARKER" + m + "_" + (l+1) + "_" + prev; //1_2_3 means 1. menu 2. line 3. picture
			worldScripts["hudreq"].$HUDReq_Remove( eqp ); //hide old marker picture
			eqp = eq + "_MARKER" + m + "_" + (l+1) + "_" + next;
			worldScripts["hudreq"].$HUDReq_Award( eqp ); //show next marker picture
		}
		msfa = true; //marker synced frame anim
		worldScripts["hudreq"].$HUDReq_TimedFrameLevel( "EQ_HUDSHIPFRAME2", next ); //animated left green frame
		worldScripts["hudreq"].$HUDReq_TimedFrameLevel( "EQ_HUDSHIPFRAME3", next ); //animated left yellow frame
		worldScripts["hudreq"].$HUDReq_TimedFrameLevel( "EQ_HUDPICFRAME2", next ); //animated right green frame
		worldScripts["hudreq"].$HUDReq_TimedFrameLevel( "EQ_HUDPICFRAME3", next ); //animated right yellow frame
	}

	if( a.rightanim && a.rightanim[0] ) { //there are right picture animation
		var c = worldScripts["hudreq"].$HUDReq_TimerC[4]++; //right picture animation counter
		var prev = a.rightanim[c];
		if( worldScripts["hudreq"].$HUDReq_TimerC[4] >= a.rightanim.length ) {
			worldScripts["hudreq"].$HUDReq_TimerC[4] = 0; //restart
			c = -1;
		}
		var next = a.rightanim[++c];
//		player.consoleMessage(eq+" "+m+".menu "+(l+1)+".line "+next+".rpic "+prev+".prevpic");//debug
		if( c < 2 || next != prev ) { //skip if same picture but always show the first picture
			var eqp = eq + "_PIC" + m + "_" + (l+1) + "_" + prev; //1_2_3 means 1. menu 2. line 3. picture
			worldScripts["hudreq"].$HUDReq_Remove( eqp ); //hide old picture
			eqp = eq + "_PIC" + m + "_" + (l+1) + "_" + next;
			worldScripts["hudreq"].$HUDReq_Award( eqp ); //show next picture
		}
	}
	
	if( !msfa ) { //not marker synced frame anim
		worldScripts["hudreq"].$HUDReq_TimedFrame( "EQ_HUDSHIPFRAME2", 3 ); //animated left green frame
		worldScripts["hudreq"].$HUDReq_TimedFrame( "EQ_HUDSHIPFRAME3", 3 ); //animated left yellow frame
		worldScripts["hudreq"].$HUDReq_TimedFrame( "EQ_HUDPICFRAME2", 5 ); //animated right green frame
		worldScripts["hudreq"].$HUDReq_TimedFrame( "EQ_HUDPICFRAME3", 5 ); //animated right yellow frame
	}
}

this.$HUDReq_TimedFrame = function(eq, k) { //frame animations up-down, not in sync with marker anim
	if( worldScripts["hudreq"].$HUDReq_Exists( eq ) ) {
		var c = worldScripts["hudreq"].$HUDReq_TimerC; //counter array
		if( c[k] > 0 && !EquipmentInfo.infoForKey( eq+"_"+(c[k]+1) ) ) c[k] =  0 - c[k]; // 5 -> -5, reverse
		if( c[k] < 0 ) {
			var e = eq+"_"+Math.abs( c[k] );
			worldScripts["hudreq"].$HUDReq_Remove( e );//if exists
		}
		c[k]++;
		if( c[k] == 0 ) c[k]++; //skip zero
		var e = eq+"_"+Math.abs( c[k] );
		worldScripts["hudreq"].$HUDReq_Award( e );
	}
}

this.$HUDReq_TimedFrameLevel = function(eq, level) { //frame animations up-down synced with marker anim
	if( worldScripts["hudreq"].$HUDReq_Exists( eq ) ) { //alowed to aniamte the eq frame
		var e = eq+"_"+level;
		var n = eq+"_"+(level+1); //next frame
		if( EquipmentInfo.infoForKey(e) ) { //there are frame anim also for this level of marker anim
			worldScripts["hudreq"].$HUDReq_Remove( n ); //if step down then dismatle
			worldScripts["hudreq"].$HUDReq_Award( e ) //build frame anim if not exists
//			player.consoleMessage(e+" "+player.ship.equipmentStatus(e)+" "
//				+n+" "+player.ship.equipmentStatus(n));//debug
		}
	}
}
