"use strict";
this.name        = "coriolisreq";
this.author      = "Norby";
this.copyright   = "2013 Norbert Nagy";
this.licence     = "CC BY-NC-SA 3.0";
this.description = "Coriolis will request new core game features to support OXP improvements.";
this.version     = "1.0";

//communication messages after answers placed below
//the questions and answers are in the hudreq.plist and equipment.plist
//place identification code for all ships with messages or pictures into the _GetShipEQ function
//must place all ships with messages into the first line also to work (not enough an empty [])
this.$CoriolisReq_Comm = ["EQ_HUD_CORIOLISREQ"];
this.$CoriolisReq_Comm ["EQ_HUD_CORIOLISREQ"] = [ { startmenu:1 }, //the number of the start menu
	//no animation means max. one talking picture, but in this case none in the hudreq.plist so a "Voice" label will show
	//no recall number means no repeated calls needed after a closed talk
	//1. menu
	[{text:"Yes!", after:"Please confirm your selection", next:3 }, //next menu after answer, negative=exit
	{text:"No.", after:"Please!", next:0 }, //0 will send the message but remain in this menu
	{text:"Not now.", after:"Not now: See again later.", next:-1 }], //exit and show the 1. menu when reconnect
	//2. menu is empty here to fit into the combined hudreq.plist with the menu of the buoyreq.js
	[],
	//3. menu
	[{text:"Yes.",
	after:"Your mission is to implement the requested features in the readme.txt of the HUDRequests OXP. Please read it and thank you for your work!",
	comms:1,
	markeranim:[1,2,3,4,5,4,3,2]}, //animated marker series
	  //no next parameter is the shorter version of the null which means close the talk
	{text:"No!", after:"No: What a pity...", next:-1, markeranim:[1,2,3,4,5,4,3,2]},
	{text:"Maybe.", after:"Maybe: Ok, then I ask again!", next:1 }]]; //no markeranim means linear marker animation series
this.$CoriolisReq_Merged = false; //merge arrays only once

this.shipWillLaunchFromStation = function() {
	if( worldScripts["hudreq"] && !this.$CoriolisReq_Merged ) {
		//merge the comm array and the GetShipEQ function into the hudreq.js
		worldScripts["hudreq"].$HUDReq_Merge( this.$CoriolisReq_Comm, this.$CoriolisReq_GetShipEQ );
		this.$CoriolisReq_Merged = true; //to avoid repeated merge at every undock
	}
}

this.$CoriolisReq_GetShipEQ = function( target ) { //determine the exact target
	var eq = null;
	if( !eq && target.dataKey == "coriolis-station" ) eq = "EQ_HUD_CORIOLISREQ"; //has messages above
	if( !eq && target.dataKey == "rock-hermit" ) eq = "EQ_HUD_ROCKHERMIT"; //a target with picture only
	return( eq );
}
