"use strict";
this.name        = "buoyreq";
this.author      = "Norby";
this.copyright   = "2013 Norbert Nagy";
this.licence     = "CC BY-NC-SA 3.0";
this.description = "The Nav Buoy request new core game features to support OXP improvements.";
this.version     = "1.1";

//communication messages after answers placed below
//the questions and answers are in the hudreq.plist and equipment.plist
//place identification code for all ships with messages or pictures into the _GetShipEQ function
//must place all ships with messages into the first line also to work (not enough an empty [])
this.$BuoyReq_Comm = ["EQ_HUD_BUOYREQ"];
this.$BuoyReq_Comm ["EQ_HUD_BUOYREQ"] = [
	{	closedmsg:"Just do it!", //message after closed talk
		startmenu:1, //start menu number
		cbf:null, //placeholder for the pointer of the callback function below, set after merge (cause bug if set here)
		leftanim:[1,1,1,1,1,1,1,1,1,1,1,2,3,2,1,1,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,2,3,3,3,3,1], //animation series
		recalls:4 //restart after a closed talk by this many repeat (min.2, max.11, if over 11 then never restart)
	}, // 1. menu
	[{	text:"Yes!",
		after:"Choose your mission",
		next:2, //next menu after answer, negative=exit but recallable, null=close talk
		markeranim:[1,2,3,4,5,4,3,2] //animated marker series
	},
	{	text:"No.", 
		after:"Bad answer, please select another.",
		next:0 //0 will send the message but remain in this menu
	},
	{	text:"Not now.",
		after:"Not now: See again later.",
		next:-1, //exit and show the 1. menu when reconnect (absval)
		markeranim:[1,2,3,4,5,4,3,2] //animated marker series
	}], // 2. menu
	[{	text:"Buoy: take HUD development survey",
		after:"Your answers about HUD development is important, you can send in the Latest.log when you are done.",
		next:4,
		select:1, //the $BuoyReq_Selected function will get this number
		rfcolor:"anim_green" //right frame color=animated green, also means pic exists
	},
	{	text:"Coriolis: talk with the AI",
		after:"Turn around and talk with the AI of the Station. Press N and find your Radio.",
		comms:1, //send the after message to the comms log and not to the console only
		next:null, //null means close the talk
		select:-2, //means select 2. mission and start instantly without confirm
		rfcolor:1
	},
	{	text:"Oolite: reach the Elite status :)",
		after:"Oolite mission: Aliens will be attacking! "
			+"The battle will be logged, so do your best to get into the highscore table.",
		next:3,
		select:3,
		rfcolor:"yellow" //yellow right frame means hard mission
	},
	{	text:"Trumble: cargo trouble",
		after:"Trumble: You you will get some gift instantly. ;)",
		next:3,
		select:4,
		rfcolor:"green",
		markeranim:[1,1,1,3,1,1,1,2,1,1,1,3,1,1,1,3,1,1,2,2,2,1,1,3,1,1,1,2,1,1,1,3,1,1,1,2,1,1,1,3,3,3],
		rightanim:[1,1,1,1,3,1,1,1,1,1,1,2,3,2,1,1,2,3,2,1,1,1,1,1,1,3,1,1,1,1,1,1,3,1,1,1,2,3,2,1,1,1]
	},
	{	text:"Viper: instant action!",
		after:"Viper mission: Defend yourself from the incoming Vipers! See Latest.log to review your performance.",
		next:3,
		select:5,
		rfcolor:"anim_yellow" //animated yellow right frame means very hard mission
	}
//	,{	text:"Rock Hermit: mining and pirates",
//		after:"Rock Hermit: you can play it after implemented.",
//		next:3,
//		select:6,
//		rfcolor:3
//	}
	], // 3. menu
	[{	text:"Yes.",
		after:"Your bonus mission is to code the requests in the readme.txt. Please read and do it if you can!",
		comms:1,
		next:null,
		select:"Sure", //"Sure" is the flag to _Selected to start the previously selected mission
		markeranim:[1,2,3,4,5,4,3,2] //animated marker series
	},
	{	text:"No, I choose another.",
		after:"Ok, then I ask again!",
		next:2
	},
	{	text:"No, I want to leave.",
		after:"What a pity, bye!",
		next:-1,
		markeranim:[1,2,3,4,5,4,3,2]
	}], // 4. menu
	[{	text:"Yes!", after:"1. Please make script-writable text legends.", comms:2, next:5 },
	{	text:"No, I prefer the blind flying when I look the status screens. :)",
		after:"Ok, then I ask another.", next:5 }
	], // 5. menu
	[{	text:"Maybe.", after:"Please choose another answer.", next:0 }, //stay here
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Yes!", after:"Not win, please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"No.", after:"Not win, please choose another answer.", next:0 }, //10.line
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Yes!", after:"2. Please make two more equipment buttons for back and close.", comms:2, next:7 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"No.", after:"Ok, then I ask another.", next:6 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 },
	{	text:"Yes!", after:"Not win, please choose another answer.", next:0 },
	{	text:"Maybe.", after:"Please choose another answer.", next:0 }
	],[ // 6. menu is removed
	], // 7. menu
	[{	text:"Yes!", after:"3. Please make something like a hud-overrides.plist to able to automerge the HUD menus with any installed HUD.", comms:2, next:8 },
	{	text:"No.", after:"Ok, then I ask another.", next:8 }
	], // 8. menu
	[{	text:"Yes!", after:"4. Please make usable the rgb_color in HUD legends.", comms:2, next:9, select:100 },
	{	text:"No.", after:"Ok, then I ask another.", next:9, select:100 }
	], // 9. menu
	[{	text:"Yes.", after:"5. Please make writable the x,y and other parameters of the legends.", 
		comms:2, next:10, select:101, markeranim:[1,2,3,4,5,4,3,2] },
	{	text:"No.", after:"Ok, then I ask another.", next:10, select:101, markeranim:[1,2,3,4,5,4,3,2] }
	], // 10. menu
	[{	text:"Yes!", after:"6. Please make an Input Box legend and/or a mode where all keypress is handleable.", comms:2, next:11 },
	{	text:"No.", after:"Ok, then I ask another.", next:11 }
	], // 11. menu
	[{	text:"Yes!", after:"7. Please make an event handler which can run in pause also to clear the screen.", comms:2, next:12 },
	{	text:"No.", after:"Ok, then I ask another.", next:12 }
	], // 12. menu
	[{	text:"Yes!",
		after:"Thank you for filling the survey, please send the Latest.log with your answers to norbylite@gmail.com! "
			+"Your bonus mission is to code the requests, please do it!",
		comms:2,
		next:null,
		markeranim:[1,2,3,4,5,4,3,2] //animated marker series
	},
	{	text:"No, I choose another mission.",
		after:"Then try again!",
		next:2,
		markeranim:[1,2,3,4,5,4,3,2] //animated marker series
	}]];
this.$BuoyReq_Merged = false; //merge arrays only once
this.$BuoyReq_Mission = 0; //store selected mission number until confirmed
this.$BuoyReq_OMEnemyCount = 0; //Oolite mission enemy counter
this.$BuoyReq_OMHit = 0; //Oolite mission to hit counter
this.$BuoyReq_OMStartTime = 0; //Oolite mission start time
this.$BuoyReq_OMScore = 0; //Oolite mission score holder
this.$BuoyReq_OMVictory = 0; //Oolite mission aerial victory counter
this.$BuoyReq_OMTimer = null; //store the timer pointer

this.shipWillLaunchFromStation = function() {
	if( worldScripts["hudreq"] && !this.$BuoyReq_Merged ) {
		//merge the comm array and the GetShipEQ function into the hudreq.js
		worldScripts["hudreq"].$HUDReq_Merge( this.$BuoyReq_Comm, this.$BuoyReq_GetShipEQ );
		worldScripts["hudreq"].$HUDReq_Comm["EQ_HUD_BUOYREQ"][0].cbf =
			worldScripts["buoyreq"].$BuoyReq_Selected; //set callback function (work only if set after merge)
		this.$BuoyReq_Merged = true; //to avoid repeated merge at every undock
//		player.consoleMessage("Your answers will be logged, please send Latest.log to norbylite@gmail.com", 10);
	}
	var x = missionVariables.$BuoyReq_OMScoreMax;
	if( x > 0 ) system.mainStation.commsMessage( "The best score in this savegame: " + x, player.ship );
}

this.$BuoyReq_GetShipEQ = function( target ) { //determine the exact target
	var eq = null;
	if( !eq && target.dataKey == "buoy" && system.name == "Lave" ) eq = "EQ_HUD_BUOYREQ"; //has messages above
	return( eq );
}

this.$BuoyReq_Selected = function( menu, line, select ) { //mission selected
	if( select > 0 ) {
		select = Math.floor( select ); //for sure
		worldScripts["buoyreq"].$BuoyReq_Mission = select; //save mission selection
//		player.consoleMessage("Saved "+menu+" "+line+" "+select); //debug
		if( menu == 2 && select == 3 ) {//Oolite mission best local score
			var x = missionVariables.$BuoyReq_OMScoreMax;
			if( x > 0 ) player.commsMessage( "The best score in this savegame: " + x, 10 );
		}
		if( menu == 7 && select == 100 ) {//support for the survey movable HUD question
//			player.ship.awardEquipment("EQ_TRUMBLE"); //deactivated due to can not remove
		}
		if( menu == 8 && select == 101 ) {//support for the survey movable HUD question
//			player.ship.removeEquipment("EQ_TRUMBLE");
//			player.commsMessage( "Trumble"+player.ship.equipmentStatus( "EQ_TRUMBLE" ), 10);
		}
		return;
	}
	var mission = worldScripts["buoyreq"].$BuoyReq_Mission;
	if( select < 0 ) mission = -select; //instantly confirmed
//	player.consoleMessage("Selected "+menu+" "+line+" "+select+" "+mission); //debug
	if( select == "Sure" || select < 0 ) { //mission confirmed
		switch( mission ) { //load mission selection and start it
                case 0: player.consoleMessage("No mission selected.", 5); 
			break;
		case 1: //please implement Buoy survey ending here
			break;
		case 2: //Coriolis hint ending
			worldScripts["hudreq"].$HUDReq_ClearTarget(); //to help lock the Station release the Buoy target lock
			//the following lines fill the prime list with other equipments
			//to demonstrate the usability of the prime back button when overrun
			player.ship.removeEquipment("EQ_HUDRADIO"); 
			player.ship.awardEquipment("EQ_HUDOTHER1");
			player.ship.awardEquipment("EQ_HUDOTHER2");
			player.ship.awardEquipment("EQ_HUDOTHER3");
			player.ship.awardEquipment("EQ_HUDOTHER4");
			player.ship.awardEquipment("EQ_HUDOTHER5");
			player.ship.awardEquipment("EQ_HUDOTHER6");
			player.ship.awardEquipment("EQ_HUDOTHER7");
			player.ship.awardEquipment("EQ_HUDOTHER8");
			player.ship.awardEquipment("EQ_HUDRADIO"); 
			player.ship.awardEquipment("EQ_HUDOTHER9");
			break;
		case 3: //implement Oolite mission here (it is an opening only)
			if( worldScripts["buoyreq"].$BuoyReq_OMTimer ) {
				player.consoleMessage("Oolite mission already running, defeat aliens to win.", 5); 
			} else {
				var shipno = 2;
				if(player.ship.equipmentStatus("EQ_WEAPON_MILITARY_LASER") == "EQUIPMENT_OK")
					shipno += Math.floor(player.ship.maxEnergy/128);
				var s = system.addShips("[thargoid]", shipno, player.ship.position, 10000);
				system.mainStation.target = s[0];
				system.mainStation.launchDefenseShip();
				worldScripts["buoyreq"].$BuoyReq_OMEnemyCount = 0; //0 regardless of the spawned enemies!
				//The timer will be set the enemy count and need to be different to send left message
				worldScripts["buoyreq"].$BuoyReq_OMScore = 42; //the answer is :)
				worldScripts["buoyreq"].$BuoyReq_OMStartTime = clock.absoluteSeconds;
				worldScripts["buoyreq"].$BuoyReq_OMVictory = 0;
				worldScripts["buoyreq"].$BuoyReq_OMTimer = new Timer(this,
					worldScripts["buoyreq"].$BuoyReq_OMTimed, 3, 1); //check the end at every seconds
			}
			break;
		case 4: //do cargo trouble
			player.ship.awardEquipment("EQ_TRUMBLE");
			player.ship.awardEquipment("EQ_TRUMBLE");
			player.ship.awardEquipment("EQ_TRUMBLE");
			player.ship.useSpecialCargo("EQ_TRUMBLE");
			player.commsMessage("Thank you for the pick up, your ship is enough for my family!", 10);
			break;
		case 5: //instant action like when attacked the main station
			system.mainStation.target = player.ship; //launched police will be hostile
			system.mainStation.roll = 2; //roll faster to make manual docking harder
			system.mainStation.requiresDockingClearance = true; //to disable autodocking
			system.mainStation.allowsAutoDocking = false; //also
			system.mainStation.allowsFastDocking = false; //also
			system.mainStation.launchPolice(); //launch 4 ship
			//spawn more vipers depending on the strength of the player
			var shipno = Math.floor(player.ship.maxEnergy/256);
			var v = system.addShips("[viper]", shipno, player.ship.position, 15000);
			for(var i = 0; i < v.length; i++) v[i].target = player.ship; //make hostile
			if( shipno > 1 ) { //player has at least 8 energy banks
				var i = v.length;  //add the boss
				v[i] = system.addShips("[viper-interceptor]", 1, player.ship.position)[0];
				v[i].target = player.ship; //make hostile also
			}
			player.ship.setBounty(51, "requested viper attack"); //set to Fugitive
			player.commsMessage("You choosed to live as a pirate, this will not be awarded.", 10);
			break;
//		case 6: //implement Rock Hermit mission here
//			break;
		default: player.consoleMessage("Invalid mission selected.", 5);
			break;
		}
		worldScripts["buoyreq"].$BuoyReq_Mission = 0;
	}
}

this.$BuoyReq_OMFindEnemy = function(who) {
	if( who.dataKey == "thargoid" || ( who.dataKey == "tharglet" && who.owner && who.owner.isValid ) ) return true;
	return false;
}

this.$BuoyReq_OMTimed = function() { //check the end
//	if( player.bounty > 0 ) { //no score due to friendly fire - too hard, deactivated
//		player.commsMessage("You hit a friend! Please restart and remain Clean to get score.", 10);
//		if( worldScripts["buoyreq"].$BuoyReq_OMTimer ) {
//			worldScripts["buoyreq"].$BuoyReq_OMTimer.stop();
//			delete worldScripts["buoyreq"].$BuoyReq_OMTimer;
//		}
//		return;
//	}
	var elapsed = Math.floor( clock.absoluteSeconds - worldScripts["buoyreq"].$BuoyReq_OMStartTime );
	var st = system.filteredEntities(this, worldScripts["buoyreq"].$BuoyReq_OMFindEnemy);
	var n = st.length;
	if( n > 0 || elapsed < 120 ) { //the minimal length of the battle (2 minutes)
		if( n < 2 && elapsed < 120 ) { //aliens get reinforcements
			system.addShips("[thargoid]", 1, player.ship.position, 20000);
			n++;
		}
		var ec = worldScripts["buoyreq"].$BuoyReq_OMEnemyCount;
		if( n != ec ) {
			worldScripts["buoyreq"].$BuoyReq_OMEnemyCount = n;
			player.consoleMessage( n + " enemy left", 5);
		}
	} else { //no more enemy and over the minimal time
		var hit = worldScripts["buoyreq"].$BuoyReq_OMHit;
		var v = worldScripts["buoyreq"].$BuoyReq_OMVictory;

		var score = worldScripts["buoyreq"].$BuoyReq_OMScore;//starting score
		score += Math.max( 0, 300 - elapsed ); //every remained second from 5 minutes worth 1 points
		score += 5 * hit; //every hit worth 5 points
		score += 50 * v; //every victory worth 50 points

		var s = "";
		if( hit > 0 ) s = hit+" hit";
		if( hit > 1 ) s += "s";
		if( v > 0 ) {
			if( s.length > 0 ) s += " and ";
			s += v+" victor";
			if( v > 1 ) s += "ies";
			else s += "y";
		}
		if( s.length > 0 ) s = " and earned "+s;
		
		var savedscore = missionVariables.$BuoyReq_OMScoreMax;
		var best = ", your best is "+savedscore;
		if( savedscore < score ) {
			missionVariables.$BuoyReq_OMScoreMax = score;
			best = ", this is your best";
		}		
		var m = "Congratulations, you are win in "+elapsed+" seconds"+s+"! "
			+"Your score: "+score+best+"!";
		log("BuoyReq_OM", m );
		player.commsMessage( m, 10 );
		player.commsMessage("Send your Latest.log to norbylite@gmail.com to qualify into the global highscore table!", 10);
		
		if( worldScripts["buoyreq"].$BuoyReq_OMTimer ) {
			worldScripts["buoyreq"].$BuoyReq_OMTimer.stop();
			delete worldScripts["buoyreq"].$BuoyReq_OMTimer;
		}
	}
}

//world script events for Oolite Mission
this.shipAttackedOther = function(other) {
	if( worldScripts["buoyreq"].$BuoyReq_OMFindEnemy(other) )
		worldScripts["buoyreq"].$BuoyReq_OMHit++;
}

this.shipKilledOther = function(whom, damageType) {
	if( worldScripts["buoyreq"].$BuoyReq_OMFindEnemy(whom) ) {
		var v = ++worldScripts["buoyreq"].$BuoyReq_OMVictory;
		player.consoleMessage( "This is your "+v+". aerial victory!", 5);
	}
}

this.shipWillEnterWitchspace = this.playerEnteredNewGalaxy = this.shipLaunchedEscapePod = this.shipDied = function() {
	if( worldScripts["buoyreq"].$BuoyReq_OMTimer ) {
		player.commsMessage("You are jumped out. Please restart mission to get score.", 10);
		worldScripts["buoyreq"].$BuoyReq_OMTimer.stop();
		delete worldScripts["buoyreq"].$BuoyReq_OMTimer;
	}
}
