this.name           = "hyperradio";
this.author         = "Svengali";
this.copyright      = "CC-by-nc-sa-3.0";
this.description    = "HyperRadio for Oolite v1.71.x. This version can be expanded with musicpacks.";
this.version        = "1.07";

// Declare a station list with default entry
var hyperradio_stationlist = new Array("[hyperradio_songlist0]");

this.startUp = function()
{
	this.hyperradio_play = true;
	this.hyperradioTimerA = new Timer(this, this.hyperradioTimer, 0, 7);
	this.hyperradioTimerA.stop();
	this.hyperradio = false;
}

this.reset = function()
{
	// Get the completed list - possibly expanded by musicpacks
	this.hyperradio_stationlist = hyperradio_stationlist;
	// Get number of stations
	this.hyperradio_stations = this.hyperradio_stationlist.length;
	// Calculate the limiter
	this.hyperradio_limit = 0;
	let hyperradio_counterlimit = this.hyperradio_stations;
	while (hyperradio_counterlimit >= 1) { hyperradio_counterlimit/= 2; this.hyperradio_limit++; }
	this.hyperradio_limit = Math.pow(2,this.hyperradio_limit)-1;
	// This is necessary because the music handling is different in v1.71.2
	if (oolite.compareVersion("1.71.2") < 0) { delete this.shipWillDockWithStation; }
	else { delete this.shipDockedWithStation; }
}

// Sometimes gives an error back - but that's cosmetics
this.shipDockedWithStation = function()
{
	this.hyperradioTimerA.stop();
	Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_play = true;
	this.CheckHyperradioLicence();
}

// Sometimes gives an error back - but that's cosmetics
this.shipWillDockWithStation = function()
{
	this.hyperradioTimerA.stop();
	Sound.stopMusic(this.hyperradio_current);
	this.hyperradio_play = true;
	this.CheckHyperradioLicence();
}

// Get current status
this.shipWillLaunchFromStation = function()
{
	if (player.hasEquipment("EQ_HYPER_RADIO")) {
		this.hyperradio = true;
		if (this.hyperradio_stations > 1) { this.SelectHyperradioStation(); }
		else { this.hyperradio_stationselect = 0; }
	}
}

// Setup variabes and timer
this.shipLaunchedFromStation = function()
{
	if (this.hyperradio) {
		this.hyperradio_play = true; this.hyperradio_current = "start"; this.hyperradio_next = "start";
		if (!missionVariables.hyperradio_last) { missionVariables.hyperradio_last = String(Math.floor(20 + (clock.days))); }
		this.hyperradioTimerA.start();
	}
}	

// Check if interstellar space
this.shipExitedWitchspace = function()
{
	if (this.hyperradio) {
		if (system.isInterstellarSpace) {
			if (this.hyperradio_current != "start") { Sound.stopMusic(this.hyperradio_current); }
			player.commsMessage('Hyperradio deactivated. Could not transfer data.', 8);
			this.hyperradioTimerA.stop();
			return;
		}
		else {
			if (this.hyperradio_stations > 1) { this.SelectHyperradioStation(); }
			else { this.hyperradio_stationselect = 0; }
		}
		this.hyperradio_play = true; this.hyperradioTimerA.start();
	}
}

// If status = red stop it and if <> red and not docked start timer again
this.alertConditionChanged = function()
{
    if (player.alertCondition == 3 && this.hyperradio) { this.hyperradioTimerA.stop(); Sound.stopMusic(this.hyperradio_current); }
    if (player.alertCondition < 3 && player.alertCondition != 0 && this.hyperradio && !this.hyperradioTimerA.isRunning) { this.hyperradioTimerA.start(); }
}

// Select station
this.SelectHyperradioStation = function()
{
	this.hyperradio_stationselect = system.ID&this.hyperradio_limit;
	if (this.hyperradio_stationselect == 0 && Math.random() > 0.5) { this.hyperradio_stationselect += Math.floor(Math.random()*(this.hyperradio_stations-1))+1; }
	if (this.hyperradio_stationselect > (this.hyperradio_stations-1)) { this.hyperradio_stationselect -= Math.floor(Math.random()*(this.hyperradio_stations-1))+1; }
	return;
}

// Get next songname from list
this.GetHyperradioSongName = function()
{
	let listname = this.hyperradio_stationlist[this.hyperradio_stationselect];
	let Listofsongs = [expandDescription(listname), expandDescription(listname), expandDescription(listname), expandDescription(listname), expandDescription(listname)];
	let songselect = Math.round(Math.random()*(Listofsongs.length-1));
	if (Listofsongs[0] == Listofsongs[1] && Listofsongs[0] == Listofsongs[2] && Listofsongs[0] == Listofsongs[3]) {
		this.hyperradio_next = Listofsongs[0];
		if (this.hyperradio_next == listname) {
			player.consoleMessage('WARNING. NO VALID ENTRY FOUND. HYPERRADIO DISABLED',8);
			log('HYPERRADIO','There is a problem with your descriptions.plist. It is not there or not valid. Please check it.');
		}
		return;
	}
	while (this.hyperradio_current == this.hyperradio_next) { songselect = Math.round(Math.random()*(Listofsongs.length-1)); this.hyperradio_next = Listofsongs[songselect]; }
	return;
}

// Check license and remove equipment if expired
this.CheckHyperradioLicence = function()
{
	if (clock.days >= parseInt(missionVariables.hyperradio_last)) {
		player.removeEquipment("EQ_HYPER_RADIO");
		this.hyperradio = false; missionVariables.hyperradio_last = null; this.hyperradio_play = true;
		player.consoleMessage('Your HyperRadio licence is expired. Buy a new one at your local dealer.', 6);
		this.hyperradioTimerA.stop();
		return ("expired");
	}
	return ("ok");
}

// Main routine
this.hyperradioTimer = function()
{
	if (player.status == "STATUS_IN_FLIGHT") {
		if (guiScreen == "GUI_SCREEN_SYSTEM_DATA" && !this.hyperradio_play) {
			if (this.hyperradio && this.CheckHyperradioLicence() == "ok") {
				Sound.stopMusic(this.hyperradio_current);
				this.GetHyperradioSongName();
				if (this.hyperradio_next == this.hyperradio_stationlist[this.hyperradio_stationselect]) { this.hyperradioTimerA.stop(); }
				else {
					this.hyperradio_current = this.hyperradio_next;
					player.consoleMessage('Connection established.');
					this.hyperradio_play = true;
					Sound.playMusic(this.hyperradio_current);
				}
			}
		}
		if (guiScreen == "GUI_SCREEN_MAIN" && this.hyperradio_play) { this.hyperradio_play = false; }
	}
}