"use strict";

this.name = "personalities-priorityAI";
this.author = "Alnivel";
this.description = "Modifying PriorityAI Controller";

this.PersonalityPriorityAIController = function (ship) {
    throw new Error("PersonalityPriorityAIController can not be created before startUp");
};

this._PersonalityPriorityAIController = function (ship) {
    this.super(ship);
    this.tweakSuperMethods();
    this.setOwnMethods();

    this.setCommunicationsPersonality("_" + ship.scriptInfo.name);
    this.setCommunicationsRole("_personalitiesOXP");

    this.setParameter("personalitiesOXP_flag_spawnedNearWitchpoint", ship.position.magnitude <= 25600);

    const distanceToMainStation = ship.position.distanceTo(system.mainStation);
    const launchedFromMainStation = ship.dockedStation === system.mainStation || (distanceToMainStation < 20000 && Math.random() < 0.5);
    this.setParameter("personalitiesOXP_flag_launchedFromMainStation", launchedFromMainStation);
};

this.$prototype_tweakSuperMethods = function () {
    var lastCommSent = 0; // variables from original method is not accessible
    var lastCommHeard = 0;

    this.continueMessageTimer = null;
    this.continueMessage = function continueMessage(messageContinuation) {
        this.ship.commsMessage(this.parseCommands(messageContinuation)); // parse for commands recursively 
        lastCommSent = clock.adjustedSeconds;
    };

    // code below stolen from PriorityAIController constructor
    this.communicate = function (key, params, priority) {
        if (!worldScripts["oolite-libPriorityAI"].$commsAllowed) {
            // comms temporarily disabled
            return false;
        }
        if (priority > 1) {
            var send = clock.adjustedSeconds - lastCommSent;
            if (priority == 2) {
                if (send < 10) {
                    return false;
                }
            }
            else {
                var recv = clock.adjustedSeconds - lastCommHeard;
                if (priority == 3) {
                    if (recv < 10 || send < 10) {
                        return false;
                    }
                }
                else {
                    if (recv < 60 || send < 60) {
                        return false;
                    }
                }
            }
        }
        var template = worldScripts["oolite-libPriorityAI"]._getCommunication(this.communicationsRole(), this.communicationsPersonality(), key); // role and personality inside closure too but accessible via methods
        if (template != "") {
            if (params && params.isShip) {
                params = this.entityCommsParams(params);
            }
            if (template instanceof Function) {
                var message = template(key, params);
            }
            else {
                var message = expandDescription(template, params);
            }
            if (message != "") {
                let sendNowPart = this.parseCommands(message);
                if (sendNowPart !== "")
                    this.ship.commsMessage(message);
                lastCommSent = clock.adjustedSeconds;
                return true;
            }
        } else {
            log("Personalities_ScriptInfoDebug", "Info for" + this.communicationsPersonality() + ": want use " + key + " but no such key here");
        }

        return false;
    };

    this.noteCommsHeard = function () {
        lastCommHeard = clock.adjustedSeconds;
    };
};

this.$prototype_setOwnMethods = function () {
    const scriptInfo = this.ship.scriptInfo;
    const logPrefix = "Warning for " + scriptInfo.name + ": ";

    switch (scriptInfo.attacked) {
        case "flee":
            this.parametric_behaviourBeingAttacked = this.behaviourFleeCombat;
            break;
        case "cloak":
            this.parametric_behaviourBeingAttacked = this.behaviourDestroyCurrentTarget; //!!! TODO: Add cloacking
            break;
        case "destroy":
            this.parametric_behaviourBeingAttacked = this.behaviourDestroyCurrentTarget;
            break;
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.attacked - '" + scriptInfo.attacked + "'. Must be 'jump' or 'stay'");
        case "repel":
        case undefined:
            this.parametric_behaviourBeingAttacked = this.behaviourRepelCurrentTarget;
            break;

    }



    switch (scriptInfo.energyDown) {
        case "flee":
            this.parametric_templateShildsDepleted = this.internal_templateFleeCombat;
            break;
        case "cloak":
            this.parametric_templateShildsDepleted = this.internal_templateFleeCombat; //!!! TODO: Add cloacking
            break;
        case "jump":
            this.parametric_templateShildsDepleted = this.internal_templateJumpFromCombat;
            break;
        case "continue":
        case undefined:
            this.parametric_templateShildsDepleted = this.internal_templateEmpty;
            break;
        default:
            this.parametric_templateShildsDepleted = this.internal_templateFleeCombat;
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.energyDown - '" + scriptInfo.energyDown + "'. Must be 'flee', 'jump', 'continue' or not set at all (same as 'continue')");
            break;
    }

    switch (scriptInfo.energyLow) {
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.energyLow - '" + scriptInfo.energyLow + "'. Must be 'flee', 'jump', 'continue'  or not set at all (same as 'flee')");
        case "flee":
        case undefined:
            this.parametric_templateLosingCombat = this.internal_templateFleeCombat;
            break;
        case "jump":
            this.parametric_templateLosingCombat = this.internal_templateJumpFromCombat;
            break;
        case "continue":
            this.parametric_templateLosingCombat = this.internal_templateEmpty;
            break;

    }

    switch (scriptInfo.launch) {
        case "jump":
            this.parametric_templateAfterLaunch = this.templateWitchspaceJumpOutbound;
            break;
        case "stay":
            this.parametric_templateAfterLaunch = this.internal_templateFlyToWitchpoint;
            break;
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.launch - '" + scriptInfo.launch + "'. Must be 'jump', 'stay', 'random' or not set at all (same as 'random', 50/50 chance)");
        case "random":
        case undefined:
            this.parametric_templateAfterLaunch = Math.random() < 0.5 ? this.internal_templateFlyToWitchpoint : this.templateWitchspaceJumpOutbound;
            break;

    }

    switch (scriptInfo.prey) {
        case "everybody":
            this.parametric_conditionScannerContainsPrey = this.internal_conditionScannerContainsNonPolice;
            break;
        case "loneVictim":
            this.parametric_conditionScannerContainsPrey = this.conditionScannerContainsLoneVictim;
            break;
        case "traders":
            this.parametric_conditionScannerContainsPrey = this.conditionScannerContainsPirateVictims;
            break;
        case "offenders":
            this.parametric_conditionScannerContainsPrey = this.internal_conditionScannerContainsOffenderAboveThreshold;
            break;
        case "thargoids":
            this.parametric_conditionScannerContainsPrey = this.conditionScannerContainsThargoidMothership;
            break;
        case "nobody":
        case undefined:
            log("Personalities_ScriptInfoDebug", logPrefix + "script_info.prey isn't set. It's okay if personality is a cruiser, but if they is a privateer on hunter they will not attack nobody");
            break;
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.prey - '" + scriptInfo.prey + "'. Must be 'everybody', 'loneVictim', 'traders', 'offenders' or 'thargoids'");
            break;
    }

    if (scriptInfo.preyLimit != undefined) {
        if (isFinite(scriptInfo.preyLimit) || scriptInfo.preyLimit > 0)
            this.setParameter("personalitiesOXP_preyBountyThreshold", +scriptInfo.preyLimit);
        else
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.preyLimit - '" + scriptInfo.preyLimit + "'. Must be finite positive number");
    }

    switch (scriptInfo.preyCombatOdds) {
        case "none":
            this.parametric_conditionMinimalCombatOdds = this.internal_conditionAlwaysFalse;
            break;
        case "excelent":
            this.parametric_conditionMinimalCombatOdds = this.conditionCombatOddsExcellent;
            break;
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.preyCombatOdds - '" + scriptInfo.preyCombatOdds + "'. Must be 'excelent', 'good', 'bad', 'terrible', 'any' or not set at all (same as 'good')");
        case undefined:
        case "good":
            this.parametric_conditionMinimalCombatOdds = this.conditionCombatOddsGood;
            break;
        case "bad":
            this.parametric_notconditionMinimalCombatOdds = this.conditionCombatOddsBad;
            break;
        case "terrible":
            this.parametric_notconditionMinimalCombatOdds = this.conditionCombatOddsTerrible;
            break;
        case "any":
            this.parametric_conditionMinimalCombatOdds = this.internal_conditionAlwaysTrue;
            break;
    }

    switch (scriptInfo.distressCallReaction) {
        default:
            log("PersonaliPersonalities_ScriptInfoDebugties", logPrefix + "Ivalid value of script_info.distressCallReaction - '" + scriptInfo.distressCallReaction + "'. Must be 'ignore', 'help', 'finishOff' or not set at all (same as 'ignore')");
        case undefined:
        case "ignore":
            this.parametric_conditionCombatOddsSufficientToIntervene = this.internal_conditionAlwaysFalse;
            break;
        case "help":
            this.parametric_conditionCombatOddsSufficientToIntervene = this.internal_conditionCombatOddsSufficientToHelp;
            this.parametric_behaviourInterveneAtDistressCall = this.internal_behaviourHelpAtDistressCall;
            break;
        case "finishOff":
            this.parametric_conditionCombatOddsSufficientToIntervene = this.internal_conditionCombatOddsSufficientToFinishOff;
            this.parametric_behaviourInterveneAtDistressCall = this.internal_behaviourFinishOffAtDistressCall;
            break;
    }

    switch (scriptInfo.distressCallCombatOdds) {
        case "none":
            this.parametric_internal_conditionCombatOddsSufficientToIntervene = this.internal_conditionAlwaysFalse;
            break;
        case "excelent":
            this.parametric_internal_conditionCombatOddsSufficientToIntervene = this.conditionCombatOddsExcellent;
            break;
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.distressCallCombatOdds - '" + scriptInfo.distressCallCombatOdds + "'. Must be 'excelent', 'good', 'bad', 'terrible', 'any' or not set at all (same as 'good')");
        case undefined:
        case "good":
            this.parametric_internal_conditionCombatOddsSufficientToIntervene = this.conditionCombatOddsGood;
            break;
        case "bad":
            this.parametric_internal_notconditionCombatOddsSufficientToIntervene = this.conditionCombatOddsBad;
            break;
        case "terrible":
            this.parametric_internal_notconditionCombatOddsSufficientToIntervene = this.conditionCombatOddsTerrible;
            break;
        case "any":
            this.parametric_internal_notconditionCombatOddsSufficientToIntervene = this.internal_conditionAlwaysTrue;
            break;
    }

    switch (scriptInfo.distressCallInsufficientOddsReaction) {
        default:
            log("Personalities_ScriptInfoDebug", logPrefix + "Ivalid value of script_info.distressCallInsufficientOdds - '" + scriptInfo.distressCallInsufficientOdds + "'. Must be 'ignore', 'leaveVicinity', 'jumpOut' or not set at all (same as 'ignore')");
        case undefined:
        case "ignore":
            break;
        case "leaveVicinity":
            this.parametric_behaviourNotInterveneAtDistressCall = this.behaviourLeaveVicinityOfTarget;
            break;
        case "jumpOut":
            this.parametric_behaviourNotInterveneAtDistressCall = this.internal_templateJumpFromCombat;
            break;
    }

    if (isFinite(scriptInfo.miningProbability)) {
        this.setParameter("personalitiesOXP_miningProbability", +scriptInfo.miningProbability);
    }
    else {
        this.setParameter("personalitiesOXP_miningProbability", 0);
    }

    if (isFinite(scriptInfo.fuelstationProbability)) {
        this.setParameter("personalitiesOXP_flag_needRefuelAtFuelStation", Math.random() < scriptInfo.fuelstationProbability);
    }
    else {
        this.setParameter("personalitiesOXP_flag_needRefuelAtFuelStation", 0);
    }

    if (isFinite(scriptInfo.sunskimProbability)) {
        this.setParameter("personalitiesOXP_flag_needSunskim", Math.random() < scriptInfo.sunskimProbability);
    }
    else {
        this.setParameter("personalitiesOXP_flag_needSunskim", 0);
    }

    this.parametric_behaviourChatWithPlayer = this.internal_behaviourChatWithPlayer;
    this.parametric_priorityVisitFuelStationIfNeeded = this.fuelStationOXPinstalled ? this.internal_priorityVisitFuelStationIfNeeded : this.internal_priorityEmpty;
    this.parametric_conditionScannerContainsMiningOpportunityAndPersonalityWantUseIt = this.internal_conditionScannerContainsMiningOpportunityAndPersonalityWantUseIt;

    this.parametric_conditionShiledDepleted = this.internal_conditionShiledDepleted;
    this.parametric_conditionNeedSunskim = this.internal_conditionNeedSunskim;
    this.parametric_conditionLaunchedFromStation = this.internal_conditionLaunchedFromStation;

    this.parametric_conditionWantsRevenge = this.internal_conditionWantsRevenge;
    this.parametric_behaviourRevengeTarget = this.internal_behaviourRevengeTarget;
};

this.$prototype_parseCommands = function (message) {
    const commandStart = message.indexOf("{");
    if (commandStart === -1) {// There is no command
        return message; // So broadcast as is
    }
    else {
        const commandDelimiter = message.indexOf(":");
        const commandEnd = message.indexOf("}");

        const command = message.substring(commandStart + 1, commandDelimiter);
        const commandParameter = message.substring(commandDelimiter + 1, commandEnd);

        if (command === "pause") {
            const sendNowPart = message.substring(0, commandStart);
            const sendWithDelayPart = message.substring(commandEnd + 1);
            const delay = +commandParameter || 0.25;

            if (this.continueMessageTimer) {
                this.continueMessageTimer.stop();
            }
            if (sendWithDelayPart)
                this.continueMessageTimer = new Timer(this, this.continueMessage.bind(this, sendWithDelayPart), delay);
            if (sendNowPart)
                return sendNowPart;
            else
                return "";
        }
        else {
            log("Personalities_CommsDebug", "Error for " + this.ship.scriptInfo.displayName + ": Failed when trying to parse a command in the message '" + message + "'");
        }
    }

};

this.startUp = function () {
    this.PersonalityPriorityAIController = this._PersonalityPriorityAIController;

    const libPriorityAI = worldScripts["oolite-libPriorityAI"];

    const prototype = Object.create(libPriorityAI.PriorityAIController.prototype);
    this.PersonalityPriorityAIController.prototype = prototype;

    prototype.constuctor = this.PersonalityPriorityAIController;
    prototype.super = libPriorityAI.PriorityAIController;
    prototype.tweakSuperMethods = this.$prototype_tweakSuperMethods;
    prototype.setOwnMethods = this.$prototype_setOwnMethods;
    prototype.parseCommands = this.$prototype_parseCommands;

    prototype.fuelStationOXPinstalled = !!worldScripts["FuelStation-Setup"];

    //#region Set prototype methods
    prototype.internal_behaviourChatWithPlayer = function () {
        if (this.getParameter("personalitiesOXP_flag_suppressChatWithPlayer")) return; // Can be used to temporarily stop chatter, for example, when player talk via broadcastMDF

        if (!this.getParameter("personalitiesOXP_flag_greetedWithPlayer")) {

            if (!this.getParameter("personalitiesOXP_chattedWithPlayerTime")) { // delay a bit first message
                this.setParameter("personalitiesOXP_chattedWithPlayerTime", clock.adjustedSeconds);
                return;
            }

            let messageSended = this.communicate("personalitiesOXP_greet", player.ship, 2); // standart "communicate" return nothing, but we redefine it
            if (!messageSended)
                messageSended = this.communicate("personalitiesOXP_chatter", player.ship, 2);
            if (messageSended) {
                this.setParameter("personalitiesOXP_flag_greetedWithPlayer", true);
                this.setParameter("personalitiesOXP_chattedWithPlayerTime", clock.adjustedSeconds + 10); // first chatter will be bit earlier
            }
        }
        else {
            let timeSinceChatter = clock.adjustedSeconds - this.getParameter("personalitiesOXP_chattedWithPlayerTime");
            if (timeSinceChatter > 20) {
                let messageSended = this.communicate("personalitiesOXP_chatter", player.ship, 1);//3);
                if (messageSended) {
                    this.setParameter("personalitiesOXP_chattedWithPlayerTime", clock.adjustedSeconds);
                }
            }

        }
    };

    prototype.internal_conditionLaunchedFromStation = function () {
        return this.getParameter("personalitiesOXP_flag_launchedFromMainStation");
    };

    prototype.internal_conditionShiledDepleted = function () {
        // original energyDown - when ship's energy is down to 1/2 and threat it as depleted shields  
        // but cloak nowadays can be used when energy more than 3/4 of max energy
        // Should we use another criteria?

        return this.ship.energy <= (this.ship.maxEnergy / 2);
    };

    prototype.internal_conditionNeedSunskim = function () {
        let needSunskim = this.getParameter("personalitiesOXP_flag_spawnedNearWaypoint") &&
            this.getParameter("personalitiesOXP_flag_needSunskim");
        if (!needSunskim) {
            if (this.ship.fuel >= 6.5)
                this.setParameter("personalitiesOXP_flag_needSunskim", false);
            return false;
        }
        else {
            return needSunskim;
        }
    };

    // TODO: Name is too short, make longer
    prototype.internal_conditionScannerContainsMiningOpportunityAndPersonalityWantUseIt = function () {
        return this.conditionScannerContainsMiningOpportunity &&
            (this.getParameter("personalitiesOXP_miningProbability") || 0) > Math.random();
    };

    prototype.internal_conditionNeedFlyToFuelStation = function () {
        let needRefuel = this.getParameter("personalitiesOXP_flag_spawnedNearWaypoint") &&
            this.getParameter("personalitiesOXP_flag_needRefuelAtFuelStation");
        if (!needRefuel || this.ship.fuel >= 6.5) {
            if (needRefuel)
                this.setParameter("personalitiesOXP_flag_needRefuelAtFuelStation", false);
            return false;
        }

        let attempts = this.getParameter("personalitiesOXP_flag_refuelAtFuelStationAttempts") || 0;
        if (attempts >= 3) {
            this.setParameter("personalitiesOXP_flag_needRefuelAtFuelStation", false);
            return false;
        }

        return true;
    };

    prototype.internal_behaviourSetGoToFuelStationAI = function () {
        //This attempt counter was added mainly because I'm pretty sure I messed up somewhere.
        let attempts = this.getParameter("personalitiesOXP_flag_refuelAtFuelStationAttempts") || 0;
        this.setParameter("personalitiesOXP_flag_refuelAtFuelStationAttempts", attempts + 1);
        this.ship.setAI("fuelStation_gotoFuelStationAI.plist");
    };

    prototype.internal_conditionScannerContainsNonPolice = function () {
        return this.checkScannerWithPredicate(function (s) {
            return (s.scanClass == "CLASS_NEUTRAL");
        });
    };

    prototype.internal_conditionScannerContainsOffenderAboveThreshold = function () {
        const preyBountyThreshold = this.getParameter("personalitiesOXP_preyBountyThreshold") || this.fineThreshold() / 2;
        return this.checkScannerWithPredicate(function (s) {
            return s.isInSpace && s.bounty > preyBountyThreshold && s.scanClass != "CLASS_CARGO" && s.scanClass != "CLASS_ROCK" && s.scanClass != "CLASS_BUOY";
        });

    };

    prototype.internal_conditionAlwaysTrue = function () {
        return true;
    };

    prototype.internal_conditionAlwaysFalse = function () {
        return false;
    };

    prototype.internal_conditionCombatOddsSufficientToHelp = function () {
        var aggressor = this.getParameter("oolite_distressAggressor");
        var sender = this.getParameter("oolite_distressSender");
        if (aggressor && aggressor.isShip && sender && sender.isShip) {
            if (sender.bounty > aggressor.bounty) {
                var tmp = sender;
                sender = aggressor;
                aggressor = tmp;
            }
            this.ship.target = aggressor;

            if (this.parametric_internal_conditionCombatOddsSufficientToIntervene)
                return this.parametric_internal_conditionCombatOddsSufficientToIntervene();
            else if (this.parametric_internal_notconditionCombatOddsSufficientToIntervene)
                return !this.parametric_internal_notconditionCombatOddsSufficientToIntervene();
            else
                return false;
        }
    };

    prototype.internal_behaviourHelpAtDistressCall = prototype.behaviourRespondToDistressCall; // May change in future

    prototype.internal_conditionCombatOddsSufficientToFinishOff = function () {
        var aggressor = this.getParameter("oolite_distressAggressor");
        var sender = this.getParameter("oolite_distressSender");
        if (aggressor && aggressor.isShip && sender && sender.isShip) {
            this.ship.target = sender;

            if (this.parametric_internal_conditionCombatOddsSufficientToIntervene)
                return this.parametric_internal_conditionCombatOddsSufficientToIntervene();
            else if (this.parametric_internal_notconditionCombatOddsSufficientToIntervene)
                return !this.parametric_internal_notconditionCombatOddsSufficientToIntervene();
            else
                return false;
        }
    };

    prototype.internal_behaviourFinishOffAtDistressCall = prototype.behaviourDestroyCurrentTarget; // or behaviourCommenceAttackOnCurrentTarget would be better here?

    prototype.internal_conditionWantsRevenge = function() {
        
        if(missionVariables.personalities_killed_name) { 
            this.setParameter("oolite_flag_witchspacePursuit", true);
            return true;      
        }
        else {
            return false;
        }
    }

    prototype.internal_behaviourRevengeTarget = function() {
        this.ship.commsMessage(expandDescription("[personalities-revenge]"), player.ship);
        missionVariables.personalities_killed_name = null;
        this.behaviourDestroyCurrentTarget();
    }

    prototype.internal_priorityEmpty = {
        condition: function () { return false; }
    };

    prototype.internal_priorityVisitFuelStationIfNeeded = {
        condition: this.internal_conditionNeedFlyToFuelStation,
        behaviour: this.internal_behaviourSetGoToFuelStationAI,
        reconsider: 5
    };

    prototype.internal_templateEmpty = function () {
        return [{}];
    };

    prototype.internal_templateJumpFromCombat = function () {
        return [
            {
                condition: this.conditionWormholeNearby,
                configuration: this.configurationSetDestinationToNearestWormhole,
                behaviour: this.behaviourApproachDestination,
                reconsider: 15
            },
            {
                configuration: this.configurationSelectWitchspaceDestination,
                condition: this.conditionCanWitchspaceOut,
                behaviour: this.behaviourEnterWitchspace,
                reconsider: 15
            }
        ];
    };

    prototype.internal_templateFleeCombat = function () {
        return [
            {
                behaviour: this.behaviourFleeCombat,
                reconsider: 5
            }
        ];
    };

    prototype.internal_templateFlyToWitchpoint = function () {
        return [
            {
                configuration: this.configurationSetDestinationToWitchpoint,
                behaviour: this.behaviourApproachDestination,
                reconsider: 30
            }
        ];
    };

    prototype.internal_templateRepelCurrentTarget = function () {
        return [
            {
                behaviour: this.behaviourRepelCurrentTarget,
                reconsider: 5
            }
        ];
    };

    //#endregion

};

