"use strict";
this.name = "personalities-priorityai-ship-script";


this.$libPriorityAI;
this.$AIPersonality;

this.$AIController; // set by ai script

this.shipSpawned = function () {
	this.ship.primaryRole = "personalities";
	if (this.ship.AI === "personalitiesHunterAI.plist") this.ship.primaryRole = "hunter";

	this.$libPriorityAI = worldScripts["oolite-libPriorityAI"];
	this.$AIPersonality = "_" + this.ship.scriptInfo.name;
};

this.alertConditionChanged = function (newCondition, oldCondition) {
	// go to help player
};

this.shipLaunchedFromStation = function (station) {
	this.$AIController.communicate("personalitiesOXP_launch", {}, 1);
	// let message = this.$libPriorityAI._getCommunication("_personalitiesOXP", this.$AIPersonality, "personalitiesOXP_launch");
	// if (message) {
	// 	this.ship.commsMessage(message);
	// }
};

this.$lastAttacker = null;
this.$lastAttackedCommsTime = 0;
this.shipBeingAttacked = function (whom) {
	let timeSinceLastAttackedComms = this.$lastAttackedCommsTime - clock.adjustedSeconds;
	if (this.$lastAttacker !== whom && timeSinceLastAttackedComms > 15) {
		this.$AIController.communicate("personalitiesOXP_attacked", whom, 1);
		this.$lastAttacker = whom;
		this.$lastAttackedCommsTime = clock.adjustedSeconds;
	}
	else {
		this.$AIController.communicate("personalitiesOXP_attacked", whom, 3);
	}

};

this.shipFiredMissile = function (missile, target) {
	if (this.ship.scriptInfo.missiles === "unlimited") {
		this.ship.awardEquipment(missile.primaryRole);
	}
};

this.shipLaunchedFromStation = function () {
	ai.setParameter("personalitiesOXP_flag_launchedFromMainStation", true);
};

this.shipExitedWormhole = function () {
	ai.setParameter("personalitiesOXP_flag_launchedFromMainStation", false);
};

this.shipLaunchedEscapePod = function (pod) {
	this.shipDied();
	let name = this.ship.scriptInfo.name;
	let capturedMessage = this.$libPriorityAI._getCommunication("_personalitiesOXP", this.$AIPersonality, "personalitiesOXP_captured");

	pod.$$personalities_name = name;
	pod.$$personalities_capturedMessage = capturedMessage ? capturedMessage : null;
};

this.shipDied = function () {
	if (this.ship.AI === "nullAI.plist" && this.ship.AIScript === "oolite-nullAI.js") return;

	this.$AIController.communicate("personalitiesOXP_dead", {}, 1);
	// let message = this.$libPriorityAI._getCommunication("_personalitiesOXP", this.$AIPersonality, "personalitiesOXP_dead");
	// if (message) {
	// 	this.ship.commsMessage(message);
	// }
};
