/*

personalities-cholmondely-ship-script.js

Default ship script for plist AI, but tweaked for mistaken launches

Search lines with "Mistaken launch -", in that way indicated places with changes
*/
"use strict";


this.name = "personalities-ship-script";
this.author = "Commander McLane, modified by Alnivel";
this.description = "Script for ships with Cholmondely personality";
this.version = "0.9.1";

/* Params to tweak */ // Mistaken launch - Don't forget to add "mistakenLaunch" to messageTypes
this.$mistakenLaunchChance = 0.42; // [0, 1]
this.$mistakenLaunchRealizationTime = 1; // time in seconds after which the mistakenLaunch message (part before "{pause: _}") will be broadcasted 
this.$mistakenLaunchSwitchToDockingTime = 1; // time in seconds after message (or its part) broadcasted before ship switch to docking

/* Not handlers */
this.$chatter = function () {
    if (!this.ship.isCloaked && this.ship.AI !== "nullAI.plist" &&
        this.ship.AIState.substr(9, 4) !== "FLEE" &&
        this.ship.AIState.substr(9, 6) !== "ATTACK" &&
	!this.$mistakenLaunchNow) // Mistaken launch - delay usual chatter
	{
	log("Personalities_CommsDebug", "Info for " + this.ship.scriptInfo.displayName + ": They chats at " + clock.absoluteSeconds);
	this.$broadcastMessage("chatter");
	}
};

// Mistaken Launch
this.$mistakenLaunchNow = false;
this.$mistakenLaunchTimer;
this.$mistakenLaunchRealization = function () { // Mistaken launch - used with timer - delay to realize about unwanted launch
    this.$broadcastMessage("mistakenLaunch");
    this.$mistakenLaunchTimer = new Timer(this, this.$mistakenLaunchSwitchToDocking, this.$mistakenLaunchSwitchToDockingTime); // and delay to take back controls too
};

this.$mistakenLaunchSwitchToDocking = function () { 
	// Mistaken launch - switch to the standard docking AI with one difference - instead fight back when attacked it return to previus AI
    this.ship.setAI("personalitiesCholmondelyDockingAI.plist"); 
    this.$mistakenLaunchTimer = null;
};
//

this.$shipAttacking = function () {
    if (this.ship.target) this.$broadcastMessage("attack");
};

this.$broadcastMessage = function (messageType) {
    if (this.$availableMessageTypes[messageType]) {
        if (this.$continueMessageTimer) {
            this.$continueMessageTimer.stop();
        }

        const message = expandDescription("[personalities-" + this.ship.scriptInfo.name + "-" + messageType + "]");
        this.$broadcastMessageInternal(message);
    }
};

this.$broadcastMessageInternal = function (message) {
	const commandStart = message.indexOf("{");
	if (commandStart === -1) {// There is no command
		this.ship.commsMessage(message); // So broadcast as is
	}
	else {
		const commandDelimiter = message.indexOf(":");
		const commandEnd = message.indexOf("}");

		const command = message.substring(commandStart + 1, commandDelimiter);
		const commandParameter = message.substring(commandDelimiter + 1, commandEnd);

		if (command === "pause") {
			const sendNowPart = message.substring(0, commandStart);
			const sendWithDelayPart = message.substring(commandEnd + 1);
			const delay = +commandParameter || 0.25;

			if (this.$continueMessageTimer) {
				this.$continueMessageTimer.stop();
			}
			if (sendWithDelayPart)
				this.$continueMessageTimer = new Timer(this, this.$continueMessage.bind(this, sendWithDelayPart), delay);
			if (sendNowPart)
				this.ship.commsMessage(sendNowPart);
		}
		else {
			log("Personalities_CommsDebug", "Error for " + this.ship.scriptInfo.displayName + ": Failed when trying to parse a command in the message '" + message);
		}
	}
};

this.$continueMessageTimer = null;
this.$continueMessage = function continueMessage(messageContinuation) {
	this.ship.commsMessage(this.$broadcastMessageInternal(messageContinuation)); // parse for commands recursively 
};
/////

this.$availableMessageTypes = {/* messageType: boolean */ };
this.$initializeMessageTypes = function () {
	const typesAsString = expandDescription("[personalities-" + this.ship.scriptInfo.name + "-messageTypes]");
	if (typesAsString.indexOf("-messageTypes") !== -1) {
		log("Personalities_CommsDebug", "Error for " + this.ship.scriptInfo.displayName + ": Failed to find comm message types from description.plist");
	}
	else {
		const typesDictionary = this.$availableMessageTypes;
		const types = typesAsString.split(" ");
		let i = types.length;
		while (i--) {
			typesDictionary[types[i]] = true;
		}
	}
};

/* Handlers (and related) */

this.shipSpawned = function () {
	this.ship.primaryRole = "personalities";
	if (this.ship.AI === "personalitiesHunterAI.plist") this.ship.primaryRole = "hunter";

	this.$initializeMessageTypes();

	this.hitcounter = 2;
	if (this.ship.position.magnitude <= 25600) {
		this.$broadcastMessage("witchspace");
	}
	if (!this.$chatterTimer) this.$chatterTimer = new Timer(this, this.$chatter, Math.ceil((Math.random() * 6) + 10), Math.ceil((Math.random() * 20) + 40));
};

this.shipLaunchedFromStation = function () {
    this.ship.primaryRole = "personalities";
    if (this.ship.AI === "personalitiesHunterAI.plist") this.ship.primaryRole = "hunter";
    this.hitcounter = 2;

	// Mistaken launch - with some chance and delay start timer
    if (Math.random() < this.$mistakenLaunchChance) {
        this.$mistakenLaunchNow = true;
        this.$mistakenLaunchTimer = new Timer(this, this.$mistakenLaunchRealization, this.$mistakenLaunchRealizationTime);
    }
    else
    {
        this.$mistakenLaunchNow = false;
        this.$broadcastMessage("launch");
        if (this.ship.scriptInfo.launch === "jump") this.ship.reactToAIMessage("PREPARE_TO_JUMP");
    }
	//  
};

//Initiated from worldscript on PLAYER alert condition but there is a ship handler (only for station). Should change name?
this.alertConditionChanged = function (newCondition, oldCondition) {
	function isAttackingPlayer(entity) {
		//!!!
		return entity.isShip &&
			entity.hasHostileTarget && entity.target.isPlayer &&
			(entity.bounty > 0 || entity.hasRole("personalities_privateer")) &&
			!entity.isWeapon;
	}

	if (this.ship.AI !== "personalitiesHunterAI.plist") return;
	log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + " was informed: Alert condition changed from " + oldCondition + " to " + newCondition + ".");
	if (this.ship.position.distanceTo(player.ship) <= 25600 && player.bounty === 0) {

		var playerAttackers = system.filteredEntities(this, isAttackingPlayer, this.ship, 25600);
		var playerAttacker = playerAttackers[0];
		if (playerAttacker) {
			if (playerAttacker === this.ship) {
				log("Personalities_PlistAIDebug", "Player is under attack. Attack by " + this.ship.scriptIndisfo.playName + " so no rescue today.");
			}
			else {
				this.ship.target = playerAttacker;
				this.ship.AIFoundTarget = playerAttacker;
				this.ship.reactToAIMessage("TARGET_FOUND"); // Seems this.ship.AIFoundTarget should be set, not this.ship.target
				log("Personalities_PlistAIDebug", "Player is under attack. " + this.ship.scriptInfo.displayName + " to the rescue.");
			}

		}
	}
};

this.shipBeingAttacked = function (whom) {
	this.$mistakenLaunchTimer = null;
	if (this.ship.AI === "nullAI.plist") return;
	if (((this.ship.scriptInfo.attacked === "flee") || (this.ship.scriptInfo.energyDown === "flee" && this.ship.energy < this.ship.maxEnergy / 2)) && this.ship.AIState.substr(9, 4) !== "FLEE" && !this.fleeMessage) {
		var currentAIState = this.ship.AIState;
		this.hitcounter = 40;
		if (this.ship.fuel < 1) this.ship.fuel = 3;
		log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + " being attacked, setting AIState to FLEE.");
		this.ship.AIState = (currentAIState.substr(0, 9) + "FLEE");
		return;
	}
	if (this.ship.scriptInfo.energyDown === "cloak" && this.ship.energy < this.ship.maxEnergy / 2 && oolite.compareVersion("1.74") < 0) {
		this.ship.awardEquipment("EQ_CLOAKING_DEVICE");
		this.ship.isCloaked = true;
		this.$broadcastMessage("cloaking");
	}
	if (whom.isPlayer) {
		this.hitcounter--;
		if (this.hitcounter < 1) {
			this.$broadcastMessage("attacked");
			this.hitcounter = Math.ceil(Math.random() * 10) + 10;
		}
	}
};

this.shipAttackedWithMissile = function (missile, whom) {
	if (this.ship.AI === "nullAI.plist") return;
	if (whom.isPlayer) {
		this.hitcounter--;
		if (this.hitcounter < 1) {
			this.$broadcastMessage("attacked");
			this.hitcounter = Math.ceil(Math.random() * 10) + 10;
		}
	}
};

this.shipFiredMissile = function (missile, target) {
	if (this.ship.scriptInfo.missiles === "unlimited") {
		this.ship.awardEquipment(missile.primaryRole);
	}
};

//Initiated from plist but now exist shipTargetCloaked
this.$targetCloaked = function () {
	log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + "'s target has cloaked: " + this.ship.target);
	this.$cloakedTarget = this.ship.target;
	if (this.$targetCloakingTimer) this.$targetCloakingTimer.start();
	else this.$targetCloakingTimer = new Timer(this, this.targetCloakCheck, 1, 1);
};

this.targetCloakCheck = function () {
	if (!this.$cloakedTarget) {
		this.$targetCloakingTimer.stop();
	}
	else if (!this.$cloakedTarget.isCloaked && (!this.ship.target || this.ship.target.scanClass === "CLASS_CARGO")) {
		this.ship.target = this.$cloakedTarget;
		this.$cloakedTarget = null;
		this.ship.reactToAIMessage("TARGET_DECLOAKED");
		this.$targetCloakingTimer.stop();
	}
};

this.shipEnergyIsLow = function () {
	if (this.ship.AI === "nullAI.plist") return;
	if (this.ship.scriptInfo.energyLow) {
		if (this.ship.scriptInfo.energyLow === "jump" && this.ship.AIState !== "JUMP_OUT") {
			this.$broadcastMessage("jump");
			this.hitcounter = 40;
			log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + " energy low, setting AIState to JUMP_OUT.");
			this.ship.AIState = ("JUMP_OUT");
			this.ship.fuel = 7;
			return;
		}
		if (this.ship.scriptInfo.energyLow === "flee" && this.ship.AIState.substr(9, 4) !== "FLEE" && !this.fleeMessage) {
			var currentAIState = this.ship.AIState;
			this.hitcounter = 40;
			if (this.ship.fuel < 1) this.ship.fuel = 3;
			log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + " energy low, setting AIState to FLEE.");
			this.ship.AIState = (currentAIState.substr(0, 9) + "FLEE");
		}
	}
};

this.shipLostTarget = function () {
	this.startDecloakingTimer(15);
};

this.shipDestroyedTarget = function () {
	this.$broadcastMessage("kill");
	this.startDecloakingTimer(5);
};

this.startDecloakingTimer = function (delay) {
	if (!this.ship.isCloaked) return;
	if (!this.$decloakingTimer) {
		this.$decloakingTimer = new Timer(this, this.$switchCloakOff, delay);
		log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + "'s cloaking timer: " + clock.absoluteSeconds + " " + delay + " " + this.$decloakingTimer.nextTime);
		return;
	}
	if (this.$decloakingTimer.isRunning) this.$decloakingTimer.stop();
	this.$decloakingTimer.nextTime = clock.absoluteSeconds + delay;
	this.$decloakingTimer.start();
	log("Personalities_PlistAIDebug", this.ship.scriptInfo.displayName + "'s cloaking timer: " + clock.absoluteSeconds + " " + delay + " " + this.$decloakingTimer.nextTime);
};

this.$switchCloakOff = function () {
	if (this.ship.isCloaked) this.ship.isCloaked = false;
	if (this.ship.scriptInfo.energyDown === "cloak" && oolite.compareVersion("1.74") < 0) {
		this.ship.removeEquipment("EQ_CLOAKING_DEVICE");
	}
};

this.playerWillEnterWitchspace = function () {
	this.$chatterTimer.stop();
	this.$chatterTimer = null;
	if (this.$targetCloakingTimer) {
		this.$targetCloakingTimer.stop();
		this.$targetCloakingTimer = null;
	}
	if (this.$decloakingTimer) {
		this.$decloakingTimer.stop();
		this.$decloakingTimer = null;
	}
};

this.shipLaunchedEscapePod = function (pod) {
	this.$broadcastMessage("dead");
	let name = this.ship.scriptInfo.name;

	pod.$$personalities_name = name;
	pod.$$personalities_capturedMessage = this.$availableMessageTypes["captured"] ?
		expandDescription("[personalities-" + name + "-captured]") :
		null;
	//ssssssssssssssssssssssssssssssssssssssssssa555 + !!!!


	// if (this.$availableMessageTypes["captured"]) {

	// }
	// worldScripts.personalities.$registerPersonalityPod(name, pod, "[personalities-" +  + "-" + messageType + "]");
};

this.shipDied = function () {
	this.$chatterTimer.stop();
	this.$chatterTimer = null;
	if (this.$targetCloakingTimer) {
		this.$targetCloakingTimer.stop();
		this.$targetCloakingTimer = null;
	}
	if (this.$decloakingTimer) {
		this.$decloakingTimer.stop();
		this.$decloakingTimer = null;
	}
	// Isn't needed?
	// if(this.ship.scriptInfo.maxCargo);
	// {
	// 	if(this.ship.scriptInfo.cargoType)
	// 	{
	// 		this.ship.spawn("cargopod", Math.ceil(Math.random() * this.ship.scriptInfo.maxCargo * 4 / 3));
	// 		this.ship.spawn(this.ship.scriptInfo.cargoType, Math.ceil(Math.random() * this.ship.scriptInfo.maxCargo / 4));
	// 	}
	// 	else
	// 	{
	// 		this.ship.spawn("cargopod", Math.ceil(Math.random() * this.ship.scriptInfo.maxCargo));
	// 	}
	// }
	if (this.ship.AI === "nullAI.plist") return;
	this.$broadcastMessage("dead");
};

/* Functions for plist AI */
this.$checkForJumpOut = function () {
	if (this.ship.scriptInfo.launch === "jump") this.ship.AIState = "JUMP_OUT";
	else if (Math.random() < 0.25) this.ship.AIState = "JUMP_OUT";
	else this.ship.reactToAIMessage("CONTINUE_IN_SYSTEM");
};

this.$restoreFleeMessage = function () {
	this.fleeMessage = null;
};

this.$shipFleeing = function () {
	if (!this.fleeMessage) {
		this.$broadcastMessage("flee");
		this.fleeMessage = true;
	}
};

// scanFor* - used mostly in plist
this.$scanForPrey = function () {
	function isTrader(entity) {
		return entity.isShip && entity.isPirateVictim && !entity.isCloaked;
	}
	function isMyVictim(entity) {
		return entity.isShip && (entity.isPirateVictim || entity.isPirate || entity.isThargoid) && !entity.isCloaked;
	}

	if (this.ship.scriptInfo.name === "kaks") {
		system.shipsWithRole("EQ_QC_MINE", this.ship, 25600).forEach(function (ship) { ship.explode(); });
		system.shipsWithRole("EQ_RMB_CASCADE_MISSILE", this.ship, 25600).forEach(function (ship) { ship.explode(); });
	}
	if (missionVariables.personalities_killed_name && this.ship.scriptInfo.displayName !== missionVariables.personalities_killed_name && this.ship.position.distanceTo(player.ship) < 25600 && !player.ship.isCloaked) {
		player.bounty += 25;
		this.ship.target = player.ship;
		this.ship.commsMessage(expandDescription("[personalities-revenge]"), player.ship);
		delete missionVariables.personalities_killed_name;
		this.ship.AIFoundTarget = player.ship;
		this.ship.reactToAIMessage("TARGET_FOUND");
		return;
	}
	if (system.entitiesWithScanClass("CLASS_POLICE", this.ship, 40000).length === 0 && !this.ship.withinStationAegis) {
		if (this.ship.scriptInfo.prey === "traders" && !this.ship.target && Math.random() < this.ship.scriptInfo.attackProbability) {
			var nextTarget = system.filteredEntities(this, isTrader, this.ship, 25600);
			if (nextTarget[0]) {
				this.ship.target = nextTarget[0];
				this.ship.AIFoundTarget = nextTarget[0];
				this.ship.reactToAIMessage("TARGET_FOUND");
			}
			return;
		}
		if (this.ship.scriptInfo.prey === "everybody" && !this.ship.target && Math.random() < this.ship.scriptInfo.attackProbability) {
			var nextTarget = system.filteredEntities(this, isMyVictim, this.ship, 25600);
			if (nextTarget[0]) {
				this.ship.target = nextTarget[0];
				this.ship.AIFoundTarget = nextTarget[0];
				this.ship.reactToAIMessage("TARGET_FOUND");
				return;
			}
		}
	}
	this.$scanForAsteroids();
};

this.$scanForOffenders = function () {
	function isOffender(entity) {
		return entity.isShip && entity.bounty >= this.ship.scriptInfo.preyLimit && !entity.isCloaked;
	}

	if (missionVariables.personalities_killed_name && this.ship.scriptInfo.displayName !== missionVariables.personalities_killed_name && this.ship.position.distanceTo(player.ship) < 25600 && !player.ship.isCloaked) {
		player.bounty += 25;
		this.ship.target = player.ship;
		this.ship.commsMessage(expandDescription("[personalities-revenge]"), player.ship);
		delete missionVariables.personalities_killed_name;
		this.ship.AIFoundTarget = player.ship;
		this.ship.reactToAIMessage("TARGET_FOUND");
		return;
	}
	if (this.ship.scriptInfo.prey === "thargoids" && !this.ship.target) {
		if (system.entitiesWithScanClass("CLASS_THARGOID", this.ship, 25600).length !== 0 && Math.random() < this.ship.scriptInfo.attackProbability) {
			this.ship.target = system.entitiesWithScanClass("CLASS_THARGOID", this.ship, 25600)[0];
			this.ship.AIFoundTarget = this.ship.target;
			this.ship.reactToAIMessage("TARGET_FOUND");
		}
		return;
	}
	if (this.ship.scriptInfo.prey === "offenders" && !this.ship.target && Math.random() < this.ship.scriptInfo.attackProbability) {
		var nextTarget = system.filteredEntities(this, isOffender, this.ship, 25600);
		if (nextTarget[0]) {
			this.ship.target = nextTarget[0];
			this.ship.AIFoundTarget = this.ship.target;
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
	}
	this.$scanForAsteroids();
};

this.$scanForAsteroids = function () {
	if (this.ship.scriptInfo.miningProbability) {
		if (system.shipsWithPrimaryRole("asteroid", this.ship, 25600).length !== 0 && Math.random() < this.ship.scriptInfo.miningProbability) {
			this.ship.setAI("personalitiesMinerAI.plist");
		}
	}
};
