"use strict";

this.name = "Personalities Privateer AI";

this.controller;
this.aiStarted = function () {
    const scriptInfo = this.ship.scriptInfo;

    const ai = this.ship.script.$AIController = new worldScripts["personalities-priorityAI"].PersonalityPriorityAIController(this.ship);
    worldScripts.personalities._registerCommsOfPersonalitiesWithPriorityAI([scriptInfo.name]);

    ai.setParameter("oolite_flag_watchForCargo", true); // Is really need?
    ai.setWaypointGenerator(ai.waypointsSpacelanePatrol);
    ai.setParameter("oolite_flag_listenForDistressCall", true);

    ai.setPriorities([
        {
            condition: ai.conditionLosingCombat,
            truebranch: ai.parametric_templateLosingCombat(),
            reconsider: 5
        },
        {
            condition: ai.parametric_conditionShiledDepleted,
            truebranch: ai.parametric_templateShildsDepleted(),
        },
        {
            condition: ai.conditionInCombat,
            configuration: ai.configurationAcquireCombatTarget,
            behaviour: ai.parametric_behaviourBeingAttacked,
            reconsider: 5
        },
        {
            condition: ai.conditionHasReceivedDistressCall,
            truebranch: [
                {
                    condition: ai.parametric_conditionMinimalCombatOdds,
                    notcondition: ai.parametric_notconditionMinimalCombatOdds,
                    behaviour: ai.parametric_behaviourInterveneAtDistressCall,
                    reconsider: 20
                },
                {
                    behaviour: ai.parametric_behaviourNotInterveneAtDistressCall,
                    reconsider: 20
                }
            ]
        },
        ai.parametric_priorityVisitFuelStationIfNeeded,
        {
            condition: ai.parametric_conditionNeedSunskim,
            truebranch: [
                {
                    condition: ai.conditionReadyToSunskim,
                    configuration: ai.configurationSetDestinationToSunskimEnd,
                    behaviour: ai.behaviourSunskim,
                    reconsider: 20
                },
                {
                    condition: ai.conditionSunskimPossible,
                    configuration: ai.configurationSetDestinationToSunskimStart,
                    behaviour: ai.behaviourApproachDestination,
                    reconsider: 30
                }
            ]
        },
        {
            condition: ai.conditionPlayerNearby,
            configuration: ai.parametric_behaviourChatWithPlayer // use it as configuration to not interrupt normal actions with just talking
        },
        {
            condition: ai.parametric_conditionLaunchedFromStation,
            truebranch: ai.parametric_templateAfterLaunch()
        },

        {
            condition: ai.conditionSuppliesLow,
            truebranch: ai.templateReturnToBaseOrPlanet()
        },

        {
            preconfiguration: ai.configurationCheckScanner,
            condition: ai.conditionScannerContainsSalvageForMe,
            configuration: ai.configurationAcquireScannedTarget,
            behaviour: ai.behaviourCollectSalvage,
            reconsider: 20
        },
        {
            condition: ai.parametric_conditionScannerContainsMiningOpportunityAndPersonalityWantUseIt,
            configuration: ai.configurationAcquireScannedTarget,
            behaviour: ai.behaviourMineTarget,
            reconsider: 20
        },

        {   // fly out of sight of police
            condition: ai.conditionScannerContainsHunters,
            configuration: ai.configurationAcquireScannedTarget,
            behaviour: ai.behaviourLeaveVicinityOfTarget,
            reconsider: 20
        },
        {   // searching for victim 
            condition: ai.parametric_conditionScannerContainsPrey, // varied by scriptInfo params 
            configuration: ai.configurationAcquireScannedTarget,
            truebranch: {
                // intended use only one of *condition-s, but if condition set with falsy value notcondition will be checked
                condition: ai.parametric_conditionMinimalCombatOdds, // good or excelent 
                notcondition: ai.parametric_notconditionMinimalCombatOdds, // not bad and not terrible 
                behaviour: ai.behaviourDestroyCurrentTarget,
                reconsider: 20
            }
        },


        { // patrolling spaceline
            condition: ai.conditionHasWaypoint,
            configuration: ai.configurationSetDestinationToWaypoint,
            behaviour: ai.behaviourApproachDestination,
            reconsider: 30
        },
        {
            condition: ai.conditionPatrolIsOver,
            truebranch: [
                {
                    condition: ai.conditionCoinFlip,
                    truebranch: ai.templateReturnToBaseOrPlanet(),
                    falsebranch: ai.templateWitchspaceJumpOutbound()
                }
            ]
        },
        {
            configuration: ai.configurationSetWaypoint,
            behaviour: ai.behaviourApproachDestination,
            reconsider: 30
        },


        {
            condition: ai.conditionGroupHasEnoughLoot,
            truebranch: ai.templateReturnToBaseOrPlanet()
        },
    ].concat(ai.templateWitchspaceJumpAnywhere()));


};