"use strict";

this.name = "Personalities Cruiser AI";

this.controller;
this.aiStarted = function () {
	const scriptInfo = this.ship.scriptInfo;

	const ai = this.ship.script.$AIController = new worldScripts["personalities-priorityAI"].PersonalityPriorityAIController(this.ship);
	worldScripts.personalities._registerCommsOfPersonalitiesWithPriorityAI([scriptInfo.name]);

	ai.setParameter("oolite_flag_listenForDistressCall", true);

	ai.setPriorities([
		{
			condition: ai.conditionLosingCombat,
			truebranch: ai.parametric_templateLosingCombat(),
			reconsider: 5
		},
		{
			condition: ai.parametric_conditionShiledDepleted,
			truebranch: ai.parametric_templateShildsDepleted(),
		},
		{
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.parametric_behaviourBeingAttacked,
			reconsider: 5
		},
		{
			condition: ai.conditionHasReceivedDistressCall,
			truebranch: [
				{
					condition: ai.parametric_conditionMinimalCombatOdds,
					notcondition: ai.parametric_notconditionMinimalCombatOdds,
					behaviour: ai.parametric_behaviourInterveneAtDistressCall,
					reconsider: 20
				},
				{
					behaviour: ai.parametric_behaviourNotInterveneAtDistressCall,
					reconsider: 20
				}
			]
		},
		ai.parametric_priorityVisitFuelStationIfNeeded,
		{
			condition: ai.parametric_conditionNeedSunskim,
			truebranch: [
				{
					condition: ai.conditionReadyToSunskim,
					configuration: ai.configurationSetDestinationToSunskimEnd,
					behaviour: ai.behaviourSunskim,
					reconsider: 20
				},
				{
					condition: ai.conditionSunskimPossible,
					configuration: ai.configurationSetDestinationToSunskimStart,
					behaviour: ai.behaviourApproachDestination,
					reconsider: 30
				}
			]
		},
		{
			condition: ai.conditionPlayerNearby,
			configuration: ai.parametric_behaviourChatWithPlayer // use it as configuration to not interrupt normal actions with just talking
		},
		{
			condition: ai.conditionHostileStationNearby,
			configuration: ai.configurationSetDestinationToNearestStation,
			behaviour: ai.behaviourLeaveVicinityOfDestination,
			reconsider: 20
		},
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionScannerContainsSalvageForMe,
			configuration: ai.configurationAcquireScannedTarget,
			behaviour: ai.behaviourCollectSalvage,
			reconsider: 20
		},
		{
			condition: ai.parametric_conditionScannerContainsMiningOpportunityAndPersonalityWantUseIt,
			configuration: ai.configurationAcquireScannedTarget,
			behaviour: ai.behaviourMineTarget,
			reconsider: 20
		},
		{
			condition: ai.parametric_conditionLaunchedFromStation,
			truebranch: ai.parametric_templateAfterLaunch(),
			falsebranch: ai.templateReturnToBase()
		},
		{
			condition: ai.conditionFriendlyStationNearby,
			configuration: ai.configurationSetNearbyFriendlyStationForDocking,
			behaviour: ai.behaviourDockWithStation,
			reconsider: 30
		},
		{
			condition: ai.conditionFriendlyStationExists,
			configuration: ai.configurationSetDestinationToNearestFriendlyStation,
			behaviour: ai.behaviourApproachDestination,
			reconsider: 30
		}
	].concat(ai.templateWitchspaceJumpAnywhere()));


};