this.name        = "rockHermit_Locator"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "This script places buoys at rockHermites and Pirate Coves.  It is a translation of the legacy code of Frame"; 
this.version     = "1.2.3"; 

this.reset = this.startUp = function()
{
    this.buoysAdded = false
}

this.abs2pwm=function(pos){
	let w=system.shipsWithRole('buoy-witchpoint')[0].position;
	let p=system.mainPlanet.position;	
	let z=p.subtract(w).direction();
	let x=p.subtract(system.sun.position).direction();
	let y=z.cross(x);
	x=z.cross(y);
	let v=pos.subtract(p);
	let d=v.direction();
	let l=v.magnitude();
	return [d.dot(x)*l,d.dot(y)*l,-d.dot(z)*l];
}

this.shipExitedWitchspace = function()
{
    this.buoyTimer = new Timer(this, this.addBuoys, 1)
}

this.addBuoys = function()
{
    if(player.hasEquipment("EQ_ROCKHERMIT_SCANNER")) this.buoy = "rockbeacon"; else this.buoy = "rockbeacof"
    let rockHermits = system.shipsWithPrimaryRole("rockhermit");
    let pirateCoves = system.shipsWithPrimaryRole("pirate-cove");
    if(oolite.compareVersion("1.71") > 0)
    {   // use the less presize position calculation for Oolite 1.70
        for (let i=0; i<rockHermits.length;i++)
        {
            if(rockHermits[i].shipDescription == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "pwm", this.abs2pwm(rockHermits[i].position.add(0,0,6000)))
        }
        for (let i=0; i<pirateCoves.length;i++)
        {
            if(pirateCoves[i].shipDescription == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "pwm", this.abs2pwm(pirateCoves[i].position.add(0,0,6000)))
        }
    }
    else
    {
        for (let i=0; i<rockHermits.length;i++)
        {
            if(rockHermits[i].shipDescription == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "abs", rockHermits[i].position.add(rockHermits[i].heading.multiply(9000)))
        }
        for (let i=0; i<pirateCoves.length;i++)
        {
            if(pirateCoves[i].shipDescription == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "abs", pirateCoves[i].position.add(pirateCoves[i].heading.multiply(9000)))
        }
    }
    this.buoysAdded = true
}

this.removeOffBuoys = function()
{
    let buoys = system.shipsWithPrimaryRole("rockbeacof");
    if(buoys.length>0) for (let i=0; i<buoys.length;i++)
        {
            buoys[i].setPosition(buoys[i].position.multiply(100))
            if(0 > oolite.compareVersion("1.70")) buoys[i].explode()
        }
    this.buoysAdded = false;
}

this.shipLaunchedFromStation = function()
{
    if(this.buoysAdded && this.buoy == "rockbeacof" && player.hasEquipment("EQ_ROCKHERMIT_SCANNER")) this.removeOffBuoys()
    if(!this.buoysAdded) this.addBuoys()
}