
"use strict";
/* ========================================================
		BACKGROUND ZOOM EXPERIMENT OXP

    Created by Karl Smith ("Wildeblood"), July, 2024.
    If made public, will be called "Distant Space" OXP,
    because the images zoom out, not in, and it slips into
    alphabetical listings between "Distant Realms" and 
    "Distant Suns".
=========================================================== */

    this.name    = "zoom";
    this.version = "a 1.0";

/* ========================================================
	BACKGROUND IMAGES ZOOM OUT ENTERING GUI SCREENS

 1. On entering any screen, F3-F8, we run a 32-step zoom-out
    animation on the background image. It looks cool.
 2. Because we use one image, and only change the scaling factor,
    we cunningly avoid stuttering caused by loading image files.
    That's what I'm hoping for, anyway.
 3. If stuttering does occur, because Oolite repeatedly reloads
    the same image, complain bitterly that that is obviously a
    bug in Oolite which someone else needs to fix. 
 4. It will look cool. Trust me, Bro. (UPDATE: concept verified.
    As predicted, it does look cool.)
 5. Obviously, this only applies while docked.
=========================================================== */

/* ========================================================
		THIS IS A PROOF-OF-CONCEPT ONLY

 6. For this demonstration, we only use some screens.
 6a. Next up, either F3 with alternative "refuel" image, or
 6b. F4 with alternative "You have mail" image, or         
 6c. F7 with alternative "already visited" image.
 7. Alpha 1: Use 0.25s timer to create 8 second animation. <<< YOU ARE HERE. :-)
 8. Alpha 2: Use FCB to average 24 updates per second,
    giving 1.3 second animation.
 9. Review time. Make DECISION: Continue, or abandon idea.
=========================================================== */

/* ========================================================
		THOUGHT OF THE DAY, AUGUST 3rd

    Thinking of Mum, obviously.

    Re: this script, given the player won't get a good look
    at the background while it's zooming, is there a case for
    using 1024 x 512 PNGs for the first 31 steps, then
    substituting the quality 2048 x 1024 image at the last step?
    "The Weekly says, 'Yes'." 
    "Computer says, 'No'."
    This didn't start out to be a commentry on the difference
    between Australian and British culture, it was a serious
    question? 
=========================================================== */

    this._zoomMax = 1024;
    this._zoomMin = 512;  // 1024 - 512 = 512
    this._zoomStep = 16;  //    32 x 16 = 512

/* ========================================================
		ZOOM RANGE EXPLAINED

    [Add explanation of why the above 3 numbers are what they
    are.] This is the only place those numbers are explicitly
    used; everywhere else refers to these variables, so 
    trouble-makers with ultra-wide monitors can set higher
    values here. For normal people, for now, "Trust me, Bro."

    The next few are used while an animation is in progress.
=========================================================== */

    this._zooming = false;  // true while the animation is running.
    this._zoomSize = null;  // Varies while the animation is running.
 // this._zoomName = null;  // Holds the ID of the frame callback while it's running.
    this._zoomImage = null; // Name of current image file.

    this.startUpComplete = function () {

     // Checking for Explorers' Club...
        if (!worldScripts["Explorers Club"]) {
            this.infoSystemChanged = this._NO_chooseImageForF7;
        }
        delete this._NO_chooseImageForF7;

     // Checking for EmailSystem...
        if (!worldScripts["EmailSystem"]) {
            this._chooseImageForF4 = this._NO_chooseImageForF4;
        }
        delete this._NO_chooseImageForF4;

        if (player.ship.docked) {
            this.shipDockedWithStation();
        }
     // The mount weapon screen is not scriptable, so set it once and forget about it.
        setScreenBackgroundForKey("mount_weapon", { name: "zoom_zoomable_mount_weapon.png", height: this._zoomMin });
     // The -1 in a timer definition indicates it's stopped, not running yet.
        this._zoomTimer = new Timer(this, _zoomOut.bind(this), -1, 0.25);
     // delete this.startUpComplete;
    }

/* ========================================================
		THINGS TO DO DURING START-UP

 1. Check for emailSystem; if not present, an alternative,
    simpler shipDockedWithStation can be substituted. DONE.

 2. Check for Explorers' Club; if not present, an alternative,
    simpler shipDockedWithStation can be substituted. DONE.

 3. In a distant future version, scan other scripts for
    compatible mission screens, and sytem data screens.

 4. Check the window dimensions, and possibly fiddle with
    the zoom range defined above.

    That's all the set-up needed. Now it's just 3 functions:

    The shipDockedWithStation event resets all the images to
    their starting scale (possibly unnecessary), and selects
    the image for screens with alternatives:

    The guiScreenChanged event decides whether the new screen 
    is one to animate, or one to ignore, and calls _zoomOut:

    The _zoomOut function starts, stops and advances the
    animation, all in one place.

    [Well, that plan didn't last.]
=========================================================== */

    this.shipDockedWithStation = function (station) {
        "use strict";
        setScreenBackgroundForKey("options", {name: "distant_space_intro_r.png", height: this._zoomMax});
        setScreenBackgroundForKey("equip_ship", {name: this._chooseImageForF3(false), height: this._zoomMax});
        setScreenBackgroundForKey("shipyard", {name: "zoom_zoomable_shipyard.png", height: this._zoomMax});
        setScreenBackgroundForKey("interfaces", {name: this._chooseImageForF4(false), height: this._zoomMax});
        setScreenBackgroundForKey("report", {name: "zoom_zoomable_arrival_report.png", height: this._zoomMax});
        setScreenBackgroundForKey("status_docked", {name: "zoom_zoomable_status_docked.png", height: this._zoomMax});
        setScreenBackgroundForKey("manifest", {name: "zoom_zoomable_manifest.png", height: this._zoomMax});
        setScreenBackgroundForKey("short_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMax});
        setScreenBackgroundForKey("long_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMax});
        setScreenBackgroundForKey("system_data", {name: this._imageForF7, height: this._zoomMax});
        setScreenBackgroundForKey("market", {name: "zoom_zoomable_market.png", height: this._zoomMax});
        setScreenBackgroundForKey("marketinfo", {name: "zoom_zoomable_marketinfo.png", height: this._zoomMax});
    }

/* ========================================================
    Oops, better make that say, "It's just 4 functions."
    It's going to need the shipLaunchedFromStation event to
    reset some of those backgrounds to fully zoomed-out.
=========================================================== */

    this.shipLaunchedFromStation = function (station) {
        "use strict";
        setScreenBackgroundForKey("options", {name: "distant_space_intro_r.png", height: this._zoomMin});
        setScreenBackgroundForKey("manifest", {name: "zoom_zoomable_manifest.png", height: this._zoomMin});
        setScreenBackgroundForKey("short_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMin});
        setScreenBackgroundForKey("long_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMin});
        setScreenBackgroundForKey("system_data", {name: "zoom_zoomable_system_data.png", height: this._zoomMin});
        setScreenBackgroundForKey("market", {name: "zoom_zoomable_market.png", height: this._zoomMin});
        setScreenBackgroundForKey("marketinfo", {name: "zoom_zoomable_marketinfo.png", height: this._zoomMin});
    }

/* ========================================================
    Maybe make that say, "It's just 5 functions."

    This is in case the player changes screens rapidly,
    before the animation has finished.
    guiScreenWillChange is not called on every screen change,
    only the popular ones, so this does not prevent all
    occasional flashes. This still requires some thought.
=========================================================== */

    this.guiScreenWillChange = function (to, from) {
        "use strict";
        if (this._zooming) {
            this._zoomTimer.stop();
            this._zooming = false;
        }
    }

/* ========================================================
		THIS IS WHAT YOU CAME TO SEE

    Okay, that's enough teasing. These are the critical bits.
    And, they are just TWO functions.

    The guiScreenChanged below is a ring-in. It's growing
    "organically" (messily), as I experiment. It should just 
    be a list of supported screens, then the timer started.
=========================================================== */

    this._pausedForMissionScreens = false;

    this.missionScreenOpportunity = function () {
        this._pausedForMissionScreens = false;
        this.guiScreenChanged(guiScreen, "GUI_SCREEN_MISSION");
    }

    this.guiScreenChanged = function (to, from) {
        "use strict";
        if (!player.ship.docked ||
            this._pausedForMissionScreens) {
            return;
        }
        if (guiScreen == "GUI_SCREEN_MISSION") {
            this._pausedForMissionScreens = true;
            return;
        }
        if (guiScreen == "GUI_SCREEN_EQUIP_SHIP") {
            this._chooseImageForF3(true);
        } else if (guiScreen == "GUI_SCREEN_INTERFACES") {
            this._chooseImageForF4(true);
        } else if (guiScreen == "GUI_SCREEN_STATUS") {
            this._zoomImage = "zoom_zoomable_status_docked.png";
        } else if (guiScreen == "GUI_SCREEN_MANIFEST") {
            this._zoomImage = "zoom_zoomable_manifest.png";
        } else if (guiScreen == "GUI_SCREEN_SHORT_RANGE_CHART" ||
            guiScreen == "GUI_SCREEN_LONG_RANGE_CHART") {
            this._zoomImage = "zoom_zoomable_chart.png";
        } else if (guiScreen == "GUI_SCREEN_SYSTEM_DATA") {
            this._zoomImage = this._imageForF7;
        } else if (guiScreen == "GUI_SCREEN_MARKET") {
            this._zoomImage = "zoom_zoomable_market.png";
        } else if (guiScreen == "GUI_SCREEN_MARKETINFO") {
            this._zoomImage = "zoom_zoomable_marketinfo.png";
        } else if (guiScreen == "GUI_SCREEN_OPTIONS") {
            this._zoomImage = "distant_space_intro_r.png";
        } else if (guiScreen == "GUI_SCREEN_SHIPYARD") {
            this._zoomImage = "zoom_zoomable_shipyard.png";
        } else {
            this._zoomImage = null;
        }
        if (this._zoomImage) {
            this._zoomTimer.start();
        }

     // Reset screen background for key back to height 1024.
     // I'm still not sure this is the correct thing to do.
     // Did it ever actually change? If not, should it have?

        if (from == "GUI_SCREEN_STATUS") {
            setScreenBackgroundForKey("status_docked", {name: "zoom_zoomable_status_docked.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_MANIFEST") {
            setScreenBackgroundForKey("manifest", {name: "zoom_zoomable_manifest.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_SHORT_RANGE_CHART" ||
            from == "GUI_SCREEN_LONG_RANGE_CHART") {
            setScreenBackgroundForKey("short_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMax});
            setScreenBackgroundForKey("long_range_chart", {name: "zoom_zoomable_chart.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_SYSTEM_DATA") {
            setScreenBackgroundForKey("system_data", {name: this._imageForF7, height: this._zoomMax});
        } else if (from == "GUI_SCREEN_MARKET") {
            setScreenBackgroundForKey("market", {name: "zoom_zoomable_market.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_MARKETINFO") {
            setScreenBackgroundForKey("marketinfo", {name: "zoom_zoomable_marketinfo.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_INTERFACES") {
            setScreenBackgroundForKey("interfaces", {name: this._chooseImageForF4(false), height: this._zoomMax});
        } else if (from == "GUI_SCREEN_EQUIP_SHIP") {
            setScreenBackgroundForKey("equip_ship", {name: this._chooseImageForF3(false), height: this._zoomMax});
        } else if (from == "GUI_SCREEN_SHIPYARD") {
            setScreenBackgroundForKey("shipyard", {name: "zoom_zoomable_shipyard.png", height: this._zoomMax});
        } else if (from == "GUI_SCREEN_OPTIONS") {
            setScreenBackgroundForKey("options", {name: "distant_space_intro_r.png", height: this._zoomMax});
        }
    }

    this._zoomOut = function _zoomOut () {
        if (this._zooming) {
         // We've already started; just advance one step...
            this._zoomSize -= this._zoomStep;
            setScreenBackground({ name: (this._zoomImage), height: (this._zoomSize) });
         // Then check if we've reached the end...
            if (this._zoomSize <= this._zoomMin) {
                this._zoomTimer.stop();
                this._zooming = false;

             // RIGHT HERE is the point I think we need to use
             // setScreenBackgroundForKey() to set the key equal to _zoomMin.
             // Else, what happens if something causes the screen to re-draw?

            }
        } else {
         // Let's get started...
            this._zooming = true;
            this._zoomSize = this._zoomMax;
            setScreenBackground({ name: (this._zoomImage), height: (this._zoomSize) });
        }
    }

/* ========================================================
			THE END

    Oh, wait, we need to catch the player buying fuel, to 
    change the F3 image. Make that say, "Just 6 functions."
=========================================================== */

    this.playerBoughtEquipment = function (equipment) {
        if (equipment == "EQ_FUEL") {
            this._zoomImage = "zoom_zoomable_equip_ship.png";
            this._zoomTimer.start();
        }
    }

/* ========================================================
		FUTURE FUNCTIONS FAMOUSLY UNFULFILLED

    You didn't think the first appearance of "the end" was
    definitive, did you? We're going to also need these...
    (Make that say, "Just 10 functions.")
=========================================================== */

    this._chooseImageForF3 = function (setZoom) {
        "use strict";
        var img = "zoom_zoomable_equip_ship.png";
        if (player.ship.fuel < 7) {
            img = "zoom_zoomable_refuel.png";
        }
        if (setZoom) {
            this._zoomImage = img;
        }
        return img;
    }

    this._chooseImageForF4 = function (setZoom) {
        "use strict";
        var img = "zoom_zoomable_dockside.png";
        if (worldScripts.EmailSystem.$totalUnreadItems() > 0) {
            img = "zoom_zoomable_new_mail.png";
        }
        if (setZoom) {
            this._zoomImage = img;
        }
        return img;
    }

    this._imageForF7 = "zoom_zoomable_system_data.png"; // Over-written by infoSystemChanged

    this.infoSystemChanged = function (to, from) {
        "use strict";
        var img = "zoom_zoomable_system_data.png";
        if (worldScripts['Explorers Club']._playerVisited(galaxyNumber, to)) {
            img = "zoom_zoomable_visited_system.png";
        } else {
            let tl = System.infoForSystem(galaxyNumber, to).techlevel;
            if (tl < 6) {
                img = "zoom_zoomable_cavemen.png";
            } else if (tl > 9) {
                img = "zoom_zoomable_futuristic_city.png";
            }
        }
        this._imageForF7 = img;
    }

    this._chooseImageForMission = function (setZoom) {
        var img = getScreenBackgroundForKey("mission");
        if (setZoom) {
            this._zoomImage = img;
        }
        return img;
    }

/* ========================================================
		DUMMY FUNCTIONS

    Dummy versions of _chooseImageForF4 and _chooseImageForF7
    that get substituted during startUp, if the player is a 
    trouble-maker who doesn't have Explorers' Club or EmailSystem.
=========================================================== */

    this._NO_chooseImageForF4 = function (setZoom) {
        var img = "zoom_zoomable_dockside.png";
        if (setZoom) {
            this._zoomImage = img;
        }
        return img;
    }

    this._NO_chooseImageForF7 = function (setZoom) {
        var img = "zoom_zoomable_system_data.png";
        if (setZoom) {
            this._zoomImage = img;
        }
        return img;
    }

/* ========================================================
		AUGUST 3rd, CHANGE OF MIND

    I am no longer minded to select the F7 image from 
    "zoom_zoomable_visited_system.png" or 
    "zoom_zoomable_unvisited_system.png".
    The new plan is to select by technology level, with a 
    range of images, from cave-dwellers to futuristic cities.

    So, 16 technology levels, visited or unvisited, and blue,
    beige or purple image sets, yields:
      16 x 2 x 3 = 96
    I would only need to create 96 images to instantiate
    this idea. This is an example of why you should always
    be wary of feature creep, fellas. 
=========================================================== */

/* ========================================================
                THE ACTUAL END
                      of
    DISTANT SPACE: The Zoom Transitions Effect

          Wolfgang Wildeblood will return
                      in
             THE WITCHES OF MIDDLEMAP


    Copyright (C)2024, All rights reserved.
    This is a proof-of-concept/work-in-progress,
    not for general circulation.
=========================================================== */

/* ========================================================
            ASPIRATIONAL ROADMAP

    A public function for OXPs to register mission screens.
    Post-1: Replace linear zoom function with J-shaped function,
    i.e. zoomStep not fixed at 16.
    Will need to replace _zoomStep with a counter, _stepNum,
    and an array of _stepSizes. So:

    this._zoomStep = this._stepSizes[this._stepNum]

    Will need some arithmetic to verify _stepSizes totals 512.
=========================================================== */