this.name           = "hyperradio";
this.author         = "Svengali";
this.copyright      = "CC-by-nc-sa-3.0";
this.description    = "NON-EQ-Version. Can be expanded with musicpacks. Compatible to OXPConfig.";
this.version        = "1.14.1";

// ********************************************* CHANGE ONLY THIS PART ****************************************************
// Add new or override the following entries to use it as playList
this.hyperradio_playListOriginal = new Array(
	"hyperradio-exampleA.ogg",
	"hyperradio-exampleB.ogg"
);
// ***************************************************************************************************************************
this.stationList = new Array("hyperradio_playListOriginal");

this.startUp = function()
{
	this.logging = false; this.extraA = true; this.extraB = false;
}

this.reset = function()
{
	this.stations = this.stationList.length; this.limit = 0; var counterLimit = this.stations;
	while (counterLimit >= 1) { counterLimit *= 0.5; this.limit++; }
	this.limit = Math.pow(2,this.limit)-1;
	if (this.logging) log('Hyperradio','Hyperradio: Stations found:'+this.stations+' Limit:'+this.limit);
	this.hyperRadio = false; this.canPlay = false; this.addDuration = 0;
	if (!missionVariables.hyperradio_last) { EquipmentInfo.infoForKey("EQ_HYPER_RADIO").effectiveTechLevel = 3; }
}

this.playerBoughtEquipment = function(equipmentKey)
{
	if (equipmentKey == "EQ_HYPER_RADIO") { player.ship.removeEquipment("EQ_HYPER_RADIO"); missionVariables.hyperradio_last = "1";
		this.addDuration = 20; EquipmentInfo.infoForKey("EQ_HYPER_RADIO").effectiveTechLevel = 99; }
}

this.shipWillDockWithStation = function()
{
	if (this.current) Sound.stopMusic(this.current);
	this.canPlay = false; this.CheckHyperradioLicence();
}

this.shipWillLaunchFromStation = function()
{
	if (missionVariables.hyperradio_last || this.addDuration) {
		if (system.isInterstellarSpace) { this.canPlay = false; return; }
		if (this.extraB) { this.stationList.sort(function() { return 0.5-Math.random(); } ); this.extraB = false; }
		if (this.stations > 1) this.SelectHyperradioStation();
		else this.stationSelect = 0; }
}

this.shipLaunchedFromStation = function()
{
	if (missionVariables.hyperradio_last && !system.isInterstellarSpace) {
		this.current = 'start'; this.next = 'start'; this.hyperRadio = true;
		if (missionVariables.hyperradio_last && this.addDuration) missionVariables.hyperradio_last = String(Math.floor(20 + (clock.days)));
		this.canPlay = true; this.addDuration = 0; }
}

this.shipExitedWitchspace = function()
{
	if (this.hyperRadio) {
		if (system.isInterstellarSpace) {
			if (this.current != 'start') Sound.stopMusic(this.current);
			player.commsMessage('Hyperradio deactivated. Could not transfer data.', 8); this.canPlay = false; return; }
		else if (this.stations > 1) this.SelectHyperradioStation();
			else this.stationSelect = 0;
		this.canPlay = true; }
}

this.alertConditionChanged = function()
{
	if (this.hyperRadio) {
		if (player.alertCondition == 3) Sound.stopMusic(this.current);
		else if (player.alertCondition < 3 && !player.ship.docked && !system.isInterstellarSpace) this.canPlay = true; }
}

this.shipLaunchedEscapePod = function()
{
	if (this.extraA) { Sound.stopMusic(this.current); Sound.playMusic('hyperradio-escapepod.ogg'); }
}

this.SelectHyperradioStation = function()
{
	this.stationSelect = system.ID&this.limit;
		if (this.logging) log('Hyperradio','Hyperradio: SELECTEDA:'+this.stationSelect+' in System:'+system.ID);
	if (this.stationSelect == 0 && Math.random() > 0.5) {
		this.stationSelect += Math.floor(Math.random()*(this.stations-1))+1;
		if (this.stationSelect > (this.stations-1)) { this.stationSelect = this.stations-1; }
		if (this.logging) { log('Hyperradio','Hyperradio: SELECTEDB:'+this.stationSelect); } }
	if (this.stationSelect > (this.stations-1)) {
		this.stationSelect -= Math.ceil(Math.random()*(this.stations-1))+1; this.stationSelect = Math.min((this.stations-1),this.stationSelect);
		if (this.logging) { log('Hyperradio','Hyperradio: SELECTEDC:'+this.stationSelect); } }
	return;
}

this.GetHyperradioSongName = function()
{
	var listName = this.stationList[this.stationSelect]; var songNames = worldScripts.hyperradio[listName]; var maxSongs = worldScripts.hyperradio[listName].length-1;
	var songSelect = Math.floor(Math.random()*maxSongs); var songName = songNames[songSelect];
	if (!listName || !songName || !songName.match('.ogg') || maxSongs == -1) {
		player.consoleMessage('Hyperradio: NO VALID ENTRY FOUND! See Logfile for Details.',8);
		log('Hyperradio','Hyperradio: WARNING. NO VALID ENTRY IN PLAYLIST FOUND. Error in:'+listName+' '+songName+' Station:'+this.stationSelect);
		return(false); }
	this.next = songName;
	while (this.current == this.next) { songSelect = Math.floor(Math.random()*maxSongs); this.next = songNames[songSelect]; }
	if (this.logging) log('Hyperradio','Hyperradio: Station:'+listName+' Song:#'+songSelect+' out of #'+maxSongs+' in this list.');
	return(true);
}

this.CheckHyperradioLicence = function()
{
	if (clock.days >= parseInt(missionVariables.hyperradio_last)) {
		this.hyperRadio = false; missionVariables.hyperradio_last = null; player.ship.removeEquipment("EQ_HYPER_RADIO");
		player.consoleMessage('Your HyperRadio license is expired. Buy a new one at your local dealer.', 6);
		this.canPlay = false; EquipmentInfo.infoForKey("EQ_HYPER_RADIO").effectiveTechLevel = 3; return(false); }
	if (system.isInterstellarSpace) return(false);
	return(true);
}

this.guiScreenChanged = function(to)
{
	if (player.ship.status == "STATUS_IN_FLIGHT" && to == "GUI_SCREEN_SYSTEM_DATA") {
		if (this.hyperRadio && this.CheckHyperradioLicence() && this.canPlay) {
			Sound.stopMusic(this.current);
			if (!this.GetHyperradioSongName() || this.next == this.stationList[this.stationSelect]) { this.canPlay = false; return; }
			else { this.current = this.next; player.consoleMessage('Connection established. Days left: '+(missionVariables.hyperradio_last-clock.days)); Sound.playMusic(this.current); } } }
}
